/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolox.util.MutablePoints;
import edu.umd.cs.piccolox.util.Points;
import edu.umd.cs.piccolox.util.XYArray;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LineShape
implements Shape,
MutablePoints {
    private MutablePoints points;
    private Rectangle2D bounds = new Rectangle2D.Double();

    public LineShape(MutablePoints mutablePoints) {
        this.setPoints(mutablePoints);
    }

    public void setPoints(MutablePoints mutablePoints) {
        if (mutablePoints == null) {
            mutablePoints = new XYArray();
        }
        this.points = mutablePoints;
    }

    public int getPointCount() {
        return this.points.getPointCount();
    }

    public double getX(int n) {
        return this.points.getX(n);
    }

    public double getY(int n) {
        return this.points.getY(n);
    }

    public Point2D getPoint(int n, Point2D point2D) {
        return this.points.getPoint(n, point2D);
    }

    public Rectangle2D getBounds(Rectangle2D rectangle2D) {
        this.points.getBounds(rectangle2D);
        return rectangle2D;
    }

    public void updateBounds() {
        this.bounds.setRect(0.0, 0.0, 0.0, 0.0);
        this.points.getBounds(this.bounds);
    }

    public void setPoint(int n, double d, double d2) {
        this.points.setPoint(n, d, d2);
        this.updateBounds();
    }

    public void addPoint(int n, double d, double d2) {
        this.points.addPoint(n, d, d2);
        this.updateBounds();
    }

    public void removePoints(int n, int n2) {
        this.points.removePoints(n, n2);
        this.updateBounds();
    }

    public void transformPoints(AffineTransform affineTransform) {
        XYArray xYArray = new XYArray(this.points.getPointCount());
        xYArray.appendPoints(this.points);
        xYArray.transformPoints(affineTransform);
        this.points = xYArray;
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.bounds.getX(), (int)this.bounds.getY(), (int)this.bounds.getWidth(), (int)this.bounds.getHeight());
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public static boolean contains(double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, double d7) {
        double d8;
        double d9 = d5 - d3;
        double d10 = d6 - d4;
        double d11 = d9 * d9;
        double d12 = d10 * d10;
        if (d9 != 0.0) {
            d8 = ((d - d3) / d9 + d10 * (d2 - d4) / d11) / (1.0 + d12 / d11);
        } else if (d10 != 0.0) {
            d8 = ((d2 - d4) / d10 + d9 * (d - d3) / d12) / (1.0 + d11 / d12);
        } else {
            return false;
        }
        if (bl2 && d8 > 1.0) {
            return false;
        }
        if (bl && d8 < 0.0) {
            return false;
        }
        double d13 = (d9 = d8 * d9 + d3 - d) * d9 + (d10 = d8 * d10 + d4 - d2) * d10;
        return d13 < d7;
    }

    public boolean contains(double d, double d2, double d3) {
        if (this.points.getPointCount() == 0) {
            return false;
        }
        double d4 = this.points.getX(0);
        double d5 = this.points.getX(0);
        for (int i = 0; i < this.points.getPointCount(); ++i) {
            double d6 = d4;
            double d7 = d5;
            if (!LineShape.contains(d, d2, d6, d7, d4 = this.points.getX(i), d5 = this.points.getX(i), false, false, d3)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(double d, double d2) {
        return this.contains(d, d2, 2.0);
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public static boolean intersects(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        double d9;
        double d10;
        double d11 = d3 - d;
        double d12 = d4 - d2;
        double d13 = d7 - d5;
        double d14 = d8 - d6;
        if (d12 != 0.0) {
            double d15 = d11 / d12;
            d10 = (d5 - d + d15 * (d2 - d6)) / (d15 * d14 - d13);
            d9 = (d14 * d10 + d6 - d2) / d12;
        } else if (d14 != 0.0) {
            double d16 = d13 / d14;
            d9 = (d - d5 + d16 * (d6 - d2)) / (d16 * d12 - d11);
            d10 = (d12 * d9 + d2 - d6) / d14;
        } else if (d11 != 0.0) {
            double d17 = d12 / d11;
            d10 = (d6 - d2 + d17 * (d - d5)) / (d17 * d13 - d14);
            d9 = (d13 * d10 + d5 - d) / d11;
        } else if (d13 != 0.0) {
            double d18 = d14 / d13;
            d9 = (d2 - d6 + d18 * (d5 - d)) / (d18 * d11 - d12);
            d10 = (d11 * d9 + d - d5) / d13;
        } else {
            return false;
        }
        return !(bl && !(d9 >= 0.0) || bl2 && !(d9 <= 1.0) || bl3 && !(d10 >= 0.0) || bl4 && !(d10 <= 1.0));
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.points.getPointCount() == 0) {
            return false;
        }
        double d5 = this.points.getX(0);
        double d6 = this.points.getX(0);
        for (int i = 0; i < this.points.getPointCount(); ++i) {
            double d7 = d5;
            double d8 = d6;
            if (!LineShape.intersects(d, d2, d + d3, d2, d7, d8, d5 = this.points.getX(i), d6 = this.points.getX(i), true, true, true, true) && !LineShape.intersects(d + d3, d2, d + d3, d2 + d4, d7, d8, d5, d6, true, true, true, true) && !LineShape.intersects(d + d3, d2 + d4, d, d2 + d4, d7, d8, d5, d6, true, true, true, true) && !LineShape.intersects(d, d2 + d4, d, d2, d7, d8, d5, d6, true, true, true, true)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) && this.contains(d + d3, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new LinePathIterator(this.points, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new LinePathIterator(this.points, affineTransform);
    }

    private static class LinePathIterator
    implements PathIterator {
        private Points points;
        private AffineTransform trans;
        private int i = 0;
        private Point2D tempPoint = new Point2D.Double();

        public LinePathIterator(Points points, AffineTransform affineTransform) {
            this.points = points;
            this.trans = affineTransform;
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.i >= this.points.getPointCount();
        }

        public void next() {
            ++this.i;
        }

        private void currentSegment() {
            this.tempPoint.setLocation(this.points.getX(this.i), this.points.getY(this.i));
            if (this.trans != null) {
                this.trans.transform(this.tempPoint, this.tempPoint);
            }
        }

        public int currentSegment(float[] fArray) {
            this.currentSegment();
            fArray[0] = (float)this.tempPoint.getX();
            fArray[1] = (float)this.tempPoint.getY();
            return this.i == 0 ? 0 : 1;
        }

        public int currentSegment(double[] dArray) {
            this.currentSegment();
            dArray[0] = this.tempPoint.getX();
            dArray[1] = this.tempPoint.getY();
            return this.i == 0 ? 0 : 1;
        }
    }
}

