/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PAffineTransform
extends AffineTransform {
    private static double[] PTS1 = new double[8];
    private static double[] PTS2 = new double[8];

    public PAffineTransform() {
    }

    public PAffineTransform(double[] dArray) {
        super(dArray);
    }

    public PAffineTransform(float[] fArray) {
        super(fArray);
    }

    public PAffineTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d, d2, d3, d4, d5, d6);
    }

    public PAffineTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        super(f, f2, f3, f4, f5, f6);
    }

    public PAffineTransform(AffineTransform affineTransform) {
        super(affineTransform);
    }

    public void scaleAboutPoint(double d, double d2, double d3) {
        this.translate(d2, d3);
        this.scale(d, d);
        this.translate(-d2, -d3);
    }

    public double getScale() {
        PAffineTransform.PTS1[0] = 0.0;
        PAffineTransform.PTS1[1] = 0.0;
        PAffineTransform.PTS1[2] = 1.0;
        PAffineTransform.PTS1[3] = 0.0;
        this.transform(PTS1, 0, PTS2, 0, 2);
        return Point2D.distance(PTS2[0], PTS2[1], PTS2[2], PTS2[3]);
    }

    public void setScale(double d) {
        this.scaleAboutPoint(d / this.getScale(), 0.0, 0.0);
    }

    public void setOffset(double d, double d2) {
        this.setTransform(this.getScaleX(), this.getShearY(), this.getShearX(), this.getScaleY(), d, d2);
    }

    public double getRotation() {
        PAffineTransform.PTS1[0] = 0.0;
        PAffineTransform.PTS1[1] = 0.0;
        PAffineTransform.PTS1[2] = 1.0;
        PAffineTransform.PTS1[3] = 0.0;
        this.transform(PTS1, 0, PTS2, 0, 2);
        double d = Math.abs(PTS2[3] - PTS2[1]);
        double d2 = Point2D.distance(PTS2[0], PTS2[1], PTS2[2], PTS2[3]);
        double d3 = Math.asin(d / d2);
        if (PTS2[3] - PTS2[1] > 0.0) {
            if (PTS2[2] - PTS2[0] < 0.0) {
                d3 = Math.PI - d3;
            }
        } else {
            d3 = PTS2[2] - PTS2[0] > 0.0 ? Math.PI * 2 - d3 : (d3 += Math.PI);
        }
        return d3;
    }

    public void setRotation(double d) {
        this.rotate(d - this.getRotation());
    }

    public Dimension2D transform(Dimension2D dimension2D, Dimension2D dimension2D2) {
        if (dimension2D2 == null) {
            dimension2D2 = (Dimension2D)dimension2D.clone();
        }
        PAffineTransform.PTS1[0] = dimension2D.getWidth();
        PAffineTransform.PTS1[1] = dimension2D.getHeight();
        this.deltaTransform(PTS1, 0, PTS2, 0, 1);
        dimension2D2.setSize(PTS2[0], PTS2[1]);
        return dimension2D2;
    }

    public Dimension2D inverseTransform(Dimension2D dimension2D, Dimension2D dimension2D2) {
        if (dimension2D2 == null) {
            dimension2D2 = (Dimension2D)dimension2D.clone();
        }
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        double d3 = this.getScaleX();
        double d4 = this.getScaleY();
        double d5 = this.getShearX();
        double d6 = this.getShearY();
        double d7 = d3 * d4 - d5 * d6;
        try {
            if (Math.abs(d7) <= Double.MIN_VALUE) {
                throw new NoninvertibleTransformException("Determinant is " + d7);
            }
            dimension2D2.setSize((d * d4 - d2 * d5) / d7, (d2 * d3 - d * d6) / d7);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        return dimension2D2;
    }

    public Rectangle2D transform(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D2 == null) {
            rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        }
        if (rectangle2D.isEmpty()) {
            rectangle2D2.setRect(rectangle2D);
            if (rectangle2D2 instanceof PBounds) {
                ((PBounds)rectangle2D2).reset();
            }
            return rectangle2D2;
        }
        switch (this.getType()) {
            case 0: {
                if (rectangle2D == rectangle2D2) break;
                rectangle2D2.setRect(rectangle2D);
                break;
            }
            case 1: {
                rectangle2D2.setRect(rectangle2D.getX() + this.getTranslateX(), rectangle2D.getY() + this.getTranslateY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 2: {
                double d = this.getScaleX();
                rectangle2D2.setRect(rectangle2D.getX() * d, rectangle2D.getY() * d, rectangle2D.getWidth() * d, rectangle2D.getHeight() * d);
                break;
            }
            case 3: {
                double d = this.getScaleX();
                rectangle2D2.setRect(rectangle2D.getX() * d + this.getTranslateX(), rectangle2D.getY() * d + this.getTranslateY(), rectangle2D.getWidth() * d, rectangle2D.getHeight() * d);
                break;
            }
            default: {
                double[] dArray = PAffineTransform.rectToArray(rectangle2D);
                this.transform(dArray, 0, dArray, 0, 4);
                PAffineTransform.rectFromArray(rectangle2D2, dArray);
            }
        }
        return rectangle2D2;
    }

    public Rectangle2D inverseTransform(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D2 == null) {
            rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        }
        if (rectangle2D.isEmpty()) {
            rectangle2D2.setRect(rectangle2D);
            if (rectangle2D2 instanceof PBounds) {
                ((PBounds)rectangle2D2).reset();
            }
            return rectangle2D2;
        }
        switch (this.getType()) {
            case 0: {
                if (rectangle2D == rectangle2D2) break;
                rectangle2D2.setRect(rectangle2D);
                break;
            }
            case 1: {
                rectangle2D2.setRect(rectangle2D.getX() - this.getTranslateX(), rectangle2D.getY() - this.getTranslateY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                break;
            }
            case 2: {
                double d = 1.0 / this.getScaleX();
                rectangle2D2.setRect(rectangle2D.getX() * d, rectangle2D.getY() * d, rectangle2D.getWidth() * d, rectangle2D.getHeight() * d);
                break;
            }
            case 3: {
                double d = 1.0 / this.getScaleX();
                rectangle2D2.setRect((rectangle2D.getX() - this.getTranslateX()) * d, (rectangle2D.getY() - this.getTranslateY()) * d, rectangle2D.getWidth() * d, rectangle2D.getHeight() * d);
                break;
            }
            default: {
                double[] dArray = PAffineTransform.rectToArray(rectangle2D);
                try {
                    this.inverseTransform(dArray, 0, dArray, 0, 4);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    noninvertibleTransformException.printStackTrace();
                }
                PAffineTransform.rectFromArray(rectangle2D2, dArray);
            }
        }
        return rectangle2D2;
    }

    private static double[] rectToArray(Rectangle2D rectangle2D) {
        PAffineTransform.PTS1[0] = rectangle2D.getX();
        PAffineTransform.PTS1[1] = rectangle2D.getY();
        PAffineTransform.PTS1[2] = PTS1[0] + rectangle2D.getWidth();
        PAffineTransform.PTS1[3] = PTS1[1];
        PAffineTransform.PTS1[4] = PTS1[0] + rectangle2D.getWidth();
        PAffineTransform.PTS1[5] = PTS1[1] + rectangle2D.getHeight();
        PAffineTransform.PTS1[6] = PTS1[0];
        PAffineTransform.PTS1[7] = PTS1[1] + rectangle2D.getHeight();
        return PTS1;
    }

    private static void rectFromArray(Rectangle2D rectangle2D, double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[0];
        double d4 = dArray[1];
        for (int i = 1; i < 4; ++i) {
            double d5 = dArray[2 * i];
            double d6 = dArray[2 * i + 1];
            if (d5 < d) {
                d = d5;
            }
            if (d6 < d2) {
                d2 = d6;
            }
            if (d5 > d3) {
                d3 = d5;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        rectangle2D.setRect(d, d2, d3 - d, d4 - d2);
    }
}

