/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PPath
extends PNode {
    public static final String PROPERTY_STROKE_PAINT = "strokePaint";
    public static final String PROPERTY_STROKE = "stroke";
    public static final String PROPERTY_PATH = "path";
    private static final Rectangle2D.Float TEMP_RECTANGLE = new Rectangle2D.Float();
    private static final Ellipse2D.Float TEMP_ELLIPSE = new Ellipse2D.Float();
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private transient GeneralPath path;
    private transient GeneralPath resizePath;
    private transient Stroke stroke;
    private transient boolean updatingBoundsFromPath;
    private Paint strokePaint = DEFAULT_STROKE_PAINT;

    public static PPath createRectangle(float f, float f2, float f3, float f4) {
        TEMP_RECTANGLE.setFrame(f, f2, f3, f4);
        PPath pPath = new PPath(TEMP_RECTANGLE);
        pPath.setPaint(Color.white);
        return pPath;
    }

    public static PPath createEllipse(float f, float f2, float f3, float f4) {
        TEMP_ELLIPSE.setFrame(f, f2, f3, f4);
        PPath pPath = new PPath(TEMP_ELLIPSE);
        pPath.setPaint(Color.white);
        return pPath;
    }

    public static PPath createLine(float f, float f2, float f3, float f4) {
        PPath pPath = new PPath();
        pPath.moveTo(f, f2);
        pPath.lineTo(f3, f4);
        pPath.setPaint(Color.white);
        return pPath;
    }

    public static PPath createPolyline(Point2D[] point2DArray) {
        PPath pPath = new PPath();
        pPath.setPathToPolyline(point2DArray);
        pPath.setPaint(Color.white);
        return pPath;
    }

    public static PPath createPolyline(float[] fArray, float[] fArray2) {
        PPath pPath = new PPath();
        pPath.setPathToPolyline(fArray, fArray2);
        pPath.setPaint(Color.white);
        return pPath;
    }

    public PPath() {
        this.stroke = DEFAULT_STROKE;
        this.path = new GeneralPath();
    }

    public PPath(Shape shape) {
        this(shape, DEFAULT_STROKE);
    }

    public PPath(Shape shape, Stroke stroke) {
        this();
        this.stroke = stroke;
        if (shape != null) {
            this.append(shape, false);
        }
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Paint paint) {
        Paint paint2 = this.strokePaint;
        this.strokePaint = paint;
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_STROKE_PAINT, paint2, this.strokePaint);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.stroke;
        this.stroke = stroke;
        this.updateBoundsFromPath();
        this.invalidatePaint();
        this.firePropertyChange(PROPERTY_STROKE, stroke2, this.stroke);
    }

    public void startResizeBounds() {
        this.resizePath = new GeneralPath(this.path);
    }

    public void endResizeBounds() {
        this.resizePath = null;
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        if (this.updatingBoundsFromPath) {
            return;
        }
        if (this.path == null) {
            return;
        }
        if (this.resizePath != null) {
            this.path.reset();
            this.path.append(this.resizePath, false);
        }
        Rectangle2D rectangle2D = this.path.getBounds2D();
        Rectangle2D rectangle2D2 = this.getPathBoundsWithStroke();
        double d5 = Math.max(rectangle2D2.getWidth() - rectangle2D.getWidth(), rectangle2D2.getHeight() - rectangle2D.getHeight());
        TEMP_TRANSFORM.setToIdentity();
        TEMP_TRANSFORM.translate(d += d5 / 2.0, d2 += d5 / 2.0);
        TEMP_TRANSFORM.scale((d3 -= d5) / rectangle2D.getWidth(), (d4 -= d5) / rectangle2D.getHeight());
        TEMP_TRANSFORM.translate(-rectangle2D.getX(), -rectangle2D.getY());
        this.path.transform(TEMP_TRANSFORM);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (super.intersects(rectangle2D)) {
            if (this.getPaint() != null && this.path.intersects(rectangle2D)) {
                return true;
            }
            if (this.stroke != null && this.strokePaint != null) {
                return this.stroke.createStrokedShape(this.path).intersects(rectangle2D);
            }
        }
        return false;
    }

    public Rectangle2D getPathBoundsWithStroke() {
        if (this.stroke != null) {
            return this.stroke.createStrokedShape(this.path).getBounds2D();
        }
        return this.path.getBounds2D();
    }

    public void updateBoundsFromPath() {
        this.updatingBoundsFromPath = true;
        if (this.path == null) {
            this.resetBounds();
        } else {
            Rectangle2D rectangle2D = this.getPathBoundsWithStroke();
            this.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        this.updatingBoundsFromPath = false;
    }

    protected void paint(PPaintContext pPaintContext) {
        Paint paint = this.getPaint();
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(this.path);
        }
        if (this.stroke != null && this.strokePaint != null) {
            graphics2D.setPaint(this.strokePaint);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(this.path);
        }
    }

    public GeneralPath getPathReference() {
        return this.path;
    }

    public void moveTo(float f, float f2) {
        this.path.moveTo(f, f2);
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void lineTo(float f, float f2) {
        this.path.lineTo(f, f2);
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        this.path.quadTo(f, f2, f3, f4);
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.path.curveTo(f, f2, f3, f4, f5, f6);
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void append(Shape shape, boolean bl) {
        this.path.append(shape, bl);
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void setPathTo(Shape shape) {
        this.path.reset();
        this.append(shape, false);
    }

    public void setPathToRectangle(float f, float f2, float f3, float f4) {
        TEMP_RECTANGLE.setFrame(f, f2, f3, f4);
        this.setPathTo(TEMP_RECTANGLE);
    }

    public void setPathToEllipse(float f, float f2, float f3, float f4) {
        TEMP_ELLIPSE.setFrame(f, f2, f3, f4);
        this.setPathTo(TEMP_ELLIPSE);
    }

    public void setPathToPolyline(Point2D[] point2DArray) {
        this.path.reset();
        this.path.moveTo((float)point2DArray[0].getX(), (float)point2DArray[0].getY());
        for (int i = 1; i < point2DArray.length; ++i) {
            this.path.lineTo((float)point2DArray[i].getX(), (float)point2DArray[i].getY());
        }
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void setPathToPolyline(float[] fArray, float[] fArray2) {
        this.path.reset();
        this.path.moveTo(fArray[0], fArray2[0]);
        for (int i = 1; i < fArray.length; ++i) {
            this.path.lineTo(fArray[i], fArray2[i]);
        }
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void closePath() {
        this.path.closePath();
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void reset() {
        this.path.reset();
        this.firePropertyChange(PROPERTY_PATH, null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        PUtil.writeStroke(this.stroke, objectOutputStream);
        PUtil.writePath(this.path, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stroke = PUtil.readStroke(objectInputStream);
        this.path = PUtil.readPath(objectInputStream);
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("path=" + (this.path == null ? "null" : this.path.toString()));
        stringBuffer.append(",stroke=" + (this.stroke == null ? "null" : this.stroke.toString()));
        stringBuffer.append(",strokePaint=" + (this.strokePaint == null ? "null" : this.strokePaint.toString()));
        stringBuffer.append(',');
        stringBuffer.append(super.paramString());
        return stringBuffer.toString();
    }
}

