/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.core.DataSetCore;
import edu.cmu.cs.sb.core.StatUtil;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.STEM_GoAnnotations;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;

public class STEM_DataSet
extends DataSetCore {
    public static double DSAME = 1.2;
    public static double FLOATERROR = 1.0E-7;
    public static int ALLPERMSTHRESH = 9;
    STEM_GoAnnotations tga;
    boolean bkmeans = false;
    double[] countassignments;
    double[] expectedassignments;
    double[] pvaluesassignments;
    ArrayList[] profilesAssigned;
    double dmaxminclustdist;
    int nsamplesgene = -1;
    long nsamplesmodel;
    STEM_DataSet otherset = null;
    boolean bothersetorigset = true;
    ArrayList[] bestassignments;
    double[][] modelprofiles;
    int nfdr;
    boolean[] significantnum;
    double[] dwidthunitsCum;
    double alpha;
    boolean ballpermuteval;
    int nmaxprofiles;
    ArrayList clustersofprofilesnum = new ArrayList();
    double dminclustdist = 0.7;
    double dpercentileclust = 0.0;
    double dmaxcorrmodel = DSAME;
    int nmaxchange = 1;
    public double[][] profileavg;
    public double[][] profilestd;
    public double[][] profilesumsq;

    public STEM_DataSet(DataSetCore dataSetCore, STEM_DataSet sTEM_DataSet) {
        super(dataSetCore);
        this.tga = sTEM_DataSet.tga;
        this.bkmeans = sTEM_DataSet.bkmeans;
        this.countassignments = sTEM_DataSet.countassignments;
        this.expectedassignments = sTEM_DataSet.expectedassignments;
        this.pvaluesassignments = sTEM_DataSet.pvaluesassignments;
        this.profilesAssigned = sTEM_DataSet.profilesAssigned;
        this.dmaxminclustdist = sTEM_DataSet.dmaxminclustdist;
        this.nsamplesgene = sTEM_DataSet.nsamplesgene;
        this.nsamplesmodel = sTEM_DataSet.nsamplesmodel;
        this.otherset = sTEM_DataSet.otherset;
        this.bothersetorigset = sTEM_DataSet.bothersetorigset;
        this.bestassignments = sTEM_DataSet.bestassignments;
        this.modelprofiles = sTEM_DataSet.modelprofiles;
        this.profileavg = sTEM_DataSet.profileavg;
        this.profilestd = sTEM_DataSet.profilestd;
        this.profilesumsq = sTEM_DataSet.profilesumsq;
        this.alpha = sTEM_DataSet.alpha;
        this.ballpermuteval = sTEM_DataSet.ballpermuteval;
        this.nmaxprofiles = sTEM_DataSet.nmaxprofiles;
        this.clustersofprofilesnum = sTEM_DataSet.clustersofprofilesnum;
        this.dminclustdist = sTEM_DataSet.dminclustdist;
        this.nfdr = sTEM_DataSet.nfdr;
        this.significantnum = sTEM_DataSet.significantnum;
        this.dpercentileclust = sTEM_DataSet.dpercentileclust;
        this.dmaxcorrmodel = sTEM_DataSet.dmaxcorrmodel;
        this.nmaxchange = sTEM_DataSet.nmaxchange;
        this.dwidthunitsCum = sTEM_DataSet.dwidthunitsCum;
    }

    public STEM_DataSet(String string, int n, double d, double d2, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IOException, FileNotFoundException, IllegalArgumentException {
        this.szInputFile = string;
        this.bfullrepeat = bl6;
        this.bkmeans = true;
        this.nmaxmissing = n;
        this.dthresholdvalue = d;
        this.dmincorrelation = d2;
        this.nmaxprofiles = n2;
        this.nmaxchange = n3;
        this.badd0 = bl4;
        this.btakelog = bl;
        this.bspotincluded = bl2;
        this.bmaxminval = bl5;
        this.dataSetReader(string, n, d, d2, bl, bl2, bl3, bl4);
    }

    public STEM_DataSet(String string, int n, double d, double d2, double d3, double d4, double d5, int n2, int n3, double d6, int n4, long l, double[][] dArray, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws IOException, FileNotFoundException, IllegalArgumentException {
        this.bfullrepeat = bl7;
        this.szInputFile = string;
        this.nmaxmissing = n;
        this.nsamplesgene = n4;
        this.nsamplesmodel = l;
        this.dthresholdvalue = d2;
        this.dmincorrelation = d3;
        this.dminclustdist = d;
        this.alpha = d4;
        this.dpercentileclust = d5;
        this.nmaxchange = n2;
        this.nmaxprofiles = n3;
        this.dmaxcorrmodel = d6;
        this.nfdr = n5;
        this.btakelog = bl;
        this.bspotincluded = bl2;
        this.badd0 = bl4;
        this.bmaxminval = bl5;
        this.ballpermuteval = bl6;
        this.dataSetReader(string, n, d2, d3, bl, bl2, bl3, bl4);
        if (dArray == null) {
            this.generatemodelprofiles(this.numcols, n2);
        } else {
            this.modelprofiles = dArray;
        }
    }

    public void tallyassignments() {
        int n;
        this.countassignments = new double[this.modelprofiles.length];
        for (n = 0; n < this.modelprofiles.length; ++n) {
            this.countassignments[n] = 0.0;
        }
        for (n = 0; n < this.numrows; ++n) {
            ArrayList arrayList = this.bestassignments[n];
            int n2 = arrayList.size();
            double d = 1.0 / (double)n2;
            for (int i = 0; i < n2; ++i) {
                int n3 = (Integer)arrayList.get(i);
                this.countassignments[n3] = this.countassignments[n3] + d;
            }
        }
    }

    public void computeprofilestats() {
        int n = this.modelprofiles[0].length - 1;
        this.profileavg = new double[this.modelprofiles.length][n];
        this.profilestd = new double[this.modelprofiles.length][n];
        this.profilesumsq = new double[this.modelprofiles.length][n];
        for (int i = 0; i < this.modelprofiles.length; ++i) {
            int n2;
            int n3;
            ArrayList arrayList = this.profilesAssigned[i];
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            double d = 0.0;
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                dArray[n3] = 0.0;
                dArray2[n3] = 0.0;
            }
            n3 = arrayList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                int n5 = (Integer)arrayList.get(n2);
                double d2 = 1.0 / (double)this.bestassignments[n5].size();
                for (int j = 0; j < n; ++j) {
                    int n6 = j;
                    dArray[n6] = dArray[n6] + d2 * this.data[n5][j + 1];
                    int n7 = j;
                    dArray2[n7] = dArray2[n7] + d2 * Math.pow(this.data[n5][j + 1], 2.0);
                }
                ++n4;
                d += d2;
            }
            for (n2 = 0; n2 < n; ++n2) {
                this.profileavg[i][n2] = d > 0.0 ? dArray[n2] / d : 0.0;
                this.profilesumsq[i][n2] = dArray2[n2];
                if (n4 > 1) {
                    double d3 = (double)n4 / (double)(n4 - 1) * (dArray2[n2] / d - Math.pow(dArray[n2] / d, 2.0));
                    this.profilestd[i][n2] = Math.sqrt(d3);
                    continue;
                }
                this.profilestd[i][n2] = 0.0;
            }
        }
    }

    public void computePvaluesAssignments() {
        this.significantnum = new boolean[this.expectedassignments.length];
        this.pvaluesassignments = new double[this.expectedassignments.length];
        for (int i = 0; i < this.expectedassignments.length; ++i) {
            double d = this.expectedassignments[i] / (double)this.numrows;
            this.pvaluesassignments[i] = StatUtil.binomialtail((int)Math.ceil(this.countassignments[i] - 1.0), this.numrows, d);
        }
        if (this.nfdr == 1) {
            double[] dArray = new double[this.modelprofiles.length];
            System.arraycopy(this.pvaluesassignments, 0, dArray, 0, this.modelprofiles.length);
            Arrays.sort(dArray);
            int n = 0;
            double d = 0.0;
            while (dArray[n] < (double)(n + 1) * this.alpha / (double)this.modelprofiles.length) {
                d = dArray[n];
                ++n;
            }
            for (int i = 0; i < this.modelprofiles.length; ++i) {
                this.significantnum[i] = this.pvaluesassignments[i] <= d;
            }
        } else {
            double d = this.nfdr == 0 ? this.alpha : this.alpha / (double)this.modelprofiles.length;
            for (int i = 0; i < this.expectedassignments.length; ++i) {
                this.significantnum[i] = this.pvaluesassignments[i] < d && this.countassignments[i] > 1.0;
            }
        }
    }

    public void kmeans() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.nmaxprofiles > this.data.length) {
            throw new IllegalArgumentException("More clusters (" + this.nmaxprofiles + ") requested than genes passing filter (" + this.data.length + ")");
        }
        double[][] dArray = new double[this.data.length][this.data[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray[i][j] = this.data[i][j];
            }
        }
        int[] nArray = new int[this.pmavalues.length];
        int[] nArray2 = new int[this.pmavalues.length];
        double[][] dArray2 = new double[this.nmaxprofiles][this.data[0].length];
        double[][] dArray3 = null;
        ArrayList[] arrayListArray = new ArrayList[this.data.length];
        ArrayList[] arrayListArray2 = null;
        double d = 0.0;
        Random random = new Random(2211L);
        for (int i = 0; i < this.nmaxchange; ++i) {
            int n5;
            int n6;
            int n7;
            int n8;
            n4 = 0;
            n3 = 0;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                boolean bl = true;
                for (n = 0; bl && n < this.pmavalues[n2].length; ++n) {
                    if (this.pmavalues[n2][n] != 0) continue;
                    bl = false;
                }
                if (bl) {
                    nArray[n4] = n2;
                    ++n4;
                    continue;
                }
                nArray2[n3] = n2;
                ++n3;
            }
            n2 = Math.min(dArray2.length, n4);
            int[] nArray3 = new int[dArray2.length];
            for (n = 0; n < n2; ++n) {
                nArray3[n] = n;
            }
            for (n = n2; n < n4; ++n) {
                if (!(random.nextDouble() < (double)n2 / (double)(n + 1))) continue;
                nArray3[(int)Math.floor((double)((double)n2 * random.nextDouble()))] = n;
            }
            if (n4 < dArray2.length) {
                n = dArray2.length - n4;
                for (n8 = 0; n8 < n; ++n8) {
                    nArray3[n8 + n4] = n8;
                }
                for (n8 = n; n8 < n3; ++n8) {
                    if (!(random.nextDouble() < (double)n / (double)(n8 + 1))) continue;
                    nArray3[(int)Math.floor((double)((double)n * random.nextDouble())) + n4] = n8;
                }
                for (n8 = n4; n8 < nArray3.length; ++n8) {
                    for (n7 = 0; n7 < this.pmavalues[nArray3[n8]].length; ++n7) {
                        if (this.pmavalues[nArray3[n8]][n7] != 0) continue;
                        dArray[nArray3[n8]][n7] = 2.0 * random.nextDouble() - 1.0;
                    }
                }
            }
            for (n = 0; n < n2; ++n) {
                n8 = nArray3[n];
                for (n7 = 0; n7 < dArray2[0].length; ++n7) {
                    dArray2[n][n7] = dArray[nArray[n8]][n7];
                }
            }
            for (n = n2; n < dArray2.length; ++n) {
                n8 = nArray3[n];
                for (n7 = 0; n7 < dArray2[0].length; ++n7) {
                    dArray2[n][n7] = dArray[nArray2[n8]][n7];
                }
            }
            n = 1;
            double[] dArray4 = new double[this.data.length];
            double[][] dArray5 = new double[this.nmaxprofiles][this.data[0].length];
            double[][] dArray6 = new double[this.nmaxprofiles][this.data[0].length];
            while (n != 0) {
                n = 0;
                for (int j = 0; j < dArray5.length; ++j) {
                    for (int k = 0; k < dArray5[0].length; ++k) {
                        dArray5[j][k] = 0.0;
                        dArray6[j][k] = 0.0;
                    }
                }
                for (n6 = 0; n6 < dArray.length; ++n6) {
                    boolean bl;
                    int n9;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    arrayList.add(new Integer(0));
                    dArray4[n6] = Util.distortion(dArray[n6], dArray2[0], this.pmavalues[n6]);
                    for (n5 = 1; n5 < this.nmaxprofiles; ++n5) {
                        double d2 = Util.distortion(dArray[n6], dArray2[n5], this.pmavalues[n6]);
                        if (d2 < dArray4[n6]) {
                            dArray4[n6] = d2;
                            arrayList = new ArrayList();
                            arrayList.add(new Integer(n5));
                            continue;
                        }
                        if (d2 != dArray4[n6]) continue;
                        arrayList.add(new Integer(n5));
                    }
                    for (n5 = 0; n5 < dArray5[0].length; ++n5) {
                        if (this.pmavalues[n6][n5] == 0) continue;
                        n9 = arrayList.size();
                        double d3 = 1.0 / (double)n9;
                        for (int j = 0; j < n9; ++j) {
                            int n10 = (Integer)arrayList.get(j);
                            double[] dArray7 = dArray5[n10];
                            int n11 = n5;
                            dArray7[n11] = dArray7[n11] + d3 * dArray[n6][n5];
                            double[] dArray8 = dArray6[n10];
                            int n12 = n5;
                            dArray8[n12] = dArray8[n12] + d3;
                        }
                    }
                    n5 = 0;
                    n9 = arrayList.size();
                    boolean bl2 = bl = arrayListArray[n6] != null && arrayListArray[n6].size() == n9;
                    while (bl && n5 < n9) {
                        if (arrayList.get(n5).equals(arrayListArray[n6].get(n5))) {
                            ++n5;
                            continue;
                        }
                        bl = false;
                    }
                    if (bl) continue;
                    arrayListArray[n6] = arrayList;
                    n = 1;
                }
                for (n6 = 0; n6 < dArray5.length; ++n6) {
                    for (int j = 0; j < dArray5[0].length; ++j) {
                        if (!(dArray6[n6][j] > 0.0)) continue;
                        dArray2[n6][j] = dArray5[n6][j] / dArray6[n6][j];
                    }
                }
            }
            double d4 = 0.0;
            for (n6 = 0; n6 < dArray.length; ++n6) {
                int n13 = arrayListArray[n6].size();
                for (n5 = 0; n5 < n13; ++n5) {
                    d4 += 1.0 / (double)n13 * Util.distortion(dArray[n6], dArray2[(Integer)arrayListArray[n6].get(n5)], this.pmavalues[n6]);
                }
            }
            if (i != 0 && !(d4 < d)) continue;
            dArray3 = dArray2;
            arrayListArray2 = arrayListArray;
            d = d4;
        }
        CenterRec[] centerRecArray = new CenterRec[dArray3.length];
        for (n4 = 0; n4 < centerRecArray.length; ++n4) {
            centerRecArray[n4] = new CenterRec(dArray3[n4], n4);
        }
        Arrays.sort(centerRecArray, new CenterRecCompare());
        int[] nArray4 = new int[centerRecArray.length];
        this.modelprofiles = new double[dArray2.length][];
        for (n3 = 0; n3 < centerRecArray.length; ++n3) {
            this.modelprofiles[n3] = centerRecArray[n3].center;
            nArray4[centerRecArray[n3].norigid] = n3;
        }
        this.bestassignments = new ArrayList[this.numrows];
        this.profilesAssigned = new ArrayList[this.modelprofiles.length];
        this.countassignments = new double[this.modelprofiles.length];
        this.expectedassignments = new double[this.modelprofiles.length];
        this.pvaluesassignments = new double[this.modelprofiles.length];
        this.significantnum = new boolean[this.modelprofiles.length];
        for (n3 = 0; n3 < this.modelprofiles.length; ++n3) {
            this.profilesAssigned[n3] = new ArrayList();
            this.countassignments[n3] = 0.0;
            this.expectedassignments[n3] = -1.0;
            this.pvaluesassignments[n3] = 1.0;
            this.significantnum[n3] = false;
        }
        for (n3 = 0; n3 < this.numrows; ++n3) {
            this.bestassignments[n3] = new ArrayList();
            n2 = arrayListArray2[n3].size();
            for (int i = 0; i < n2; ++i) {
                n = nArray4[(Integer)arrayListArray2[n3].get(i)];
                this.bestassignments[n3].add(new Integer(n));
                this.profilesAssigned[n].add(new Integer(n3));
                int n14 = n;
                this.countassignments[n14] = this.countassignments[n14] + 1.0 / (double)n2;
            }
        }
    }

    void generatemodelprofiles(int n, int n2) {
        if (n <= 1) {
            this.modelprofiles = null;
        } else {
            if (Math.pow(2 * n2 + 1, n - 1) < (double)this.nsamplesmodel) {
                int n3;
                int n4;
                System.out.println("Generating all candidate model profiles");
                double[][] dArray = STEM_DataSet.generatemodelprofilesall(n, n2);
                this.modelprofiles = new double[dArray.length - 1][n];
                for (n4 = 0; n4 < this.modelprofiles.length / 2; ++n4) {
                    for (n3 = 0; n3 < n; ++n3) {
                        this.modelprofiles[n4][n3] = dArray[n4][n3];
                    }
                }
                for (n4 = this.modelprofiles.length / 2 + 1; n4 < dArray.length; ++n4) {
                    for (n3 = 0; n3 < n; ++n3) {
                        this.modelprofiles[n4 - 1][n3] = dArray[n4][n3];
                    }
                }
            } else {
                System.out.println("Sampling Candidate Model Profiles");
                this.modelprofiles = this.generatemodelsampled(n, n2);
            }
            this.compactprofiles2(this.dmaxcorrmodel, this.nmaxprofiles);
        }
    }

    double[][] generatemodelsampled(int n, int n2) {
        int n3;
        double[][] dArray = new double[(int)this.nsamplesmodel][n];
        Random random = new Random(3733246L);
        dArray[0][0] = 0.0;
        for (n3 = 1; n3 < n; ++n3) {
            dArray[0][n3] = dArray[0][n3 - 1] - (double)n2;
        }
        n3 = 1;
        while ((long)n3 < this.nsamplesmodel) {
            dArray[n3][0] = 0.0;
            for (int i = 1; i < n; ++i) {
                dArray[n3][i] = dArray[n3][i - 1] + Math.floor(random.nextDouble() * (double)(2 * n2 + 1) - (double)n2);
            }
            ++n3;
        }
        return dArray;
    }

    public boolean closeToAllNeighbors(ProfileRec profileRec, TreeSet treeSet) {
        Iterator iterator = treeSet.iterator();
        boolean bl = true;
        while (iterator.hasNext() && bl) {
            ProfileRec profileRec2 = ((ProfileRecDist)iterator.next()).theProfileRec;
            if (!(Util.correlation(this.modelprofiles[profileRec.nprofileindex], this.modelprofiles[profileRec2.nprofileindex]) < this.dmaxminclustdist)) continue;
            bl = false;
        }
        return bl;
    }

    public void clusterprofiles(boolean[] blArray, ArrayList arrayList, boolean bl) throws Exception {
        int n;
        int n2;
        this.dmaxminclustdist = this.dminclustdist;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        if (this.sortedcorrvals != null && this.dpercentileclust >= 0.0) {
            n2 = (int)Math.min((double)(this.sortedcorrvals.length - 1), Math.floor(this.dpercentileclust * (double)this.sortedcorrvals.length));
            System.out.println("Minimum correlation for clustering based on percentile: " + numberFormat.format(this.sortedcorrvals[n2]));
            if (this.sortedcorrvals[n2] > this.dmaxminclustdist) {
                this.dmaxminclustdist = this.sortedcorrvals[n2];
            }
        }
        n2 = this.modelprofiles.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (blArray[i] != bl) continue;
            ++n3;
        }
        ArrayList<ProfileRec> arrayList2 = new ArrayList<ProfileRec>();
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            ProfileRec profileRec = new ProfileRec(n, this.countassignments[n], this.expectedassignments[n], this.pvaluesassignments[n]);
            if (blArray[n] != bl) continue;
            arrayList2.add(profileRec);
        }
        while ((n = arrayList2.size()) > 0) {
            Object object;
            Object object2;
            double d = 0.0;
            Object object3 = new TreeSet();
            for (int i = 0; i < n; ++i) {
                Object object4;
                ProfileRec profileRec = (ProfileRec)arrayList2.get(i);
                double d2 = profileRec.dnumgenes;
                object2 = new TreeSet(new Profilerecdistcomparator());
                for (int j = 0; j < n; ++j) {
                    if (j == i) continue;
                    object4 = (ProfileRec)arrayList2.get(j);
                    double d3 = Util.correlation(this.modelprofiles[profileRec.nprofileindex], this.modelprofiles[((ProfileRec)object4).nprofileindex]);
                    if (!(d3 > this.dmaxminclustdist)) continue;
                    ((TreeSet)object2).add(new ProfileRecDist((ProfileRec)object4, d3));
                }
                object = new TreeSet(new Profilerecdistcomparator());
                object4 = ((TreeSet)object2).iterator();
                while (object4.hasNext()) {
                    ProfileRecDist profileRecDist = (ProfileRecDist)object4.next();
                    ProfileRec profileRec2 = profileRecDist.theProfileRec;
                    if (!this.closeToAllNeighbors(profileRec2, (TreeSet)object)) continue;
                    ((TreeSet)object).add(profileRecDist);
                    d2 += profileRec2.dnumgenes;
                }
                if (!(d2 > d)) continue;
                d = d2;
                ((TreeSet)object).add(new ProfileRecDist(profileRec, 1.0));
                object3 = object;
            }
            Iterator iterator = ((TreeSet)object3).iterator();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            while (iterator.hasNext()) {
                boolean bl3 = false;
                ProfileRecDist profileRecDist = (ProfileRecDist)iterator.next();
                object2 = profileRecDist.theProfileRec;
                arrayList3.add(object2);
                for (int i = 0; !bl3 && i < arrayList2.size(); ++i) {
                    object = (ProfileRec)arrayList2.get(i);
                    if (((ProfileRec)object2).nprofileindex != ((ProfileRec)object).nprofileindex) continue;
                    arrayList2.remove(i);
                    bl3 = true;
                }
            }
            arrayList.add(arrayList3);
        }
    }

    static double[][] generatemodelprofilesall(int n, int n2) {
        if (n == 1) {
            return new double[][]{{0.0}};
        }
        double[][] dArray = STEM_DataSet.generatemodelprofilesall(n - 1, n2);
        int n3 = 2 * n2 + 1;
        double[][] dArray2 = new double[dArray.length * n3][n];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < n - 1; ++j) {
                dArray2[i][j] = dArray[i / n3][j];
            }
            dArray2[i][n - 1] = dArray[i / n3][n - 2] + (double)(i % n3) - (double)n2;
        }
        return dArray2;
    }

    public void computeaveragetally() {
        int n;
        boolean bl;
        int n2;
        int[] nArray;
        int n3;
        int[][] nArray2 = null;
        boolean bl2 = this.numcols < ALLPERMSTHRESH || this.nsamplesgene <= 0;
        this.expectedassignments = new double[this.modelprofiles.length];
        for (n3 = 0; n3 < this.expectedassignments.length; ++n3) {
            this.expectedassignments[n3] = 0.0;
        }
        n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        double[] dArray = new double[this.modelprofiles.length];
        double[] dArray2 = new double[this.modelprofiles.length];
        double[] dArray3 = new double[this.modelprofiles.length];
        this.modelprofilestats(dArray, dArray2, dArray3);
        int n5 = -1;
        int[] nArray3 = new int[this.numcols];
        double[] dArray4 = new double[this.numcols];
        double[] dArray5 = new double[this.numcols];
        int[] nArray4 = new int[this.modelprofiles.length];
        double[] dArray6 = new double[4];
        double[] dArray7 = null;
        int n6 = 0;
        if (this.generepeatspottimedata != null) {
            n6 = this.generepeatspottimedata[0].length;
            dArray7 = new double[n6];
        }
        if (bl2) {
            nArray2 = this.ballpermuteval ? this.generatepermutations(this.numcols) : this.generatepermutationsExcept0(this.numcols);
            int n7 = Math.min(this.nsamplesgene, nArray2.length);
            if (n7 <= 0 || n7 == nArray2.length) {
                nArray = new int[nArray2.length];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = n2;
                }
                bl = true;
            } else {
                bl = false;
                nArray = new int[n7];
            }
        } else {
            bl = false;
            nArray = new int[this.nsamplesgene];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = n2;
            }
        }
        Random random = new Random(9873287L);
        boolean[] blArray = null;
        int n8 = 0;
        if (!bl && !bl2) {
            nArray2 = new int[nArray.length][this.numcols];
            if (!this.ballpermuteval) {
                n8 = 1;
            }
            blArray = new boolean[this.numcols - n8];
        }
        for (n = 0; n < this.numrows; ++n) {
            int n9;
            int n10;
            n5 = -1;
            if (n % 100 == 0) {
                System.out.print(".");
            }
            int[] nArray5 = this.pmavalues[n];
            if (!bl) {
                if (bl2) {
                    for (n10 = 0; n10 < nArray.length; ++n10) {
                        nArray[n10] = (int)Math.floor(random.nextDouble() * (double)nArray2.length);
                    }
                    Arrays.sort(nArray);
                } else {
                    for (n10 = 0; n10 < nArray.length; ++n10) {
                        int n11;
                        for (n11 = 0; n11 < this.numcols - n8; ++n11) {
                            blArray[n11] = false;
                        }
                        for (n11 = n8; n11 < this.numcols; ++n11) {
                            int n12 = (int)Math.floor((double)(this.numcols - n11) * random.nextDouble());
                            n9 = 0;
                            int n13 = 0;
                            while (n13 < n12 || blArray[n9]) {
                                if (!blArray[n9]) {
                                    ++n13;
                                }
                                ++n9;
                            }
                            blArray[n9] = true;
                            nArray2[n10][n11] = n9 + n8;
                        }
                    }
                }
            }
            for (n10 = 0; n10 < nArray.length; ++n10) {
                int[] nArray6 = nArray2[nArray[n10]];
                if (nArray5[nArray6[0]] == 0) continue;
                if (n5 != nArray6[0]) {
                    n5 = nArray6[0];
                    if (this.generepeatspottimedata == null) {
                        double[][] dArray8 = this.genespottimedata[n];
                        int[][] nArray7 = this.genespottimepma[n];
                        if (nArray7.length > dArray6.length) {
                            dArray6 = new double[2 * nArray7.length];
                        }
                        for (int i = 0; i < this.numcols; ++i) {
                            int n14 = 0;
                            for (int j = 0; j < nArray7.length; ++j) {
                                if (nArray7[j][i] == 0) continue;
                                dArray6[n14] = dArray8[j][i] - dArray8[j][n5];
                                ++n14;
                            }
                            if (n14 <= 0) continue;
                            dArray5[i] = Util.getmedian(dArray6, n14);
                        }
                    } else {
                        for (int i = 0; i < this.numcols; ++i) {
                            n9 = 0;
                            for (int j = 0; j < n6; ++j) {
                                double[][] dArray9 = this.generepeatspottimedata[n][j];
                                int[][] nArray8 = this.generepeatspottimepma[n][j];
                                if (nArray8.length > dArray6.length) {
                                    dArray6 = new double[2 * nArray8.length];
                                }
                                int n15 = 0;
                                for (int k = 0; k < nArray8.length; ++k) {
                                    if (nArray8[k][i] == 0) continue;
                                    dArray6[n15] = dArray9[k][i] - dArray9[k][n5];
                                    ++n15;
                                }
                                if (n15 <= 0) continue;
                                dArray7[n9] = Util.getmedian(dArray6, n15);
                                ++n9;
                            }
                            if (n9 <= 0) continue;
                            dArray5[i] = Util.getmedian(dArray7, n9);
                        }
                    }
                    d = 0.0;
                    d2 = 0.0;
                    n4 = 0;
                    for (int i = 0; i < this.numcols; ++i) {
                        if (nArray3[i] == 0) continue;
                        ++n4;
                        d += dArray5[i];
                        d2 += dArray5[i] * dArray5[i];
                    }
                    d3 = Math.sqrt(d2 - d * d / (double)n4);
                    d /= (double)n4;
                }
                int[] nArray9 = this.pmavalues[n];
                for (n9 = 0; n9 < this.numcols; ++n9) {
                    dArray4[n9] = dArray5[nArray6[n9]];
                    nArray3[n9] = nArray9[nArray6[n9]];
                }
                n9 = 0;
                double d4 = -2.0;
                for (int i = 0; i < this.modelprofiles.length; ++i) {
                    double d5;
                    double[] dArray10 = this.modelprofiles[i];
                    if (n4 == this.numcols) {
                        double d6 = 0.0;
                        for (int j = 0; j < this.numcols; ++j) {
                            d6 += dArray4[j] * dArray10[j];
                        }
                        d5 = (d6 - d * dArray[i]) / (d3 * dArray3[i]);
                    } else {
                        d5 = Util.correlation(dArray4, this.modelprofiles[i], nArray3);
                    }
                    if (d5 == d4) {
                        nArray4[n9] = i;
                        ++n9;
                        continue;
                    }
                    if (!(d5 > d4)) continue;
                    nArray4[0] = i;
                    n9 = 1;
                    d4 = d5;
                }
                if (n9 <= 0) continue;
                ++n3;
                double d7 = 1.0 / (double)n9;
                for (int i = 0; i < n9; ++i) {
                    int n16 = nArray4[i];
                    this.expectedassignments[n16] = this.expectedassignments[n16] + d7;
                }
            }
        }
        System.out.println();
        for (n = 0; n < this.expectedassignments.length; ++n) {
            this.expectedassignments[n] = this.expectedassignments[n] * (double)this.numrows / (double)n3;
        }
    }

    public void assignall0() {
        this.profilesAssigned = new ArrayList[1];
        this.bestassignments = new ArrayList[this.numrows];
        this.countassignments = new double[this.numrows];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(0));
        this.profilesAssigned[0] = new ArrayList();
        for (int i = 0; i < this.numrows; ++i) {
            this.bestassignments[i] = arrayList;
            this.countassignments[i] = 0.0;
            this.profilesAssigned[0].add(new Integer(i));
        }
    }

    int[][] generatepermutationsExcept0(int n) {
        int n2;
        int[] nArray = new int[--n];
        int n3 = 1;
        for (int i = 2; i <= n; ++i) {
            n3 *= i;
        }
        int[][] nArray2 = new int[n3][n + 1];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = n2 + 1;
            nArray2[0][n2 + 1] = n2 + 1;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray2[n2][0] = 0;
        }
        n2 = n - 2;
        int n4 = 0;
        while (n2 >= 0) {
            for (int i = 0; i < n; ++i) {
                nArray2[n4][i + 1] = nArray[i];
            }
            ++n4;
            for (n2 = n - 2; n2 >= 0 && nArray[n2] >= nArray[n2 + 1]; --n2) {
            }
            if (n2 < 0) continue;
            int n5 = n - 1;
            while (nArray[n2] >= nArray[n5]) {
                --n5;
            }
            this.swap(nArray, n2, n5);
            int n6 = n2 + 1;
            for (n5 = n - 1; n6 < n5; ++n6, --n5) {
                this.swap(nArray, n6, n5);
            }
        }
        return nArray2;
    }

    int[][] generatepermutations(int n) {
        int n2;
        int[] nArray = new int[n];
        int n3 = 1;
        for (int i = 2; i <= n; ++i) {
            n3 *= i;
        }
        int[][] nArray2 = new int[n3][n];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = n2;
            nArray2[0][n2] = n2;
        }
        n2 = n - 2;
        int n4 = 0;
        while (n2 >= 0) {
            for (int i = 0; i < n; ++i) {
                nArray2[n4][i] = nArray[i];
            }
            ++n4;
            for (n2 = n - 2; n2 >= 0 && nArray[n2] >= nArray[n2 + 1]; --n2) {
            }
            if (n2 < 0) continue;
            int n5 = n - 1;
            while (nArray[n2] >= nArray[n5]) {
                --n5;
            }
            this.swap(nArray, n2, n5);
            int n6 = n2 + 1;
            for (n5 = n - 1; n6 < n5; ++n6, --n5) {
                this.swap(nArray, n6, n5);
            }
        }
        return nArray2;
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public void modelprofilestats(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < this.modelprofiles.length; ++i) {
            dArray[i] = 0.0;
            dArray2[i] = 0.0;
            for (int j = 0; j < this.numcols; ++j) {
                int n = i;
                dArray[n] = dArray[n] + this.modelprofiles[i][j];
                int n2 = i;
                dArray2[n2] = dArray2[n2] + this.modelprofiles[i][j] * this.modelprofiles[i][j];
            }
            dArray3[i] = Math.sqrt(dArray2[i] - dArray[i] * dArray[i] / (double)this.numcols);
        }
    }

    public void compactprofiles2(double d, int n) {
        Object object;
        boolean[] blArray = new boolean[this.modelprofiles.length];
        double[] dArray = new double[this.modelprofiles.length];
        double[] dArray2 = new double[this.modelprofiles.length];
        double[] dArray3 = new double[this.modelprofiles.length];
        this.modelprofilestats(dArray, dArray2, dArray3);
        double d2 = Math.min(d, 1.5);
        int n2 = Math.min(this.modelprofiles.length, n);
        if (n2 <= 0) {
            n2 = this.modelprofiles.length;
        }
        int[] nArray = new int[n2];
        double d3 = 1.0 / (double)(2 * this.nmaxchange + 1);
        double d4 = (Math.pow(d3, this.modelprofiles[0].length) - 1.0) / (d3 - 1.0) - 1.0;
        int n3 = (int)((double)(this.modelprofiles.length * (this.nmaxchange + 1)) * d4);
        blArray[n3] = true;
        int n4 = 1;
        if (n2 > 1) {
            Object object2;
            int n5;
            double d5;
            double[] dArray4;
            nArray[0] = n3;
            object = new double[this.modelprofiles.length];
            double[] dArray5 = this.modelprofiles[n3];
            for (int i = 0; i < ((double[][])object).length; ++i) {
                dArray4 = this.modelprofiles[i];
                d5 = 0.0;
                for (n5 = 0; n5 < this.numcols; ++n5) {
                    d5 += dArray5[n5] * dArray4[n5];
                }
                object[i] = (double[])((d5 - dArray[i] * dArray[n3] / (double)this.numcols) / (dArray3[i] * dArray3[n3]));
            }
            double[] dArray6 = new double[this.modelprofiles.length];
            for (n5 = 0; n5 < dArray6.length; ++n5) {
                dArray6[n5] = this.modelprofiles[n5][0];
                for (int i = 1; i < this.modelprofiles[n5].length; ++i) {
                    double d6 = Math.abs(this.modelprofiles[n5][i]);
                    if (!(d6 > dArray6[n5])) continue;
                    dArray6[n5] = d6;
                }
            }
            do {
                int n6;
                int n7;
                int n8 = -1;
                object2 = 2.0;
                double d7 = this.nmaxchange * this.modelprofiles[0].length;
                for (n7 = 0; n7 < this.modelprofiles.length; ++n7) {
                    if (blArray[n7]) continue;
                    n6 = 1;
                    if (Math.abs((double)(object[n7] - object2)) <= FLOATERROR && dArray6[n7] < d7) {
                        d5 = 0.0;
                        for (int i = 0; i < this.numcols; ++i) {
                            d5 += this.modelprofiles[n8][i] * this.modelprofiles[n7][i];
                        }
                        double d8 = (d5 - dArray[n7] * dArray[n8] / (double)this.numcols) / (dArray3[n7] * dArray3[n8]);
                        if (d8 + FLOATERROR >= 1.0) {
                            object2 = object[n7];
                            n8 = n7;
                            d7 = dArray6[n7];
                            n6 = 0;
                        }
                    }
                    if (n6 == 0 || !(object[n7] < object2)) continue;
                    object2 = object[n7];
                    n8 = n7;
                    d7 = dArray6[n7];
                }
                if (n8 <= -1 || !(object2 + FLOATERROR < d)) continue;
                blArray[n8] = true;
                nArray[n4] = n8;
                ++n4;
                dArray5 = this.modelprofiles[n8];
                for (n7 = 0; n7 < ((double[][])object).length; ++n7) {
                    dArray4 = this.modelprofiles[n7];
                    d5 = 0.0;
                    for (n6 = 0; n6 < this.numcols; ++n6) {
                        d5 += dArray5[n6] * dArray4[n6];
                    }
                    double d9 = (d5 - dArray[n8] * dArray[n7] / (double)this.numcols) / (dArray3[n8] * dArray3[n7]);
                    if (!(d9 > object[n7])) continue;
                    object[n7] = (double[])d9;
                }
            } while (object2 + FLOATERROR < d2 && n4 < n2);
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat.setMinimumFractionDigits(3);
            numberFormat.setMaximumFractionDigits(3);
            System.out.println("Maximum correlation between model profiles: " + numberFormat.format((double)object2));
        }
        object = new double[n4][this.numcols];
        Arrays.sort(nArray, 0, n4);
        for (int i = 0; i < n4; ++i) {
            object[i] = this.modelprofiles[nArray[i]];
        }
        this.modelprofiles = object;
    }

    public void findbestgroupassignments() {
        this.profilesAssigned = new ArrayList[this.modelprofiles.length];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.modelprofiles.length; ++i) {
            arrayList.add(new Integer(i));
            this.profilesAssigned[i] = new ArrayList();
        }
        this.bestassignments = new ArrayList[this.numrows];
        for (int i = 0; i < this.numrows; ++i) {
            int n;
            double d = -2.0;
            this.bestassignments[i] = arrayList;
            for (n = 0; n < this.modelprofiles.length; ++n) {
                double d2 = Util.correlation(this.data[i], this.modelprofiles[n], this.pmavalues[i]);
                if (d2 == d) {
                    this.bestassignments[i].add(new Integer(n));
                    continue;
                }
                if (!(d2 > d)) continue;
                d = d2;
                this.bestassignments[i] = new ArrayList();
                this.bestassignments[i].add(new Integer(n));
            }
            for (n = 0; n < this.bestassignments[i].size(); ++n) {
                this.profilesAssigned[(Integer)this.bestassignments[i].get(n)].add(new Integer(i));
            }
        }
    }

    static class CenterRecCompare
    implements Comparator {
        CenterRecCompare() {
        }

        public int compare(Object object, Object object2) {
            CenterRec centerRec = (CenterRec)object;
            CenterRec centerRec2 = (CenterRec)object2;
            for (int i = 0; i < centerRec.center.length; ++i) {
                if (centerRec.center[i] < centerRec2.center[i]) {
                    return -1;
                }
                if (!(centerRec.center[i] > centerRec2.center[i])) continue;
                return 1;
            }
            if (centerRec.norigid < centerRec2.norigid) {
                return -1;
            }
            if (centerRec.norigid > centerRec2.norigid) {
                return 1;
            }
            return 0;
        }
    }

    static class CenterRec {
        double[] center;
        int norigid;

        CenterRec(double[] dArray, int n) {
            this.center = dArray;
            this.norigid = n;
        }
    }

    public static final class ProfileRec {
        public int nprofileindex;
        public double dnumgenes;
        public double dnumexpected;
        public double dpvalue;

        ProfileRec(int n, double d, double d2, double d3) {
            this.nprofileindex = n;
            this.dnumgenes = d;
            this.dnumexpected = d2;
            this.dpvalue = d3;
        }

        public Object clone() {
            return new ProfileRec(this.nprofileindex, this.dnumgenes, this.dnumexpected, this.dpvalue);
        }
    }

    static class ProfileRecDist {
        double dprofiledist;
        ProfileRec theProfileRec;

        ProfileRecDist(ProfileRec profileRec, double d) {
            this.theProfileRec = profileRec;
            this.dprofiledist = d;
        }
    }

    public static class Profilerecdistcomparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            ProfileRecDist profileRecDist = (ProfileRecDist)object;
            ProfileRecDist profileRecDist2 = (ProfileRecDist)object2;
            if (profileRecDist.dprofiledist < profileRecDist2.dprofiledist) {
                return 1;
            }
            if (profileRecDist.dprofiledist > profileRecDist2.dprofiledist) {
                return -1;
            }
            return 0;
        }
    }
}

