/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.chromviewer.ChromFrame;
import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.GenePlotPanel;
import edu.cmu.cs.sb.stem.MAINGUI2;
import edu.cmu.cs.sb.stem.ProfileGui;
import edu.cmu.cs.sb.stem.STEM_DataSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class MainTable
extends JPanel
implements ActionListener {
    private boolean DEBUG = false;
    STEM_DataSet theDataSet;
    ChromFrame cf;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    String[] columnNames;
    String[][] tabledata;
    JButton chromButton;
    JButton saveButton;
    JButton savenamesButton;
    JButton copyButton;
    JButton copynamesButton;
    JFrame theFrame;
    TableSorter sorter;

    public MainTable(JFrame jFrame, STEM_DataSet sTEM_DataSet, final GenePlotPanel genePlotPanel, final ChromFrame chromFrame) {
        Object object;
        Serializable serializable;
        this.theFrame = jFrame;
        this.cf = chromFrame;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        this.theDataSet = sTEM_DataSet;
        this.columnNames = new String[sTEM_DataSet.numcols + 4];
        this.columnNames[0] = "Selected";
        this.columnNames[1] = sTEM_DataSet.szGeneHeader;
        this.columnNames[2] = sTEM_DataSet.szProbeHeader;
        this.columnNames[3] = sTEM_DataSet.bkmeans ? "Cluster" : "Profile";
        for (int i = 0; i < sTEM_DataSet.numcols; ++i) {
            this.columnNames[i + 4] = "" + sTEM_DataSet.dsamplemins[i];
        }
        this.tabledata = new String[sTEM_DataSet.numrows][this.columnNames.length];
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        for (int i = 0; i < sTEM_DataSet.numrows; ++i) {
            this.tabledata[i][1] = sTEM_DataSet.genenames[i];
            this.tabledata[i][2] = sTEM_DataSet.probenames[i];
            this.tabledata[i][0] = sTEM_DataSet.tga.isOrder(this.tabledata[i][1]) ? "Yes" : "";
            serializable = sTEM_DataSet.bestassignments[i];
            StringBuffer stringBuffer = new StringBuffer("" + (Integer)((ArrayList)serializable).get(0));
            for (int j = 1; j < ((ArrayList)serializable).size(); ++j) {
                stringBuffer.append(";" + (Integer)((ArrayList)serializable).get(j));
            }
            object = stringBuffer.toString();
            this.tabledata[i][3] = object;
            for (int j = 0; j < sTEM_DataSet.numcols; ++j) {
                this.tabledata[i][j + 4] = sTEM_DataSet.pmavalues[i][j] == 0 ? "" : numberFormat.format(sTEM_DataSet.data[i][j]);
            }
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(800, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 400)));
        serializable = jTable.getColumnModel().getColumn(0);
        ((TableColumn)serializable).setPreferredWidth(50);
        serializable = jTable.getColumnModel().getColumn(1);
        ((TableColumn)serializable).setPreferredWidth(200);
        serializable = jTable.getColumnModel().getColumn(2);
        ((TableColumn)serializable).setPreferredWidth(150);
        serializable = jTable.getColumnModel().getColumn(3);
        ((TableColumn)serializable).setPreferredWidth(45);
        for (int i = 0; i < sTEM_DataSet.numcols; ++i) {
            serializable = jTable.getColumnModel().getColumn(i + 4);
            ((TableColumn)serializable).setPreferredWidth(45);
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
        jTable.setSelectionMode(0);
        object = jTable.getSelectionModel();
        final STEM_DataSet sTEM_DataSet2 = sTEM_DataSet;
        final TableSorter tableSorter = this.sorter;
        object.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                final ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int n = listSelectionModel.getMinSelectionIndex();
                        String string = (String)tableSorter.getValueAt(n, 3);
                        String string2 = (String)tableSorter.getValueAt(n, 1);
                        String string3 = (String)tableSorter.getValueAt(n, 2);
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                        while (stringTokenizer.hasMoreTokens()) {
                            int n2 = Integer.parseInt(stringTokenizer.nextToken());
                            final ProfileGui profileGui = new ProfileGui(sTEM_DataSet2, n2, null, null, -1, null, string2, string3, genePlotPanel, chromFrame);
                            profileGui.addWindowListener(new WindowAdapter(){

                                public void windowClosing(WindowEvent windowEvent) {
                                    profileGui.dispose();
                                }

                                public void windowOpened(WindowEvent windowEvent) {
                                    profileGui.repaint();
                                }
                            });
                            profileGui.pack();
                            profileGui.setSize(new Dimension(MAINGUI2.SCREENWIDTH, MAINGUI2.SCREENHEIGHT));
                            profileGui.setVisible(true);
                        }
                    }
                });
            }
        });
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        this.chromButton = new JButton("Chromosome View");
        if (chromFrame.genomeParser.szchromval.equals("")) {
            this.chromButton.setEnabled(false);
        } else {
            this.chromButton.setEnabled(true);
        }
        this.chromButton.setActionCommand("chromview");
        this.chromButton.setMinimumSize(new Dimension(800, 20));
        this.chromButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.copyButton);
        jPanel.add(this.saveButton);
        jPanel.setBackground(Color.white);
        this.copynamesButton = new JButton("Copy Gene Names", Util.createImageIcon("Copy16.gif"));
        this.copynamesButton.setActionCommand("copynames");
        this.copynamesButton.setMinimumSize(new Dimension(800, 20));
        this.copynamesButton.addActionListener(this);
        this.savenamesButton = new JButton("Save Gene Names", Util.createImageIcon("Save16.gif"));
        this.savenamesButton.setActionCommand("savenames");
        this.savenamesButton.setMinimumSize(new Dimension(800, 20));
        this.savenamesButton.addActionListener(this);
        jPanel.add(this.copynamesButton);
        jPanel.add(this.savenamesButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel.add(this.chromButton);
        jPanel.add(jButton);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("chromview")) {
            this.chromView();
        } else if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("copynames")) {
            this.writenamesToClipboard();
        } else if (string.equals("save") || string.equals("savenames")) {
            try {
                int n = Util.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = Util.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    if (string.equals("save")) {
                        this.printFile(printWriter);
                    } else {
                        this.printGeneList(printWriter);
                    }
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = "";
            if (this.theDataSet.btakelog) {
                string2 = "log base two ";
            }
            String string3 = this.theDataSet.bkmeans ? "The table contains the list of genes included in the data set file and passed filter according to filering criteria specified under the advanced options.\n\nThe first four columns are: \n*Selected - contains a 'Yes' if the gene is part the GO Category or Query Set that the K-means clusters are currently ordered by, otherwise is blank.\n*  " + this.theDataSet.szGeneHeader + " - The name of the gene.\n" + "*  " + this.theDataSet.szProbeHeader + " - The spot ID(s) associated with the gene.\n" + "*Cluster - The cluster(s) the gene belongs to.\n\n" + "The remaining columns contain the " + string2 + "expression change relative to the first time point.\n\n" + "Note:\n" + "+Clicking on a row display the profile(s) to which the gene was assigned.\n" + "+The table can be sorted by any of the columns by clicking on the column's header.\n" + "Using the 'Copy Table' the entire table can be copied to the clipboard, or " + "with the 'Copy Gene Names' button just the gene names.\n" + "Using the 'Save Table' button the entire table can be saved, or using the " + "'Save Gene Names' button just the gene names.\n" + "'Chromosome View' button plots the genes in the table on the Chromosome Viewer and makes " + "the viewer visible if not already so. If the button is inactive then no chromosome locations " + "were specified." : "The table contains the list of genes included in the data set file and passed filter according to filering criteria specified under the advanced options.\n\nThe first four columns are: \n*Selected - contains a 'Yes' if the gene is part the GO Category or Query Set that the profiles or cluster of profiles are currently ordered by, otherwise is blank.\n*  " + this.theDataSet.szGeneHeader + " - The name of the gene.\n" + "*  " + this.theDataSet.szProbeHeader + " - The spot ID(s) associated with the gene.\n" + "*Profile - The profile the gene was assigned to, in case of a tie " + "multiple profiles are listed.\n\n" + "The remaining columns contain the " + string2 + "expression change relative to the first time point.\n\n" + "Note:\n" + "+Clicking on a row display the profile(s) to which the gene was assigned.\n" + "+The table can be sorted by any of the columns by clicking on the column's header.\n" + "Using the 'Copy Table' the entire table can be copied to the clipboard, or " + "with the 'Copy Gene Names' button just the gene names.\n" + "Using the 'Save Table' button the entire table can be saved, or using the " + "'Save Gene Names' button just the gene names.\n" + "+'Chromosome View' button plots the genes in the table on the Chromosome Viewer and makes " + "the viewer visible if not already so. If the button is inactive then no chromosome locations " + "were specified.";
            Util.renderDialog(this.theFrame, string3);
        }
    }

    private void chromView() {
        String[] stringArray = new String[this.tabledata.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.tabledata[i][1];
        }
        this.cf.drawGenes(stringArray);
        this.cf.setVisible(true);
    }

    public void printGeneList(PrintWriter printWriter) {
        for (int i = 0; i < this.tabledata.length; ++i) {
            printWriter.println(this.sorter.getValueAt(i, 1));
        }
    }

    public void writenamesToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tabledata.length; ++i) {
            stringBuffer.append(this.sorter.getValueAt(i, 1) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        printWriter.println("Table of Genes Passing Filter");
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            printWriter.print(this.columnNames[n] + "\t");
        }
        printWriter.println(this.columnNames[this.columnNames.length - 1]);
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.sorter.getValueAt(n, i) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n, this.columnNames.length - 1));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            stringBuffer.append(this.columnNames[n] + "\t");
        }
        stringBuffer.append(this.columnNames[this.columnNames.length - 1] + "\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, this.columnNames.length - 1) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }
}

