/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.stem;

import edu.cmu.cs.sb.chromviewer.ChromFrame;
import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.stem.STEM_DataSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class GeneTable
extends JPanel
implements ActionListener {
    private boolean DEBUG = false;
    ChromFrame cf;
    STEM_DataSet theDataSet;
    int nprofile;
    String szAssignInfo;
    String[] columnNames;
    String[][] tabledata;
    JButton saveButton;
    JButton copyButton;
    JButton savenamesButton;
    JButton copynamesButton;
    JButton chromButton;
    ArrayList alprofiles;
    TableSorter sorter;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    boolean bprofileonly;
    boolean bquery;
    String szTitle;
    JFrame theFrame;
    HashSet htinames;

    public GeneTable(JFrame jFrame, STEM_DataSet sTEM_DataSet, int n, String string, boolean bl, HashSet hashSet, String string2, ChromFrame chromFrame) {
        this.theFrame = jFrame;
        this.nprofile = n;
        this.alprofiles = new ArrayList();
        this.alprofiles.add(new Integer(n));
        this.bprofileonly = true;
        this.szTitle = string2;
        this.cf = chromFrame;
        this.geneTableHelper(sTEM_DataSet, string, bl, hashSet);
    }

    public GeneTable(JFrame jFrame, STEM_DataSet sTEM_DataSet, ArrayList arrayList, String string, boolean bl, HashSet hashSet, String string2, ChromFrame chromFrame) {
        this.theFrame = jFrame;
        this.cf = chromFrame;
        int n = arrayList.size();
        this.alprofiles = new ArrayList();
        for (int i = 0; i < n; ++i) {
            STEM_DataSet.ProfileRec profileRec = (STEM_DataSet.ProfileRec)arrayList.get(i);
            this.alprofiles.add(new Integer(profileRec.nprofileindex));
        }
        this.bprofileonly = false;
        this.szTitle = string2;
        this.geneTableHelper(sTEM_DataSet, string, bl, hashSet);
    }

    public void geneTableHelper(STEM_DataSet sTEM_DataSet, String string, boolean bl, HashSet hashSet) {
        int n;
        int n2;
        int n3;
        int n4;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        this.bquery = bl;
        this.htinames = hashSet;
        this.theDataSet = sTEM_DataSet;
        this.szAssignInfo = string;
        int n5 = sTEM_DataSet.numcols + 4;
        this.columnNames = new String[n5];
        this.columnNames[0] = "Selected";
        this.columnNames[1] = "Weight";
        this.columnNames[2] = sTEM_DataSet.szGeneHeader;
        this.columnNames[3] = sTEM_DataSet.szProbeHeader;
        for (n4 = 0; n4 < sTEM_DataSet.numcols; ++n4) {
            this.columnNames[n4 + 4] = "" + sTEM_DataSet.dsamplemins[n4];
        }
        n4 = 0;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        int n6 = 0;
        if (hashSet != null) {
            n6 = hashSet.size();
        } else {
            for (n3 = 0; n3 < this.alprofiles.size(); ++n3) {
                n2 = (Integer)this.alprofiles.get(n3);
                if (bl) {
                    ArrayList arrayList = sTEM_DataSet.profilesAssigned[n2];
                    int n7 = arrayList.size();
                    for (n = 0; n < n7; ++n) {
                        n4 = (Integer)arrayList.get(n);
                        if (!sTEM_DataSet.tga.isOrder(sTEM_DataSet.genenames[n4])) continue;
                        ++n6;
                    }
                    continue;
                }
                n6 += sTEM_DataSet.profilesAssigned[n2].size();
            }
        }
        this.tabledata = new String[n6][this.columnNames.length];
        n3 = 0;
        for (n2 = 0; n2 < this.alprofiles.size(); ++n2) {
            int n8 = (Integer)this.alprofiles.get(n2);
            ArrayList arrayList = sTEM_DataSet.profilesAssigned[n8];
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                n4 = (Integer)arrayList.get(i);
                if (!(!bl && hashSet == null || hashSet != null && hashSet.contains(sTEM_DataSet.genenames[n4])) && (hashSet != null || !sTEM_DataSet.tga.isOrder(sTEM_DataSet.genenames[n4]))) continue;
                this.tabledata[n3][2] = sTEM_DataSet.genenames[n4];
                this.tabledata[n3][3] = sTEM_DataSet.probenames[n4];
                this.tabledata[n3][0] = bl || sTEM_DataSet.tga.isOrder(this.tabledata[n3][2]) ? "Yes" : "";
                this.tabledata[n3][1] = numberFormat.format(1.0 / (double)sTEM_DataSet.bestassignments[n4].size());
                for (int j = 0; j < sTEM_DataSet.numcols; ++j) {
                    this.tabledata[n3][j + 4] = sTEM_DataSet.pmavalues[n4][j] == 0 ? "" : numberFormat.format(sTEM_DataSet.data[n4][j]);
                }
                ++n3;
            }
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(800, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 400)));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(40);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(40);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(200);
        tableColumn = jTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(150);
        for (int i = 0; i < sTEM_DataSet.numcols; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i + 4);
            tableColumn.setPreferredWidth(45);
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.copyButton);
        jPanel.setBackground(Color.white);
        jPanel.add(this.saveButton);
        this.copynamesButton = new JButton("Copy Gene Names", Util.createImageIcon("Copy16.gif"));
        this.copynamesButton.setActionCommand("copynames");
        this.copynamesButton.setMinimumSize(new Dimension(800, 20));
        this.copynamesButton.addActionListener(this);
        this.savenamesButton = new JButton("Save Gene Names", Util.createImageIcon("Save16.gif"));
        this.savenamesButton.setActionCommand("savenames");
        this.savenamesButton.setMinimumSize(new Dimension(800, 20));
        this.savenamesButton.addActionListener(this);
        jPanel.add(this.copynamesButton);
        jPanel.add(this.savenamesButton);
        this.chromButton = new JButton("Chromosome View");
        if (this.cf.genomeParser.szchromval.equals("")) {
            this.chromButton.setEnabled(false);
        } else {
            this.chromButton.setEnabled(true);
        }
        this.chromButton.setActionCommand("chromview");
        this.chromButton.setMinimumSize(new Dimension(800, 20));
        this.chromButton.addActionListener(this);
        jPanel.add(this.chromButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel.add(jButton);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        int n2;
        if (this.bprofileonly) {
            printWriter.print(this.szTitle + " (");
            for (n2 = 0; n2 < this.theDataSet.numcols - 1; ++n2) {
                printWriter.print(this.theDataSet.modelprofiles[this.nprofile][n2] + ",");
            }
            printWriter.println(this.theDataSet.modelprofiles[this.nprofile][this.theDataSet.numcols - 1] + ")");
            printWriter.println("Num. Genes Expected\tNum. Genes Assigned\tP-Value\tSignificant");
            printWriter.println(this.szAssignInfo);
        } else {
            printWriter.println(this.szTitle);
            for (n2 = 0; n2 < this.alprofiles.size(); ++n2) {
                n = (Integer)this.alprofiles.get(n2);
                printWriter.print("\t Profile " + n + " (");
                for (int i = 0; i < this.theDataSet.numcols - 1; ++i) {
                    printWriter.print(this.theDataSet.modelprofiles[n][i] + ",");
                }
                printWriter.println(this.theDataSet.modelprofiles[n][this.theDataSet.numcols - 1] + ")");
            }
        }
        printWriter.println("-------");
        for (n2 = 0; n2 < this.columnNames.length - 1; ++n2) {
            printWriter.print(this.columnNames[n2] + "\t");
        }
        printWriter.println(this.columnNames[this.columnNames.length - 1]);
        for (n2 = 0; n2 < this.tabledata.length; ++n2) {
            for (n = 0; n < this.tabledata[n2].length - 1; ++n) {
                printWriter.print(this.sorter.getValueAt(n2, n) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n2, this.columnNames.length - 1));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            stringBuffer.append(this.columnNames[n] + "\t");
        }
        stringBuffer.append(this.columnNames[this.columnNames.length - 1] + "\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, this.columnNames.length - 1) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void writenamesToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tabledata.length; ++i) {
            stringBuffer.append(this.sorter.getValueAt(i, 2) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void printGeneList(PrintWriter printWriter) {
        for (int i = 0; i < this.tabledata.length; ++i) {
            printWriter.println(this.sorter.getValueAt(i, 2));
        }
    }

    private void chromView() {
        String[] stringArray = new String[this.tabledata.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.tabledata[i][2];
        }
        this.cf.drawGenes(stringArray);
        this.cf.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("chromview")) {
            this.chromView();
        } else if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("copynames")) {
            this.writenamesToClipboard();
        } else if (string.equals("save") || string.equals("savenames")) {
            try {
                int n = Util.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = Util.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    if (string.equals("save")) {
                        this.printFile(printWriter);
                    } else {
                        this.printGeneList(printWriter);
                    }
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = "The table contains genes assigned to the selected ";
            string2 = this.bprofileonly ? (this.theDataSet.bkmeans ? string2 + "K-means cluster" : string2 + "profile") : string2 + "cluster of profiles (any profile the same color as this one)";
            if (this.htinames != null) {
                string2 = this.theDataSet.bkmeans ? string2 + " and to the K-means cluster to the immediate left of the yellow column in the comparison display" : string2 + " and to the profile to the immediate left of the yellow column in the comparison display";
            } else if (this.bquery) {
                string2 = string2 + " and also the query set";
            }
            String string3 = "";
            if (this.theDataSet.btakelog) {
                string3 = "log base two ";
            }
            string2 = string2 + ".\n\n The first four columns of the table are: \n*  Selected - contains a 'Yes' if the gene is part the GO Category or Query Set that the ";
            string2 = this.theDataSet.bkmeans ? string2 + "K-means clusters " : string2 + "profiles or cluster of profiles ";
            string2 = string2 + "were ordered by, otherwise is blank.\n";
            string2 = this.theDataSet.bkmeans ? string2 + "*  Weight - Weight of the gene assignment, which is 1/(number of K-means clusters to which the gene was assigned)\n" : string2 + "*  Weight - Weight of the gene assignment, which is 1/(number of profiles to which the gene was assigned)\n";
            string2 = string2 + "*  " + this.theDataSet.szGeneHeader + " - The name of the gene.\n" + "*  " + this.theDataSet.szProbeHeader + " - The spot ID(s) associated with the gene.\n" + "The remaining columns contain the " + string3 + "expression change relative to the first time point.\n\n" + "Note:\n" + "+The table can be sorted by any of the columns by clicking on the column's header.\n" + "+Using the 'Copy Table' the entire table can be copied to the clipboard, or " + "with the 'Copy Gene Names' button just the gene names.\n" + "+Using the 'Save Table' button the entire table can be saved, or using the " + "'Save Gene Names' button just the gene names.\n" + "+'Chromosome View' button plots the genes in the table on the Chromosome Viewer and makes " + "the viewer visible if not already so. If the button is inactive then no chromosome locations " + "were specified.";
            Util.renderDialog(this.theFrame, string2);
        }
    }
}

