/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.StatUtil;
import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui_EdgeTable;
import edu.cmu.cs.sb.drem.DREM_DataSet;
import edu.cmu.cs.sb.drem.DREM_IO;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class DREMGui_StaticSummaryTable
extends JPanel
implements ActionListener {
    DREM_DataSet theDataSet;
    String[] columnNames;
    String[][] tabledata;
    double[][] bindingpvalTF;
    int[][] bindingpvalTFindex;
    double[] davg;
    double[] dstd;
    String[] tfNames;
    JButton saveButton;
    JButton copyButton;
    JButton staticButton;
    TableSorter sorter;
    static final Color bgColor = Color.white;
    static final Color fgColor = Color.black;
    JFrame theFrame;
    boolean[] include;
    int numgenes;
    DREM_Timeiohmm theTimeiohmm;

    public DREMGui_StaticSummaryTable(JFrame jFrame, DREM_DataSet dREM_DataSet, DREM_Timeiohmm dREM_Timeiohmm, double[][] dArray, int[][] nArray, String[] stringArray, boolean[] blArray, int n) {
        this.theFrame = jFrame;
        this.theDataSet = dREM_DataSet;
        this.include = blArray;
        this.bindingpvalTF = dArray;
        this.bindingpvalTFindex = nArray;
        this.tfNames = stringArray;
        this.theTimeiohmm = dREM_Timeiohmm;
        this.numgenes = n;
        this.geneTableHelper();
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            printWriter.print(this.columnNames[n] + "\t");
        }
        printWriter.println(this.columnNames[this.columnNames.length - 1]);
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.sorter.getValueAt(n, i) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n, this.columnNames.length - 1));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            stringBuffer.append(this.columnNames[n] + "\t");
        }
        stringBuffer.append(this.columnNames[this.columnNames.length - 1] + "\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, this.columnNames.length - 1) + "\n");
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    private void geneTableHelper() {
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        int n = 6;
        this.columnNames = new String[n];
        this.columnNames[0] = "TF";
        this.columnNames[1] = "Total Overall";
        this.columnNames[2] = "Selected";
        this.columnNames[3] = "Expected Overall";
        this.columnNames[4] = "Diff Overall";
        this.columnNames[5] = "Overall Score";
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        int n2 = this.theTimeiohmm.bindingData.regNames.length;
        int n3 = this.theTimeiohmm.bindingData.existingBindingValuesUnsorted.size();
        if (this.theTimeiohmm.bindingData.existingBindingValuesUnsorted.contains(new Double(0.0))) {
            --n3;
        }
        int n4 = n2 * n3;
        this.tabledata = new String[n4][n];
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this.theTimeiohmm.bindingData.existingBindingValuesSorted.length; ++j) {
                if (this.theTimeiohmm.bindingData.existingBindingValuesSorted[j] == 0.0) continue;
                int n6 = 0;
                this.tabledata[n5][0] = this.theTimeiohmm.bindingData.regNames[i] + " " + this.theTimeiohmm.bindingData.existingBindingValuesSorted[j];
                int n7 = this.theTimeiohmm.filteredClassifier.nBaseCount[i][this.theTimeiohmm.bindingData.signedBindingValuesSorted[j] + this.theTimeiohmm.filteredClassifier.noffset];
                this.tabledata[n5][1] = "" + n7;
                for (int k = 0; k < this.bindingpvalTFindex[i].length; ++k) {
                    int n8 = this.bindingpvalTFindex[i][k];
                    if (!this.include[n8] || this.bindingpvalTF[i][k] != this.theTimeiohmm.bindingData.existingBindingValuesSorted[j]) continue;
                    ++n6;
                }
                this.tabledata[n5][2] = "" + n6;
                double d = (double)(n7 * this.numgenes) / (double)this.theTimeiohmm.ntotalcombined;
                this.tabledata[n5][3] = numberFormat.format(d);
                double d2 = (double)n6 - d;
                this.tabledata[n5][4] = numberFormat.format(d2);
                this.tabledata[n5][5] = "" + DREMGui_EdgeTable.doubleToSz(StatUtil.hypergeometrictail(n6 - 1, n7, this.theTimeiohmm.ntotalcombined - n7, this.numgenes));
                ++n5;
            }
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(800, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 400)));
        jTable.setAutoResizeMode(0);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(150);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.add(this.copyButton);
        jPanel.add(this.saveButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel.add(jButton);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("save")) {
            try {
                int n = DREM_IO.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = DREM_IO.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    this.printFile(printWriter);
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = "A TF-summary table provides aggregate TF-gene interaction information for the Gene Table. The table has six columns. The columns are as follows:\n\n* TF - The name of the transcription factor and the value of the annotation for the TF. Only non-zero ('1' or '-1') annotations are included.\n\n* Total Overall - The number of interactions for the transcription factor of the specified value in the TF column among genes in the file.\n\n* Selected - The number of interactions of the transcription factor of the specified value in the TF column among genes that were in the Gene Table.\n\n* Expected Overall - The expected number of interactions of that value for a random set of genes the same size as in the Gene Table. This is the number of genes in the table times the value in Total Overall divided by the total number of genes in the expression data.\n\n* Diff Overall - The difference between Selected and Expected Overall.\n\n* Overall Score - The hypergeometric distribution probability of seeing a greater value than Selected.  Note if the TF data was used to learn the model it does not represent a true p-value, but lower values still mean a more significant association.\n.";
            Util.renderDialog(this.theFrame, string2);
        }
    }
}

