/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui;
import edu.cmu.cs.sb.drem.DREMGui_FilterStaticModel;
import edu.cmu.cs.sb.drem.DREMGui_GOSplitTable;
import edu.cmu.cs.sb.drem.DREM_IO;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class DREMGui_SplitTable
extends JPanel
implements ActionListener {
    DREM_Timeiohmm theTimeiohmm;
    DREMGui theDREMGui;
    JFrame theFrame;
    String[] columnNames;
    String[][] tabledata;
    JButton saveButton;
    JButton copyButton;
    JButton goButton;
    TableSorter sorter;
    static final Color bgColor = Color.white;
    static final Color fgColor = Color.black;
    DREMGui_FilterStaticModel hmst;
    int numrows;
    DREM_Timeiohmm.Treenode ptr;
    BigInteger npathID;
    NumberFormat nf;
    DecimalFormat df;
    int nchild;
    int ntable;
    boolean regPriorsPresent;
    boolean miRNAScorePresent;

    public DREMGui_SplitTable(DREMGui dREMGui, JFrame jFrame, DREM_Timeiohmm dREM_Timeiohmm, DREM_Timeiohmm.Treenode treenode, BigInteger bigInteger) {
        int n;
        int n2;
        this.theFrame = jFrame;
        this.theTimeiohmm = dREM_Timeiohmm;
        this.ptr = treenode;
        this.npathID = bigInteger;
        this.nchild = -1;
        this.theDREMGui = dREMGui;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        this.numrows = dREM_Timeiohmm.bindingData.regNames.length;
        int n3 = dREM_Timeiohmm.bindingData.signedBindingValuesUnsorted.size();
        this.miRNAScorePresent = dREM_Timeiohmm.scaleMIRNAExp && dREM_Timeiohmm.miRNADataSet != null;
        this.regPriorsPresent = dREM_Timeiohmm.bindingData.regPriors != null;
        this.columnNames = new String[6 + 2 * n3 + (this.miRNAScorePresent ? 2 : 0) + (this.regPriorsPresent ? 2 : 0)];
        this.tabledata = new String[this.numrows][this.columnNames.length];
        this.columnNames[0] = "TF";
        this.columnNames[1] = "Coeff";
        for (n2 = 0; n2 < n3; ++n2) {
            this.columnNames[2 + n2] = "Low " + dREM_Timeiohmm.bindingData.signedBindingValuesSorted[n2];
            this.columnNames[2 + n3 + n2] = "High " + dREM_Timeiohmm.bindingData.signedBindingValuesSorted[n2];
        }
        n2 = this.columnNames.length - 1;
        int n4 = this.columnNames.length - 2;
        int n5 = this.columnNames.length - 3;
        int n6 = this.columnNames.length - 4;
        int n7 = this.columnNames.length - 8 + (this.miRNAScorePresent ? 0 : 2);
        int n8 = this.columnNames.length - 7 + (this.miRNAScorePresent ? 0 : 2);
        int n9 = this.columnNames.length - 6;
        int n10 = this.columnNames.length - 5;
        if (this.miRNAScorePresent) {
            this.columnNames[n9] = "Act. Score";
            this.columnNames[n10] = "Activity";
        }
        if (this.regPriorsPresent) {
            this.columnNames[n8] = "Act. Prior";
            this.columnNames[n7] = "Max Act. Prior";
        }
        this.columnNames[n6] = "Avg. Low";
        this.columnNames[n5] = "Avg. High";
        this.columnNames[n4] = "Diff";
        this.columnNames[n2] = "Score";
        double[] dArray = null;
        if (!dREM_Timeiohmm.BREGDREM) {
            dArray = treenode.tranC.dcoeff;
        }
        this.nf = NumberFormat.getInstance(Locale.ENGLISH);
        this.nf.setMinimumFractionDigits(3);
        this.nf.setMaximumFractionDigits(3);
        for (int i = 0; i < this.tabledata.length; ++i) {
            int n11;
            this.tabledata[i][0] = dREM_Timeiohmm.bindingData.regNames[i];
            this.tabledata[i][n2] = DREMGui_SplitTable.doubleToSz(treenode.dpvals[i][0]);
            if (this.miRNAScorePresent) {
                Integer n12 = dREM_Timeiohmm.reg2DataSetIndex.get(dREM_Timeiohmm.bindingData.regNames[i].toUpperCase());
                if (n12 != null) {
                    n = dREM_Timeiohmm.bindingData.regTypes[i];
                    double d = 0.0;
                    switch (n) {
                        case 1: {
                            d = dREM_Timeiohmm.miRNADataSet.data[n12][treenode.ndepth + 1];
                            break;
                        }
                        case 0: {
                            d = dREM_Timeiohmm.theDataSet.data[n12][treenode.ndepth];
                        }
                    }
                    this.tabledata[i][n10] = String.valueOf(d);
                } else {
                    this.tabledata[i][n10] = "N/A";
                }
                this.tabledata[i][n9] = String.valueOf(treenode.tranC.traindataTF[i][0]);
            }
            if (treenode.nextptr[0].dmean < treenode.nextptr[1].dmean) {
                this.tabledata[i][n4] = this.nf.format(treenode.ddiff[i][0]);
                this.tabledata[i][1] = dArray != null ? this.nf.format(-dArray[i + 1]) : "0";
                this.tabledata[i][n5] = this.nf.format(treenode.dscore[i][1]);
                this.tabledata[i][n6] = this.nf.format(treenode.dscore[i][0]);
                for (n11 = 0; n11 < n3; ++n11) {
                    this.tabledata[i][2 + n11] = "" + treenode.ncountvals[i][0][n11];
                    this.tabledata[i][2 + n3 + n11] = "" + treenode.ncountvals[i][1][n11];
                }
            } else {
                this.tabledata[i][n4] = this.nf.format(-treenode.ddiff[i][0]);
                this.tabledata[i][1] = dArray != null ? this.nf.format(dArray[i + 1]) : "0";
                this.tabledata[i][n5] = this.nf.format(treenode.dscore[i][0]);
                this.tabledata[i][n6] = this.nf.format(treenode.dscore[i][1]);
                for (n11 = 0; n11 < n3; ++n11) {
                    this.tabledata[i][2 + n11] = "" + treenode.ncountvals[i][1][n11];
                    this.tabledata[i][2 + n3 + n11] = "" + treenode.ncountvals[i][0][n11];
                }
            }
            if (!this.regPriorsPresent) continue;
            this.tabledata[i][n8] = this.lrgNumFmt(treenode.dTFActivityScore[i], this.nf);
            this.tabledata[i][n7] = this.lrgNumFmt(dREM_Timeiohmm.dMaxTFActivityScore[i], this.nf);
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        this.sorter.setSortingStatus(n2, 1);
        JTable jTable = new JTable(this.sorter);
        for (n = 0; n < this.columnNames.length; ++n) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
            tableColumn.setPreferredWidth(100);
        }
        this.sorter.setTableHeader(jTable.getTableHeader());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(700, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 400)));
        this.add(jScrollPane);
        this.addBottom();
    }

    public DREMGui_SplitTable(DREMGui dREMGui, JFrame jFrame, DREM_Timeiohmm dREM_Timeiohmm, DREM_Timeiohmm.Treenode treenode, BigInteger bigInteger, int n, int n2) {
        int n3;
        int n4;
        this.theDREMGui = dREMGui;
        this.theFrame = jFrame;
        this.theTimeiohmm = dREM_Timeiohmm;
        this.ptr = treenode;
        this.npathID = bigInteger;
        this.nchild = n2;
        this.ntable = n;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        this.numrows = dREM_Timeiohmm.bindingData.regNames.length;
        int n5 = dREM_Timeiohmm.bindingData.signedBindingValuesUnsorted.size();
        this.miRNAScorePresent = dREM_Timeiohmm.scaleMIRNAExp && dREM_Timeiohmm.miRNADataSet != null;
        this.regPriorsPresent = dREM_Timeiohmm.bindingData.regPriors != null;
        this.columnNames = new String[6 + 2 * n5 + (this.miRNAScorePresent ? 2 : 0) + (this.regPriorsPresent ? 2 : 0)];
        this.tabledata = new String[this.numrows][this.columnNames.length];
        this.columnNames[0] = "TF";
        this.columnNames[1] = "Coeff";
        String string = treenode.numchildren == 3 ? (n == 0 ? "Low " : (n == 1 ? "Mid " : "High ")) : "This ";
        for (n4 = 0; n4 < n5; ++n4) {
            this.columnNames[2 + n4] = string + dREM_Timeiohmm.bindingData.signedBindingValuesSorted[n4];
            this.columnNames[2 + n5 + n4] = "Other " + dREM_Timeiohmm.bindingData.signedBindingValuesSorted[n4];
        }
        n4 = this.columnNames.length - 1;
        int n6 = this.columnNames.length - 2;
        int n7 = this.columnNames.length - 3;
        int n8 = this.columnNames.length - 4;
        int n9 = this.columnNames.length - 8 + (this.miRNAScorePresent ? 0 : 2);
        int n10 = this.columnNames.length - 7 + (this.miRNAScorePresent ? 0 : 2);
        int n11 = this.columnNames.length - 6;
        int n12 = this.columnNames.length - 5;
        if (this.miRNAScorePresent) {
            this.columnNames[n11] = "Act. Score";
            this.columnNames[n12] = "Activity";
        }
        if (this.regPriorsPresent) {
            this.columnNames[n10] = "Act. Prior";
            this.columnNames[n9] = "Max Act. Prior";
        }
        this.columnNames[n8] = "Avg. " + string.trim();
        this.columnNames[n7] = "Avg. Other";
        this.columnNames[n6] = "Diff";
        this.columnNames[n4] = "Score";
        double[] dArray = null;
        if (!dREM_Timeiohmm.BREGDREM) {
            dArray = treenode.tranC.dcoeff;
        }
        this.nf = NumberFormat.getInstance(Locale.ENGLISH);
        this.nf.setMinimumFractionDigits(3);
        this.nf.setMaximumFractionDigits(3);
        for (int i = 0; i < this.tabledata.length; ++i) {
            this.tabledata[i][0] = dREM_Timeiohmm.bindingData.regNames[i];
            this.tabledata[i][n6] = this.nf.format(treenode.ddiff[i][n2]);
            this.tabledata[i][n4] = DREMGui_SplitTable.doubleToSz(treenode.dpvals[i][n2]);
            if (this.miRNAScorePresent) {
                Integer n13 = dREM_Timeiohmm.reg2DataSetIndex.get(dREM_Timeiohmm.bindingData.regNames[i].toUpperCase());
                if (n13 != null) {
                    n3 = dREM_Timeiohmm.bindingData.regTypes[i];
                    double d = 0.0;
                    switch (n3) {
                        case 1: {
                            d = dREM_Timeiohmm.miRNADataSet.data[n13][treenode.ndepth + 1];
                            break;
                        }
                        case 0: {
                            d = dREM_Timeiohmm.theDataSet.data[n13][treenode.ndepth];
                        }
                    }
                    this.tabledata[i][n12] = String.valueOf(d);
                } else {
                    this.tabledata[i][n12] = "N/A";
                }
                this.tabledata[i][n11] = String.valueOf(treenode.tranC.traindataTF[i][0]);
            }
            this.tabledata[i][1] = n2 == treenode.numchildren - 1 || dArray == null ? "0" : this.nf.format(dArray[(this.tabledata.length + 1) * n2 + i + 1]);
            this.tabledata[i][n7] = this.nf.format(treenode.dscoreother[i][n2]);
            this.tabledata[i][n8] = this.nf.format(treenode.dscore[i][n2]);
            for (int j = 0; j < n5; ++j) {
                this.tabledata[i][2 + j] = "" + treenode.ncountvals[i][n2][j];
                this.tabledata[i][2 + n5 + j] = "" + treenode.nothersum[i][n2][j];
            }
            if (!this.regPriorsPresent) continue;
            this.tabledata[i][n10] = this.lrgNumFmt(treenode.dTFActivityScore[i], this.nf);
            this.tabledata[i][n9] = this.lrgNumFmt(dREM_Timeiohmm.dMaxTFActivityScore[i], this.nf);
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        this.sorter.setSortingStatus(n4, 1);
        JTable jTable = new JTable(this.sorter);
        for (n3 = 0; n3 < this.columnNames.length; ++n3) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n3);
            tableColumn.setPreferredWidth(100);
        }
        this.sorter.setTableHeader(jTable.getTableHeader());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(700, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 400)));
        this.add(jScrollPane);
        this.addBottom();
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            printWriter.print(this.columnNames[n] + "\t");
        }
        printWriter.println(this.columnNames[this.columnNames.length - 1]);
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.sorter.getValueAt(n, i) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n, this.columnNames.length - 1));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            stringBuffer.append(this.columnNames[n] + "\t");
        }
        stringBuffer.append(this.columnNames[this.columnNames.length - 1] + "\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, this.columnNames.length - 1) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("save")) {
            try {
                int n = DREM_IO.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = DREM_IO.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    if (string.equals("save")) {
                        this.printFile(printWriter);
                    }
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("go")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JFrame jFrame = new JFrame("GO Split Table");
                    jFrame.setDefaultCloseOperation(2);
                    jFrame.setLocation(150, 200);
                    JTabbedPane jTabbedPane = new JTabbedPane();
                    for (int i = 0; i < DREMGui_SplitTable.this.ptr.numchildren; ++i) {
                        String string;
                        String string2;
                        DREMGui_GOSplitTable dREMGui_GOSplitTable = new DREMGui_GOSplitTable(DREMGui_SplitTable.this.theDREMGui, jFrame, DREMGui_SplitTable.this.theTimeiohmm, DREMGui_SplitTable.this.ptr, DREMGui_SplitTable.this.ptr.orderA[i]);
                        if (DREMGui_SplitTable.this.ptr.numchildren <= 3) {
                            if (i == 0) {
                                string2 = "Low Path";
                                string = "Low";
                            } else if (i == 1 && DREMGui_SplitTable.this.ptr.numchildren == 3) {
                                string2 = "Middle Path";
                                string = "Middle";
                            } else {
                                string2 = "High Path";
                                string = "High";
                            }
                        } else {
                            string2 = "Child " + i + " vs. Others ";
                            string = "Child " + i;
                        }
                        jTabbedPane.addTab(string2, null, dREMGui_GOSplitTable, string);
                    }
                    jTabbedPane.setOpaque(true);
                    jFrame.setContentPane(jTabbedPane);
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
        } else if (string.equals("help")) {
            String string2 = "This table gives information about the selected split.  Consult section 4.14 of the user manual for more details on this table. ";
            Util.renderDialog(this.theFrame, string2);
        } else {
            if (string.equals("decod")) {
                String string3 = System.getProperty("user.dir") + "/upReggedSeqs" + this.ptr.hashCode() + ".txt";
                String string4 = System.getProperty("user.dir") + "/downReggedSeqs" + this.ptr.hashCode() + ".txt";
                String string5 = System.getProperty("user.dir") + "/decodOutput" + this.ptr.hashCode() + ".txt";
                try {
                    this.outputDECOD(string3, string4, string5);
                }
                catch (IOException iOException) {
                    System.out.println("Error writing files for use by DECOD.");
                    return;
                }
            }
            if (string.equals("decodhigh")) {
                String string6 = System.getProperty("user.dir") + "/upReggedSeqs" + this.ptr.hashCode() + ".txt";
                String string7 = System.getProperty("user.dir") + "/downReggedSeqs" + this.ptr.hashCode() + ".txt";
                String string8 = System.getProperty("user.dir") + "/decodOutput" + this.ptr.hashCode() + ".txt";
                try {
                    this.outputDECOD(string6, string7, string8);
                }
                catch (IOException iOException) {
                    System.out.println("Error writing files for use by DECOD.");
                    return;
                }
            }
            if (string.equals("decodlow")) {
                String string9 = System.getProperty("user.dir") + "/upReggedSeqs" + this.ptr.hashCode() + ".txt";
                String string10 = System.getProperty("user.dir") + "/downReggedSeqs" + this.ptr.hashCode() + ".txt";
                String string11 = System.getProperty("user.dir") + "/decodOutput" + this.ptr.hashCode() + ".txt";
                try {
                    this.outputDECOD(string10, string9, string11);
                }
                catch (IOException iOException) {
                    System.out.println("Error writing files for use by DECOD.");
                    return;
                }
            }
        }
    }

    private void addBottom() {
        JButton jButton;
        JPanel jPanel = new JPanel();
        String string = "Total number of genes most likely going through this state is " + this.ptr.numPath;
        JLabel jLabel = new JLabel(string);
        jPanel.setBackground(Color.white);
        jPanel.add(jLabel);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        String string2 = this.nchild == -1 ? (this.ptr.nextptr[0].dmean < this.ptr.nextptr[1].dmean ? (this.theTimeiohmm.BREGDREM ? "Transition probability of high path is " + this.nf.format(1.0 - this.ptr.ptrans[0]) : "Intercept coefficient is " + this.nf.format(-this.ptr.tranC.dcoeff[0])) : (this.theTimeiohmm.BREGDREM ? "Transition probability of high path is " + this.nf.format(this.ptr.ptrans[0]) : "Intercept coefficient is " + this.nf.format(this.ptr.tranC.dcoeff[0]))) : (this.theTimeiohmm.BREGDREM ? "Transition probability is " + this.nf.format(this.ptr.ptrans[this.nchild]) : (this.nchild == this.ptr.numchildren - 1 ? "Intercept coefficient is 0" : "Intercept coefficient is " + this.nf.format(this.ptr.tranC.dcoeff[(this.tabledata.length + 1) * this.nchild])));
        string2 = string2 + "; This " + this.theTimeiohmm.theDataSet.dsamplemins[this.ptr.ndepth] + " state output distribution is Normal(mu =" + this.nf.format(this.ptr.dmean) + ",sigma = " + this.nf.format(this.ptr.dsigma) + ")";
        JLabel jLabel2 = new JLabel(string2);
        jPanel2.setBackground(Color.white);
        jPanel2.add(jLabel2);
        jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel2);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.saveButton.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        this.goButton = new JButton("GO Split Table");
        this.goButton.setActionCommand("go");
        this.goButton.setMinimumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.goButton.addActionListener(this);
        jPanel3.add(this.goButton);
        jPanel3.add(this.copyButton);
        jPanel3.add(this.saveButton);
        if (this.theTimeiohmm.gene2FastaMap != null) {
            if (this.nchild == -1) {
                jButton = new JButton("Run DECOD High");
                jButton.addActionListener(this);
                jButton.setActionCommand("decodhigh");
                jPanel3.add(jButton);
                JButton jButton2 = new JButton("Run DECOD Low");
                jButton2.addActionListener(this);
                jButton2.setActionCommand("decodlow");
                jPanel3.add(jButton2);
            } else {
                jButton = new JButton("Run DECOD");
                jButton.addActionListener(this);
                jButton.setActionCommand("decod");
                jPanel3.add(jButton);
            }
        }
        jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel3.add(jButton);
        jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel3);
    }

    public static String doubleToSz(double d) {
        String string;
        int n = 0;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(3);
        numberFormat.setMaximumFractionDigits(3);
        NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat2.setMinimumFractionDigits(2);
        numberFormat2.setMaximumFractionDigits(2);
        if (d <= 0.0) {
            string = "0.000";
        } else {
            double d2;
            for (d2 = d; d2 < 0.9995 && d2 > 0.0; d2 *= 10.0) {
                --n;
            }
            if (n < -2) {
                d2 = Math.pow(10.0, Math.log(d) / Math.log(10.0) - (double)n);
                string = numberFormat2.format(d2) + "e" + n;
            } else {
                string = numberFormat.format(d);
            }
        }
        return string;
    }

    public void outputDECOD(String string, String string2, String string3) throws IOException {
        File file = new File(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        File file2 = new File(string2);
        BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file2));
        int n = this.ptr.ndepth;
        for (int i = 0; i < this.theDREMGui.storedbestpath.length; ++i) {
            Object object;
            int n2;
            BigInteger bigInteger = this.theDREMGui.storedbestpath[i];
            DREM_Timeiohmm.Treenode treenode = this.theTimeiohmm.treeptr;
            for (n2 = 0; n2 < n; ++n2) {
                object = bigInteger.divide(new BigInteger("" + this.theTimeiohmm.nmaxchild).pow(this.theTimeiohmm.numcols - n2 - 1)).mod(new BigInteger("" + this.theTimeiohmm.nmaxchild));
                treenode = treenode.nextptr[((BigInteger)object).intValue()];
            }
            if (!this.ptr.equals(treenode)) continue;
            n2 = bigInteger.divide(new BigInteger("" + this.theTimeiohmm.nmaxchild).pow(this.theTimeiohmm.numcols - n - 1)).mod(new BigInteger("" + this.theTimeiohmm.nmaxchild)).intValue();
            object = this.theTimeiohmm.gene2FastaMap.get(this.theTimeiohmm.theDataSet.genenames[i].toUpperCase());
            if (object == null) continue;
            if (this.ptr.numchildren == 2) {
                if (this.ptr.nextptr[0].dmean < this.ptr.nextptr[1].dmean) {
                    if (n2 == 0) {
                        bufferedWriter2.write((String)object);
                        continue;
                    }
                    bufferedWriter.write((String)object);
                    continue;
                }
                if (n2 == 1) {
                    bufferedWriter2.write((String)object);
                    continue;
                }
                bufferedWriter.write((String)object);
                continue;
            }
            if (n2 == this.nchild) {
                bufferedWriter2.write((String)object);
                continue;
            }
            bufferedWriter.write((String)object);
        }
        ((Writer)bufferedWriter2).close();
        ((Writer)bufferedWriter).close();
        try {
            String[] stringArray = new String[]{"java", "-jar", this.theTimeiohmm.decodPath, "-pos", string, "-neg", string2, "-o", string3};
            Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            System.out.println("Error running DECOD.");
            System.out.println(exception.getMessage());
        }
    }

    public String lrgNumFmt(double d, NumberFormat numberFormat) {
        if (d < 1.0) {
            return DREMGui_SplitTable.doubleToSz(d);
        }
        if (d < 1000.0) {
            return numberFormat.format(d);
        }
        if (this.df == null) {
            this.df = new DecimalFormat("0.00E0");
        }
        return this.df.format(d).replace('E', 'e');
    }
}

