/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui;
import edu.cmu.cs.sb.drem.DREMGui_PredictModel;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DREMGui_Predict
extends JPanel
implements ActionListener {
    static final Color bgColor = Color.white;
    static final Color fgColor = Color.black;
    DREM_Timeiohmm.Treenode rootptr;
    JRadioButton intersectButton;
    JRadioButton unionButton;
    int[] tfVals;
    DREMGui_PredictModel hmst;
    TableSorter sorter;
    DREM_Timeiohmm theTimeiohmm;
    DREMGui theDREMGui;
    int numrows;
    int numcols;
    JButton hideButton;
    JCheckBox conditionalBox;
    JFrame theFrame;

    public DREMGui_Predict(JFrame jFrame, DREMGui dREMGui, DREM_Timeiohmm.Treenode treenode) {
        Object object;
        int n;
        this.theFrame = jFrame;
        this.theDREMGui = dREMGui;
        this.theTimeiohmm = dREMGui.theTimeiohmm;
        this.rootptr = treenode;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        this.tfVals = this.theTimeiohmm.bindingData.signedBindingValuesSorted;
        this.numcols = this.tfVals.length + 1;
        this.numrows = this.theTimeiohmm.bindingData.regNames.length;
        Object[][] objectArray = new Object[this.numrows][this.numcols];
        String[] stringArray = new String[this.numcols];
        stringArray[0] = "TF";
        for (int i = 1; i < this.numcols; ++i) {
            stringArray[i] = "" + this.tfVals[i - 1];
        }
        ButtonGroup[] buttonGroupArray = new ButtonGroup[this.numrows];
        for (int i = 0; i < this.numrows; ++i) {
            objectArray[i][0] = this.theTimeiohmm.bindingData.regNames[i];
            buttonGroupArray[i] = new ButtonGroup();
            for (n = 1; n < this.numcols; ++n) {
                object = new JRadioButton("");
                ((AbstractButton)object).setHorizontalAlignment(0);
                ((JComponent)object).setBackground(Color.white);
                objectArray[i][n] = object;
                buttonGroupArray[i].add((AbstractButton)object);
            }
            ((JRadioButton)objectArray[i][this.numcols / 2]).setSelected(true);
        }
        this.hmst = new DREMGui_PredictModel(objectArray, stringArray);
        this.sorter = new TableSorter(this.hmst);
        JTable jTable = new JTable(this.sorter){

            public void tableChanged(TableModelEvent tableModelEvent) {
                super.tableChanged(tableModelEvent);
                this.repaint();
            }
        };
        for (n = 1; n < this.numcols; ++n) {
            object = "" + this.tfVals[n - 1];
            jTable.getColumn(object).setCellRenderer(new RadioButtonRenderer());
            jTable.getColumn(object).setCellEditor(new RadioButtonEditor(new JCheckBox()));
        }
        this.sorter.setTableHeader(jTable.getTableHeader());
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(125);
        for (int i = 1; i < this.numcols; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(50);
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(425, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 300)));
        this.add(jScrollPane);
        JPanel jPanel = new JPanel();
        this.conditionalBox = new JCheckBox("Probabilities should be conditional on gene not being filtered");
        jPanel.add(this.conditionalBox);
        this.conditionalBox.setBackground(Color.white);
        jPanel.setBackground(Color.white);
        this.conditionalBox.setSelected(true);
        jPanel.add(this.conditionalBox);
        this.add(jPanel);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        JButton jButton = new JButton("Show Prediction");
        jButton.setActionCommand("show");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        this.hideButton = new JButton("Hide Prediction");
        this.hideButton.setActionCommand("hide");
        this.hideButton.addActionListener(this);
        this.hideButton.setEnabled(false);
        jPanel2.add(this.hideButton);
        JButton jButton2 = new JButton("Default Settings");
        jButton2.setActionCommand("default");
        jButton2.addActionListener(this);
        jPanel2.add(jButton2);
        jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JButton jButton3 = new JButton(Util.createImageIcon("Help16.gif"));
        jButton3.addActionListener(this);
        jButton3.setActionCommand("help");
        jPanel2.add(jButton3);
        this.add(jPanel2);
    }

    void setAll(boolean bl) {
        for (int i = 0; i < this.numrows; ++i) {
            for (int j = 1; j < this.numcols; ++j) {
                this.hmst.setValueAt(bl, i, j);
            }
        }
    }

    void setPredictTextVisible(DREM_Timeiohmm.Treenode treenode, boolean bl) {
        if (treenode != null) {
            treenode.thepredictText.setVisible(bl);
            for (int i = 0; i < treenode.numchildren; ++i) {
                this.setPredictTextVisible(treenode.nextptr[i], bl);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int[] nArray = new int[this.numrows];
        if (string.equals("show")) {
            this.theDREMGui.bshowpredict = true;
            block2: for (int i = 0; i < this.numrows; ++i) {
                for (int j = 1; j < this.numcols; ++j) {
                    if (!((JRadioButton)this.hmst.getValueAt(i, j)).isSelected()) continue;
                    nArray[i] = this.tfVals[j - 1];
                    continue block2;
                }
            }
            this.hideButton.setEnabled(true);
            try {
                double d;
                if (this.conditionalBox.isSelected()) {
                    d = 1.0;
                } else {
                    double[] dArray = this.theTimeiohmm.filteredClassifier.distributionForInstance(nArray);
                    d = dArray[1];
                }
                this.theTimeiohmm.predictTime(nArray, d, this.rootptr);
                this.setPredictTextVisible(this.rootptr, true);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        } else if (string.equals("default")) {
            int n = this.numcols / 2;
            for (int i = 0; i < this.numrows; ++i) {
                ((JRadioButton)this.hmst.getValueAt(i, n)).setSelected(true);
            }
            this.repaint();
        } else if (string.equals("hide")) {
            this.theDREMGui.bshowpredict = false;
            this.setPredictTextVisible(this.rootptr, false);
            this.hideButton.setEnabled(false);
        } else if (string.equals("help")) {
            String string2 = "DREM allows one to view for any set of transcription factor-gene regulation interaction inputs, the probability under the model of being in each state.  Through this dialog box one can specify a set of TF-gene interaction inputs for which they want to see the transition probabilities.  After pressing the button Show Prediction, the probabilities appear on the main interface.  The predictions then appear in the node of the states. Pressing the Hide Prediction button hides the predictions labels. Pressing the Default Settings button sets all input value for each transcription to `0'.  If the options Probabilities should be conditional on gene not being filtered, then the probabilities are computed conditional on the gene not being filtered. If the box is unchecked, then all probabilities are multiplied against the probability of a gene with the selected inputs not being filtered.  This probability of a gene not being filtered for a given set of inputs is determined using a Naive Bayes classifier.";
            Util.renderDialog(this.theFrame, string2, -200, -100);
        }
    }

    static class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        private JRadioButton button;

        public RadioButtonEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return null;
            }
            this.button = (JRadioButton)object;
            this.button.addItemListener(this);
            return (Component)object;
        }

        public Object getCellEditorValue() {
            this.button.removeItemListener(this);
            return this.button;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            super.fireEditingStopped();
        }
    }

    static class RadioButtonRenderer
    implements TableCellRenderer {
        RadioButtonRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return null;
            }
            return (Component)object;
        }
    }
}

