/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui;
import edu.cmu.cs.sb.drem.DREMGui_SaveSigRegs;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DREMGui_KeyInputs
extends JPanel
implements ActionListener,
ChangeListener,
ItemListener {
    static final Color bgColor = Color.white;
    static final Color fgColor = Color.black;
    JSlider theSlider;
    JSlider miRNASlider;
    JSlider theSliderPercent;
    JButton hideButton;
    JButton regToggleButton;
    JButton regColorToggleButton;
    JButton saveButton;
    JFrame saveRegsFrame;
    boolean displayTF = true;
    boolean displayMIRNA = true;
    Hashtable<Integer, JLabel> theDictionary;
    Hashtable<Integer, JLabel> miRNADictionary;
    Hashtable<Integer, JLabel> theDictionaryPercent;
    DREMGui theDREMGui;
    JLabel pvalLabel;
    JLabel pvalmiRNALabel;
    JLabel percentLabel;
    ButtonGroup group = new ButtonGroup();
    JRadioButton splitButton;
    JRadioButton edgeSplitButton;
    JRadioButton edgeFullButton;
    JRadioButton activityButton;
    JRadioButton firstActivityButton;
    JFrame theFrame;
    NumberFormat nf2;

    public DREMGui_KeyInputs(JFrame jFrame, DREMGui dREMGui) {
        this.theFrame = jFrame;
        this.theDREMGui = dREMGui;
        this.nf2 = NumberFormat.getInstance(Locale.ENGLISH);
        this.nf2.setMinimumFractionDigits(2);
        this.nf2.setMaximumFractionDigits(2);
        boolean bl = this.theDREMGui.theTimeiohmm.bindingData.existingRegTypes.contains(1);
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        int n = (int)Math.round(-100.0 * Math.log(this.theDREMGui.dkeyinputpvalue) / Math.log(10.0)) / 10;
        this.theDREMGui.dkeyinputpvalue = Math.pow(10.0, (double)(-n) / 10.0);
        this.theDREMGui.dkeymiRNAinputpvalue = Math.pow(10.0, (double)(-n) / 10.0);
        JLabel jLabel = new JLabel("  Only display key TFs with a score less than 10^-X where X is:");
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        this.add(jPanel);
        this.theSlider = new JSlider(0, 120, n);
        this.theDictionary = new Hashtable();
        for (int i = 0; i <= 12; ++i) {
            this.theDictionary.put(new Integer(i * 10), new JLabel("" + i));
        }
        this.theSlider.setLabelTable(this.theDictionary);
        this.theSlider.setMajorTickSpacing(10);
        this.theSlider.setMinorTickSpacing(5);
        this.theSlider.setPaintTicks(true);
        this.theSlider.setPaintLabels(true);
        this.theSlider.addChangeListener(this);
        this.theSlider.setPaintTicks(true);
        this.theSlider.setAlignmentX(0.0f);
        this.add(this.theSlider);
        JPanel jPanel2 = new JPanel();
        this.pvalLabel = new JLabel("X = " + (double)n / 10.0 + ";  score threshold is " + DREMGui_KeyInputs.doubleToSz(Math.pow(10.0, (double)(-n) / 10.0)));
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(this.pvalLabel);
        jPanel2.setBackground(Color.white);
        this.add(jPanel2);
        JLabel jLabel2 = new JLabel("  Only display key miRNAs with a score less than 10^-X where X is:");
        JPanel jPanel3 = new JPanel();
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(jLabel2);
        jPanel3.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        if (bl) {
            this.add(jPanel3);
        }
        this.miRNASlider = new JSlider(0, 120, n);
        this.miRNADictionary = new Hashtable();
        for (int i = 0; i <= 12; ++i) {
            this.miRNADictionary.put(new Integer(i * 10), new JLabel("" + i));
        }
        this.miRNASlider.setLabelTable(this.miRNADictionary);
        this.miRNASlider.setMajorTickSpacing(10);
        this.miRNASlider.setMinorTickSpacing(5);
        this.miRNASlider.setPaintTicks(true);
        this.miRNASlider.setPaintLabels(true);
        this.miRNASlider.addChangeListener(this);
        this.miRNASlider.setPaintTicks(true);
        this.miRNASlider.setAlignmentX(0.0f);
        if (bl) {
            this.add(this.miRNASlider);
        }
        JPanel jPanel4 = new JPanel();
        this.pvalmiRNALabel = new JLabel("X = " + (double)n / 10.0 + ";  score threshold is " + DREMGui_KeyInputs.doubleToSz(Math.pow(10.0, (double)(-n) / 10.0)));
        jPanel4.setAlignmentX(0.0f);
        jPanel4.add(this.pvalmiRNALabel);
        jPanel4.setBackground(Color.white);
        if (bl) {
            this.add(jPanel4);
        }
        JLabel jLabel3 = new JLabel(" Compute and display key regulator significance based on: ");
        JPanel jPanel5 = new JPanel();
        jPanel5.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        jPanel5.add(jLabel3);
        jPanel5.setAlignmentX(0.0f);
        this.add(jPanel5);
        jLabel3.setAlignmentX(0.0f);
        this.theDREMGui.blowbelow = true;
        this.theDREMGui.blowabove = true;
        this.splitButton = new JRadioButton("Split Significance");
        this.edgeSplitButton = new JRadioButton("Path Significance Conditional on Split");
        this.edgeFullButton = new JRadioButton("Path Significance Overall");
        this.activityButton = new JRadioButton("Activity Score");
        this.firstActivityButton = new JRadioButton("Activity Score (first appearance per path)");
        this.group = new ButtonGroup();
        if (this.theDREMGui.nKeyInputType == 0) {
            this.splitButton.setSelected(true);
        } else if (this.theDREMGui.nKeyInputType == 1) {
            this.edgeSplitButton.setSelected(true);
        } else if (this.theDREMGui.nKeyInputType == 778) {
            this.firstActivityButton.setSelected(true);
        } else if (this.theDREMGui.nKeyInputType == 777) {
            this.activityButton.setSelected(true);
        } else {
            this.edgeFullButton.setSelected(true);
        }
        this.group.add(this.edgeSplitButton);
        this.group.add(this.edgeFullButton);
        this.group.add(this.splitButton);
        if (this.theDREMGui.theTimeiohmm.bindingData.regPriors != null) {
            this.group.add(this.activityButton);
            this.group.add(this.firstActivityButton);
        }
        this.splitButton.addItemListener(this);
        this.edgeSplitButton.addItemListener(this);
        this.edgeFullButton.addItemListener(this);
        this.activityButton.addItemListener(this);
        this.firstActivityButton.addItemListener(this);
        this.add(this.edgeSplitButton);
        this.add(this.edgeFullButton);
        this.add(this.splitButton);
        if (this.theDREMGui.theTimeiohmm.bindingData.regPriors != null) {
            this.add(this.activityButton);
            this.add(this.firstActivityButton);
        }
        this.splitButton.setAlignmentX(0.0f);
        this.splitButton.setBackground(Color.white);
        this.edgeSplitButton.setAlignmentX(0.0f);
        this.edgeSplitButton.setBackground(Color.white);
        this.edgeFullButton.setAlignmentX(0.0f);
        this.edgeFullButton.setBackground(Color.white);
        this.activityButton.setAlignmentX(0.0f);
        this.activityButton.setBackground(Color.white);
        this.firstActivityButton.setAlignmentX(0.0f);
        this.firstActivityButton.setBackground(Color.white);
        JLabel jLabel4 = new JLabel("For Path Significance Conditional on Split - Minimum Split %: ");
        JPanel jPanel6 = new JPanel();
        jPanel6.setAlignmentX(0.0f);
        jPanel6.add(jLabel4);
        jPanel6.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        this.add(jPanel6);
        int n2 = (int)Math.round(this.theDREMGui.dsplitpercent * 100.0);
        this.theDREMGui.dsplitpercent = (double)n2 / 100.0;
        this.theSliderPercent = new JSlider(0, 100, n2);
        this.theDictionaryPercent = new Hashtable();
        for (int i = 0; i <= 10; ++i) {
            this.theDictionaryPercent.put(new Integer(i * 10), new JLabel("" + i * 10));
        }
        this.theSliderPercent.setLabelTable(this.theDictionaryPercent);
        this.theSliderPercent.setMajorTickSpacing(10);
        this.theSliderPercent.setMinorTickSpacing(5);
        this.theSliderPercent.setPaintTicks(true);
        this.theSliderPercent.setPaintLabels(true);
        this.theSliderPercent.addChangeListener(this);
        this.theSliderPercent.setPaintTicks(true);
        this.theSliderPercent.setAlignmentX(0.0f);
        this.add(this.theSliderPercent);
        JPanel jPanel7 = new JPanel();
        this.percentLabel = new JLabel(" Minimum Split % is " + this.nf2.format(100.0 * this.theDREMGui.dsplitpercent));
        jPanel7.setAlignmentX(0.0f);
        jPanel7.add(this.percentLabel);
        jPanel7.setBackground(Color.white);
        jPanel7.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel7);
        this.hideButton = new JButton("Hide Key Reg Labels");
        this.hideButton.setActionCommand("hide");
        this.hideButton.addActionListener(this);
        this.regToggleButton = new JButton("Toggle to Only TF");
        this.regToggleButton.setActionCommand("toggle");
        this.regToggleButton.setMinimumSize(new Dimension(800, 20));
        this.regToggleButton.addActionListener(this);
        this.regToggleButton.setForeground(this.theDREMGui.keyInputLabelColor);
        this.regColorToggleButton = new JButton("Toggle Exp. Coloring");
        this.regColorToggleButton.setActionCommand("togglecolor");
        this.regColorToggleButton.setMinimumSize(new Dimension(800, 20));
        this.regColorToggleButton.addActionListener(this);
        this.regColorToggleButton.setForeground(this.theDREMGui.keyInputLabelColor);
        JPanel jPanel8 = new JPanel();
        jPanel8.setAlignmentX(0.0f);
        jPanel8.setBackground(Color.white);
        jPanel8.add(this.hideButton);
        if (bl) {
            jPanel8.add(this.regToggleButton);
        }
        jPanel8.add(this.regColorToggleButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel8.add(jButton);
        this.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setAlignmentX(0.0f);
        jPanel9.setBackground(Color.white);
        this.saveButton = new JButton("Save Significant Regulators to File");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (DREMGui_KeyInputs.this.saveRegsFrame == null) {
                            DREMGui_KeyInputs.this.saveRegsFrame = new JFrame("Save Regulators to File");
                            DREMGui_KeyInputs.this.saveRegsFrame.setDefaultCloseOperation(2);
                            DREMGui_KeyInputs.this.saveRegsFrame.setLocation(400, 300);
                            DREMGui_SaveSigRegs dREMGui_SaveSigRegs = new DREMGui_SaveSigRegs(DREMGui_KeyInputs.this.theDREMGui, DREMGui_KeyInputs.this.saveRegsFrame);
                            dREMGui_SaveSigRegs.setOpaque(true);
                            DREMGui_KeyInputs.this.saveRegsFrame.setContentPane(dREMGui_SaveSigRegs);
                            DREMGui_KeyInputs.this.saveRegsFrame.pack();
                        } else {
                            DREMGui_KeyInputs.this.saveRegsFrame.setExtendedState(0);
                        }
                        DREMGui_KeyInputs.this.saveRegsFrame.setVisible(true);
                    }
                });
            }
        });
        jPanel9.add(this.saveButton);
        this.add(jPanel9);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        block3: {
            JSlider jSlider;
            block5: {
                block4: {
                    jSlider = (JSlider)changeEvent.getSource();
                    this.theDREMGui.sigRegs = new HashSet();
                    if (jSlider.getValueIsAdjusting()) break block3;
                    if (jSlider != this.theSlider) break block4;
                    this.theDREMGui.dkeyinputpvalue = Math.pow(10.0, (double)(-jSlider.getValue()) / 10.0);
                    this.pvalLabel.setText("X = " + (double)jSlider.getValue() / 10.0 + "; score threshold is " + DREMGui_KeyInputs.doubleToSz(this.theDREMGui.dkeyinputpvalue));
                    int n = this.theDREMGui.hidesigList.size();
                    for (int i = 0; i < n; ++i) {
                        DREMGui.SigInfoRec sigInfoRec = this.theDREMGui.hidesigList.get(i);
                        sigInfoRec.border.removeAllChildren();
                        this.theDREMGui.setSigText(sigInfoRec.theSigTF, (PPath)sigInfoRec.border, sigInfoRec.ntype, sigInfoRec.ndepth, this.displayTF, this.displayMIRNA, sigInfoRec.node, this.theDREMGui.colorSigTFs);
                    }
                    break block3;
                }
                if (jSlider != this.theSliderPercent) break block5;
                this.theDREMGui.dsplitpercent = (double)jSlider.getValue() / 100.0;
                this.percentLabel.setText(" Minimum Split % is " + this.nf2.format(100.0 * this.theDREMGui.dsplitpercent));
                int n = this.theDREMGui.hidesigList.size();
                for (int i = 0; i < n; ++i) {
                    DREMGui.SigInfoRec sigInfoRec = this.theDREMGui.hidesigList.get(i);
                    if (sigInfoRec.ntype != 1) continue;
                    sigInfoRec.border.removeAllChildren();
                    this.theDREMGui.setSigText(sigInfoRec.theSigTF, (PPath)sigInfoRec.border, sigInfoRec.ntype, sigInfoRec.ndepth, this.displayTF, this.displayMIRNA, sigInfoRec.node, this.theDREMGui.colorSigTFs);
                }
                break block3;
            }
            if (jSlider != this.miRNASlider) break block3;
            this.theDREMGui.dkeymiRNAinputpvalue = Math.pow(10.0, (double)(-jSlider.getValue()) / 10.0);
            this.pvalmiRNALabel.setText("X = " + (double)jSlider.getValue() / 10.0 + "; score threshold is " + DREMGui_KeyInputs.doubleToSz(this.theDREMGui.dkeymiRNAinputpvalue));
            int n = this.theDREMGui.hidesigList.size();
            for (int i = 0; i < n; ++i) {
                DREMGui.SigInfoRec sigInfoRec = this.theDREMGui.hidesigList.get(i);
                sigInfoRec.border.removeAllChildren();
                this.theDREMGui.setSigText(sigInfoRec.theSigTF, (PPath)sigInfoRec.border, sigInfoRec.ntype, sigInfoRec.ndepth, this.displayTF, this.displayMIRNA, sigInfoRec.node, this.theDREMGui.colorSigTFs);
            }
        }
    }

    public static String doubleToSz(double d) {
        String string;
        int n = 0;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(3);
        numberFormat.setMaximumFractionDigits(3);
        NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat2.setMinimumFractionDigits(2);
        numberFormat2.setMaximumFractionDigits(2);
        if (d <= 0.0) {
            string = "0.000";
        } else {
            double d2;
            for (d2 = d; d2 < 0.9995 && d2 > 0.0; d2 *= 10.0) {
                --n;
            }
            d2 = d * Math.pow(10.0, -n);
            string = n < -3 ? numberFormat2.format(d2) + " * 10^" + n : numberFormat.format(d);
        }
        return string;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.splitButton.isSelected()) {
            this.theDREMGui.nKeyInputType = 0;
        } else if (this.edgeSplitButton.isSelected()) {
            this.theDREMGui.nKeyInputType = 1;
        } else if (this.edgeFullButton.isSelected()) {
            this.theDREMGui.nKeyInputType = 2;
        } else if (this.activityButton.isSelected()) {
            this.theDREMGui.nKeyInputType = 777;
        } else if (this.firstActivityButton.isSelected()) {
            this.theDREMGui.nKeyInputType = 778;
        }
        int n = this.theDREMGui.hidesigList.size();
        this.theDREMGui.sigRegs = new HashSet();
        for (int i = 0; i < n; ++i) {
            DREMGui.SigInfoRec sigInfoRec = this.theDREMGui.hidesigList.get(i);
            sigInfoRec.border.removeAllChildren();
            this.theDREMGui.setSigText(sigInfoRec.theSigTF, (PPath)sigInfoRec.border, sigInfoRec.ntype, sigInfoRec.ndepth, this.displayTF, this.displayMIRNA, sigInfoRec.node, this.theDREMGui.colorSigTFs);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("help")) {
            String string2 = "This window controls the Key Input labels appearing on the DREM output interface.   Consult section 4.4 of the user manual for more details on this window. TF activity scores do not use pvalues so the TFs shown will be those with activity scores greater than or equal to the inverse of the threshold.";
            Util.renderDialog(this.theFrame, string2, -350, -100);
        } else if (string.equals("toggle")) {
            this.theDREMGui.sigRegs = new HashSet();
            if (this.displayTF && this.displayMIRNA) {
                this.displayMIRNA = false;
                this.regToggleButton.setText("Toggle to Only miRNA");
            } else if (this.displayTF) {
                this.displayTF = false;
                this.displayMIRNA = true;
                this.regToggleButton.setText("Toggle to miRNA and TF");
            } else {
                this.displayTF = true;
                this.regToggleButton.setText("Toggle to Only TF");
            }
            this.miRNASlider.setEnabled(this.displayMIRNA);
            this.theSlider.setEnabled(this.displayTF);
            int n = this.theDREMGui.hidesigList.size();
            for (int i = 0; i < n; ++i) {
                DREMGui.SigInfoRec sigInfoRec = this.theDREMGui.hidesigList.get(i);
                sigInfoRec.border.removeAllChildren();
                this.theDREMGui.setSigText(sigInfoRec.theSigTF, (PPath)sigInfoRec.border, sigInfoRec.ntype, sigInfoRec.ndepth, this.displayTF, this.displayMIRNA, sigInfoRec.node, this.theDREMGui.colorSigTFs);
            }
            this.theFrame.pack();
        } else if (string.equals("togglecolor")) {
            this.theDREMGui.colorSigTFs = !this.theDREMGui.colorSigTFs;
            int n = this.theDREMGui.hidesigList.size();
            for (int i = 0; i < n; ++i) {
                DREMGui.SigInfoRec sigInfoRec = this.theDREMGui.hidesigList.get(i);
                sigInfoRec.border.removeAllChildren();
                this.theDREMGui.setSigText(sigInfoRec.theSigTF, (PPath)sigInfoRec.border, sigInfoRec.ntype, sigInfoRec.ndepth, this.displayTF, this.displayMIRNA, sigInfoRec.node, this.theDREMGui.colorSigTFs);
            }
        } else if (string.equals("hide")) {
            int n = this.theDREMGui.hidesigList.size();
            if (this.theDREMGui.bshowkeyinputs) {
                this.hideButton.setText("Show Key Reg Labels");
                this.theDREMGui.bshowkeyinputs = false;
                for (int i = 0; i < n; ++i) {
                    DREMGui.SigInfoRec sigInfoRec = this.theDREMGui.hidesigList.get(i);
                    PPath pPath = (PPath)sigInfoRec.border;
                    pPath.setVisible(false);
                    pPath.setPickable(false);
                    for (Object e : pPath.getChildrenReference()) {
                        PNode pNode = (PNode)e;
                        pNode.setVisible(false);
                        for (Object e2 : pNode.getChildrenReference()) {
                            PNode pNode2 = (PNode)e2;
                            pNode2.setVisible(false);
                        }
                    }
                }
            } else {
                this.hideButton.setText("Hide Key Reg Labels");
                this.theDREMGui.bshowkeyinputs = true;
                for (int i = 0; i < n; ++i) {
                    DREMGui.SigInfoRec sigInfoRec = this.theDREMGui.hidesigList.get(i);
                    PPath pPath = (PPath)sigInfoRec.border;
                    pPath.setVisible(true);
                    pPath.setPickable(true);
                    if (pPath.getWidth() == 0.0) continue;
                    for (Object e : pPath.getChildrenReference()) {
                        PNode pNode = (PNode)e;
                        pNode.setVisible(true);
                        for (Object e3 : pNode.getChildrenReference()) {
                            PNode pNode3 = (PNode)e3;
                            pNode3.setVisible(true);
                        }
                    }
                }
            }
            this.theFrame.pack();
        }
    }
}

