/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.MultiLineHeaderRenderer;
import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui;
import edu.cmu.cs.sb.drem.DREMGui_GOGeneTable;
import edu.cmu.cs.sb.drem.DREM_DataSet;
import edu.cmu.cs.sb.drem.DREM_IO;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class DREMGui_GOTable
extends JPanel
implements ActionListener {
    JFrame theFrame;
    DREM_DataSet theDataSet;
    GoAnnotations.GoResults tgr;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    JButton saveButton;
    JButton copyButton;
    String[][] tabledata = null;
    String[] columnNames = null;
    double[] dweightA;
    boolean[] include;
    boolean bjustgo;
    TableSorter sorter;
    String szTitle;
    DREMGui theDREMGui;

    public DREMGui_GOTable(final DREMGui dREMGui, JFrame jFrame, DREM_DataSet dREM_DataSet, double[][] dArray, int[][] nArray, double[][] dArray2, int[][] nArray2, String[] stringArray, final boolean[] blArray) {
        int n;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        this.theFrame = jFrame;
        this.theDataSet = dREM_DataSet;
        this.theDREMGui = dREMGui;
        this.include = blArray;
        this.dweightA = new double[blArray.length];
        for (n = 0; n < this.dweightA.length; ++n) {
            this.dweightA[n] = blArray[n] ? 1.0 : 0.0;
        }
        n = 9;
        this.columnNames = new String[n];
        this.columnNames[0] = "Category ID";
        this.columnNames[1] = "Category Name";
        this.columnNames[2] = "#Genes\nCategory";
        this.columnNames[3] = "#Genes\nAssigned";
        this.columnNames[4] = "#Genes\nExpected";
        this.columnNames[5] = "#Genes\nEnriched";
        this.columnNames[6] = "p-value";
        this.columnNames[7] = "Corrected\np-value";
        this.columnNames[8] = "Fold";
        this.tgr = dREM_DataSet.tga.getCategory(dREM_DataSet.genenames, this.dweightA);
        if (this.tgr.goRecArray.length == 0) {
            JLabel jLabel = new JLabel("  No subset of " + dREM_DataSet.tga.nmingo + " or more genes assigned to this set being analyzed" + " belong to a common GO category at a level " + dREM_DataSet.tga.nmingolevel + " or below in the GO hierarchy.");
            jLabel.setPreferredSize(new Dimension(800, 30));
            this.add(jLabel);
        } else {
            this.tabledata = new String[this.tgr.goRecArray.length][this.columnNames.length];
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat.setMinimumFractionDigits(3);
            numberFormat.setMaximumFractionDigits(3);
            NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat2.setMinimumFractionDigits(1);
            numberFormat2.setMaximumFractionDigits(1);
            numberFormat2.setGroupingUsed(false);
            for (int i = 0; i < this.tgr.goRecArray.length; ++i) {
                this.tabledata[i][0] = this.tgr.goRecArray[i].szgoid;
                this.tabledata[i][1] = this.tgr.goRecArray[i].szgocategory;
                this.tabledata[i][6] = Util.doubleToSz(this.tgr.goRecArray[i].dpvalue);
                this.tabledata[i][7] = this.tgr.goRecArray[i].dcorrectedpvalue < 0.001 ? (dREM_DataSet.tga.brandomgoval ? "<0.001" : Util.doubleToSz(this.tgr.goRecArray[i].dcorrectedpvalue)) : numberFormat.format(this.tgr.goRecArray[i].dcorrectedpvalue);
                this.tabledata[i][2] = "" + (int)this.tgr.goRecArray[i].dcategoryall;
                this.tabledata[i][3] = numberFormat2.format(this.tgr.goRecArray[i].dcategoryselect);
                double d = this.tgr.dselect * this.tgr.goRecArray[i].dcategoryall / this.tgr.dall;
                this.tabledata[i][4] = numberFormat2.format(d);
                double d2 = this.tgr.goRecArray[i].dcategoryselect - d;
                this.tabledata[i][5] = numberFormat2.format(d2);
                double d3 = Double.parseDouble(this.tabledata[i][5]);
                if (d3 > 0.0) {
                    this.tabledata[i][5] = "+" + this.tabledata[i][5];
                } else if (d3 == 0.0) {
                    this.tabledata[i][5] = "0.0";
                }
                this.tabledata[i][8] = "" + numberFormat2.format(this.tgr.goRecArray[i].dcategoryselect / d);
            }
            this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
            JTable jTable = new JTable(this.sorter);
            MultiLineHeaderRenderer multiLineHeaderRenderer = new MultiLineHeaderRenderer(this.sorter);
            Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().setHeaderRenderer(multiLineHeaderRenderer);
            }
            this.sorter.setTableHeader(jTable.getTableHeader());
            jTable.setPreferredScrollableViewportSize(new Dimension(800, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 400)));
            TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(30);
            tableColumn = jTable.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(200);
            tableColumn = jTable.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(20);
            tableColumn = jTable.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(20);
            tableColumn = jTable.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(20);
            tableColumn = jTable.getColumnModel().getColumn(5);
            tableColumn.setPreferredWidth(20);
            tableColumn = jTable.getColumnModel().getColumn(6);
            tableColumn.setPreferredWidth(20);
            tableColumn = jTable.getColumnModel().getColumn(7);
            tableColumn.setPreferredWidth(20);
            tableColumn = jTable.getColumnModel().getColumn(8);
            tableColumn.setPreferredWidth(20);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            this.add(jScrollPane);
            this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
            this.copyButton.setActionCommand("copy");
            this.copyButton.setMinimumSize(new Dimension(800, 20));
            this.copyButton.addActionListener(this);
            this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
            this.saveButton.setActionCommand("save");
            this.saveButton.setMinimumSize(new Dimension(800, 20));
            this.saveButton.addActionListener(this);
            jTable.setSelectionMode(0);
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            final DREM_DataSet dREM_DataSet2 = dREM_DataSet;
            final String[] stringArray2 = stringArray;
            final double[][] dArray3 = dArray;
            final int[][] nArray3 = nArray;
            final double[][] dArray4 = dArray2;
            final int[][] nArray4 = nArray2;
            final TableSorter tableSorter = this.sorter;
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    final ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            int n = listSelectionModel.getMinSelectionIndex();
                            String string = tableSorter.getValueAt(n, 0) + " (" + tableSorter.getValueAt(n, 1) + ")";
                            String string2 = "Gene List for " + string;
                            JFrame jFrame = new JFrame(string2);
                            jFrame.setDefaultCloseOperation(2);
                            DREMGui_GOGeneTable dREMGui_GOGeneTable = new DREMGui_GOGeneTable(dREMGui, jFrame, dREM_DataSet2, dREMGui.theTimeiohmm, dArray3, nArray3, dArray4, nArray4, stringArray2, (String)tableSorter.getValueAt(n, 0), blArray);
                            dREMGui_GOGeneTable.setOpaque(true);
                            jFrame.setContentPane(dREMGui_GOGeneTable);
                            jFrame.setLocation(40, 150);
                            jFrame.pack();
                            jFrame.setVisible(true);
                        }
                    });
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            jPanel.add(this.copyButton);
            jPanel.add(this.saveButton);
            JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
            jButton.addActionListener(this);
            jButton.setActionCommand("help");
            jPanel.add(jButton);
            jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
            this.add(jPanel);
        }
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        for (n = 0; n < this.columnNames.length; ++n) {
            String string = this.columnNames[n];
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    printWriter.print(" ");
                    continue;
                }
                printWriter.print(c);
            }
            if (n >= this.columnNames.length - 1) continue;
            printWriter.print("\t");
        }
        printWriter.println();
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.tabledata[n][i] + "\t");
            }
            printWriter.println(this.tabledata[n][this.tabledata[n].length - 1]);
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length; ++n) {
            String string = this.columnNames[n];
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    stringBuffer.append(" ");
                    continue;
                }
                stringBuffer.append(c);
            }
            if (n >= this.columnNames.length - 1) continue;
            stringBuffer.append("\t");
        }
        stringBuffer.append("\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.tabledata[n][i] + "\t");
            }
            stringBuffer.append(this.tabledata[n][this.tabledata[n].length - 1] + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.writeToClipboard();
        }
        if (string.equals("save")) {
            try {
                int n = DREM_IO.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = DREM_IO.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    this.printFile(printWriter);
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = "The table contains a Gene Ontology (GO) enrichment analysis for the set of currently displayed genes ";
            string2 = string2 + " as compared to what would be expected if the same number of genes as assigned to this set were randomly selected among the entire set of unique genes on the microarray.\n";
            string2 = string2 + "\nThe table has nine columns:\n1.  Category ID - the ID for the category\n2.  Category Name - the name for the category \n3.  #Genes Category - the number of genes on the array annotated as belonging to this GO category\n4.  #Genes Assigned - the number of genes of this GO category that were assigned to this set\n5.  #Genes Expected - the number of genes of this GO category expected to be assigned to this set of genes.  This is computed as (#Genes_In_Set)*(#Genes_Category)/(#Total_Unique_Genes_on_Array).\nFor this set  #Genes_In_Set = " + this.tgr.dselect + " and " + "for the data  #Total_Unique_Genes_on_Array=" + (int)this.tgr.dall + ".\n" + "6.  #Genes Enriched - The difference between the #Genes Assigned and the " + "#Genes Expected\n" + "7.  p-value - the uncorrected probability of seeing greater than " + "#Genes_Assigned assigned to this set from this GO category than " + "were observed by random chance.  " + "This is computed based on the Hypergeometric distribution where the number of items " + "being drawn is #Genes_In_Set items with #Genes_Category \"success items\", " + "and (#Total_Unique_Genes_on_Array\u2212#Genes_Category) \"failure items.\"\n" + "8.  Corrected p-value - the p-value corrected for multiple " + "GO categories being tested simultaneously.  " + "This can be based on either a randomization test or a Bonferroni correction " + "depending upon which is selected as 'Multiple hypothesis correction method for actual " + "size based enrichment' under 'GO Analysis' on the 'Advanced Options' menu.\n" + "9. Fold - fold enrichment that is the number of genes assigned divided by expected\n\n" + "Note:\n" + "+Clicking on a row of the table displays the list of genes in " + "the set being analyzed that are by of the GO category of the row clicked.\n" + "+The table can be sorted by any of the columns by clicking on the desired " + " column's header.\n" + "+Using the 'Save Table' button the entire table can be saved.\n";
            Util.renderDialog(this.theFrame, string2);
        }
    }
}

