/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui;
import edu.cmu.cs.sb.drem.DREMGui_GOFilter;
import edu.cmu.cs.sb.drem.DREMGui_StaticSummaryTable;
import edu.cmu.cs.sb.drem.DREM_DataSet;
import edu.cmu.cs.sb.drem.DREM_IO;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class DREMGui_GOGeneTable
extends JPanel
implements ActionListener {
    DREM_DataSet theDataSet;
    String szGoID;
    boolean[] include;
    boolean[] goinclude;
    DREM_Timeiohmm theTimeiohmm;
    Vector<String> columnNames;
    Vector<Vector<String>> tabledata;
    JButton staticButton;
    JButton saveButton;
    JButton savenamesButton;
    JButton copyButton;
    JButton copynamesButton;
    JButton selectButton;
    JButton unselectButton;
    TableSorter sorter;
    String szTitle;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    JFrame theFrame;
    DREMGui theDREMGui;
    int numgoinclude;
    String[] tfNames;
    double[][] bindingpval;
    int[][] bindingpvalIndex;
    double[][] bindingpvalTF;
    int[][] bindingpvalTFIndex;

    public DREMGui_GOGeneTable(DREMGui dREMGui, JFrame jFrame, DREM_DataSet dREM_DataSet, DREM_Timeiohmm dREM_Timeiohmm, double[][] dArray, int[][] nArray, double[][] dArray2, int[][] nArray2, String[] stringArray, String string, boolean[] blArray) {
        int n;
        int n2;
        this.theFrame = jFrame;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        this.theDataSet = dREM_DataSet;
        this.szGoID = string;
        this.bindingpval = dArray;
        this.bindingpvalIndex = nArray;
        this.bindingpvalTF = dArray2;
        this.bindingpvalTFIndex = nArray2;
        this.tfNames = stringArray;
        this.theDREMGui = dREMGui;
        this.include = blArray;
        this.numgoinclude = 0;
        this.goinclude = new boolean[blArray.length];
        this.theTimeiohmm = dREM_Timeiohmm;
        this.columnNames = new Vector();
        this.columnNames.add(dREM_DataSet.szGeneHeader);
        this.columnNames.add(dREM_DataSet.szProbeHeader);
        for (n2 = 0; n2 < dREM_DataSet.numcols; ++n2) {
            this.columnNames.add("" + dREM_DataSet.dsamplemins[n2]);
        }
        n2 = dREM_DataSet.numcols + 2;
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnNames.add(stringArray[i]);
        }
        this.tabledata = new Vector();
        this.loadTable();
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(800, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 300)));
        jTable.setAutoResizeMode(0);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(150);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        for (n = 0; n < dREM_DataSet.numcols; ++n) {
            tableColumn = jTable.getColumnModel().getColumn(n + 2);
            tableColumn.setPreferredWidth(45);
        }
        for (n = 0; n < stringArray.length; ++n) {
            tableColumn = jTable.getColumnModel().getColumn(n + n2);
            tableColumn.setPreferredWidth(45);
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        this.add(jScrollPane);
        this.copynamesButton = new JButton("Copy Gene Names", Util.createImageIcon("Copy16.gif"));
        this.copynamesButton.setActionCommand("copynames");
        this.copynamesButton.setMinimumSize(new Dimension(800, 20));
        this.copynamesButton.addActionListener(this);
        this.savenamesButton = new JButton("Save Gene Names", Util.createImageIcon("Save16.gif"));
        this.savenamesButton.setActionCommand("savenames");
        this.savenamesButton.setMinimumSize(new Dimension(800, 20));
        this.savenamesButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.copyButton);
        jPanel.add(this.saveButton);
        jPanel.setBackground(Color.white);
        jPanel.add(this.copynamesButton);
        jPanel.add(this.savenamesButton);
        this.staticButton = new JButton("TF Summary");
        this.staticButton.setActionCommand("staticsummary");
        this.staticButton.setMinimumSize(new Dimension(800, 20));
        this.staticButton.addActionListener(this);
        jPanel.add(this.staticButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel.add(jButton);
        this.selectButton = new JButton("Select by this GO category");
        this.selectButton.setActionCommand("select");
        this.selectButton.setMinimumSize(new Dimension(800, 20));
        this.selectButton.addActionListener(this);
        this.unselectButton = new JButton("Unapply GO Selection Constraints");
        this.unselectButton.setActionCommand("unselect");
        this.unselectButton.setMinimumSize(new Dimension(800, 20));
        this.unselectButton.setEnabled(false);
        this.unselectButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.selectButton);
        jPanel2.setBackground(Color.white);
        jPanel2.add(this.unselectButton);
        this.add(jPanel);
        this.add(jPanel2);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        int n2 = this.columnNames.size() - 1;
        for (n = 0; n < n2; ++n) {
            printWriter.print(this.columnNames.get(n) + "\t");
        }
        printWriter.println(this.columnNames.get(n2));
        for (n = 0; n < this.tabledata.size(); ++n) {
            for (int i = 0; i < n2; ++i) {
                printWriter.print(this.sorter.getValueAt(n, i) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n, n2));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.columnNames.size() - 1;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.columnNames.get(n) + "\t");
        }
        stringBuffer.append(this.columnNames.get(n2) + "\n");
        for (n = 0; n < this.tabledata.size(); ++n) {
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, n2) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void printGeneNames(PrintWriter printWriter) {
        int n = this.tabledata.size();
        for (int i = 0; i < n; ++i) {
            printWriter.println(this.sorter.getValueAt(i, 0));
        }
    }

    public void writenamesToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.tabledata.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.sorter.getValueAt(i, 0) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    private void loadTable() {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        for (int i = 0; i < this.include.length; ++i) {
            int n;
            if (!this.include[i]) continue;
            Vector<String> vector = new Vector<String>(2);
            HashSet hashSet = this.theDataSet.tga.labelsForID(this.theDataSet.genenames[i]);
            if (hashSet.size() < 1 || !hashSet.contains(this.szGoID)) continue;
            this.goinclude[i] = true;
            ++this.numgoinclude;
            vector.add(this.theDataSet.genenames[i]);
            vector.add(this.theDataSet.probenames[i]);
            for (n = 0; n < this.theDataSet.numcols; ++n) {
                if (this.theDataSet.pmavalues[i][n] == 0) {
                    vector.add("");
                    continue;
                }
                vector.add(numberFormat.format(this.theDataSet.data[i][n]));
            }
            n = 0;
            for (int j = 0; j < this.tfNames.length; ++j) {
                while (n < this.bindingpvalIndex[i].length && this.bindingpvalIndex[i][n] < j) {
                    ++n;
                }
                if (n < this.bindingpvalIndex[i].length && j == this.bindingpvalIndex[i][n]) {
                    vector.add("" + (int)this.bindingpval[i][n]);
                    continue;
                }
                vector.add("0");
            }
            this.tabledata.add(vector);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("copynames")) {
            this.writenamesToClipboard();
        } else if (string.equals("staticsummary")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = "Static Summary";
                    JFrame jFrame = new JFrame(string);
                    jFrame.setDefaultCloseOperation(2);
                    jFrame.setLocation(40, 80);
                    DREMGui_StaticSummaryTable dREMGui_StaticSummaryTable = new DREMGui_StaticSummaryTable(DREMGui_GOGeneTable.this.theFrame, DREMGui_GOGeneTable.this.theDataSet, DREMGui_GOGeneTable.this.theTimeiohmm, DREMGui_GOGeneTable.this.bindingpvalTF, DREMGui_GOGeneTable.this.bindingpvalTFIndex, DREMGui_GOGeneTable.this.tfNames, DREMGui_GOGeneTable.this.goinclude, DREMGui_GOGeneTable.this.numgoinclude);
                    dREMGui_StaticSummaryTable.setOpaque(true);
                    jFrame.setContentPane(dREMGui_StaticSummaryTable);
                    jFrame.pack();
                    jFrame.setVisible(true);
                }
            });
        } else if (string.equals("save") || string.equals("savenames")) {
            try {
                int n = DREM_IO.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = DREM_IO.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    if (string.equals("save")) {
                        this.printFile(printWriter);
                    } else {
                        this.printGeneNames(printWriter);
                    }
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("select")) {
            this.theDREMGui.selectGO(this.szGoID);
            this.unselectButton.setEnabled(true);
            if (this.theDREMGui.filterGOFrame != null) {
                ((DREMGui_GOFilter)this.theDREMGui.filterGOFrame.getContentPane()).rowSM.clearSelection();
            }
        } else if (string.equals("unselect")) {
            this.unselectButton.setEnabled(false);
            this.theDREMGui.unselectGO();
        } else if (string.equals("help")) {
            String string2 = "The table contains genes assigned to the selected genes and GO Category ";
            String string3 = "";
            if (this.theDataSet.btakelog) {
                string3 = "log base two ";
            }
            string2 = string2 + ".\n\n The first two columns of the table are: \n";
            string2 = string2 + "*  " + this.theDataSet.szGeneHeader + " - The name of the gene.\n" + "*  " + this.theDataSet.szProbeHeader + " - The spot ID(s) associated with the gene.\n\n";
            if (this.columnNames.size() == 3) {
                string2 = string2 + "The remaining column contains the " + string3 + "expression change relative to the first time point.\n\n";
            }
            string2 = string2 + "Note:\n+The table can be sorted by any of the columns by clicking on the column's header.\n+Using the 'Save Table' button the entire table can be saved, or just the gene names with the 'Save Gene Names' button.";
            Util.renderDialog(this.theFrame, string2);
        }
    }
}

