/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.StatUtil;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui;
import edu.cmu.cs.sb.drem.DREMGui_FilterStaticModel;
import edu.cmu.cs.sb.drem.DREMGui_KeyInputs;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;

public class DREMGui_FilterStatic
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener {
    static final Color bgColor = Color.white;
    static final Color fgColor = Color.black;
    boolean bnegate = true;
    JFrame theFrame;
    JButton colorButton;
    JRadioButton intersectButton;
    JRadioButton unionButton;
    double[] tfVals;
    DREMGui_FilterStaticModel hmst;
    TableSorter sorter;
    DREM_Timeiohmm theTimeiohmm;
    DREMGui theDREMGui;
    int numrows;
    int numcols;
    JButton unapplyButton;
    JButton hideButton;
    boolean bsplitgolabels = true;
    JSlider theSlider;
    Hashtable theDictionary;
    JLabel pvalLabel;
    int ninitval = 30;
    JRadioButton pathButton;
    JRadioButton splitButton;
    ButtonGroup enrichmentGroup = new ButtonGroup();
    double dsetpval;
    GoAnnotations tga;
    boolean bapplyset = false;
    boolean boveralltfeligible;
    int noveralltfrow;
    int noveralltfcol;
    DREM_Timeiohmm.Treenode rootptr;
    JCheckBox complementcheck = new JCheckBox("Use Complement of Above Criteria", false);

    public DREMGui_FilterStatic(JFrame jFrame, DREMGui dREMGui, GoAnnotations goAnnotations, DREM_Timeiohmm.Treenode treenode) {
        int n;
        this.theFrame = jFrame;
        this.theDREMGui = dREMGui;
        this.tga = goAnnotations;
        this.theTimeiohmm = dREMGui.theTimeiohmm;
        this.rootptr = treenode;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        this.numcols = this.theTimeiohmm.bindingData.existingBindingValuesUnsorted.size() + 1;
        this.tfVals = this.theTimeiohmm.bindingData.existingBindingValuesSorted;
        this.numrows = this.theTimeiohmm.bindingData.regNames.length;
        Object[][] objectArray = new Object[this.numrows][this.numcols];
        String[] stringArray = new String[this.numcols];
        stringArray[0] = "Transcription Factor";
        for (n = 1; n < this.numcols; ++n) {
            stringArray[n] = "" + this.tfVals[n - 1];
        }
        for (n = 0; n < this.numrows; ++n) {
            objectArray[n][0] = this.theTimeiohmm.bindingData.regNames[n];
            for (int i = 1; i < this.numcols; ++i) {
                objectArray[n][i] = false;
            }
        }
        this.hmst = new DREMGui_FilterStaticModel(objectArray, stringArray);
        this.sorter = new TableSorter(this.hmst);
        JTable jTable = new JTable(this.sorter);
        this.sorter.setTableHeader(jTable.getTableHeader());
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(125);
        for (int i = 1; i < this.numcols; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(50);
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(425, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 200)));
        this.add(jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        this.unionButton = new JRadioButton("at least one TF");
        this.unionButton.setBackground(Color.white);
        this.intersectButton = new JRadioButton("all TFs");
        this.intersectButton.setBackground(Color.white);
        this.unionButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.intersectButton);
        buttonGroup.add(this.unionButton);
        jPanel.add(new JLabel("Genes selected must meet constraints for"));
        jPanel.add(this.intersectButton);
        jPanel.add(this.unionButton);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 12));
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.complementcheck);
        jPanel2.setBackground(Color.white);
        this.complementcheck.setBackground(Color.white);
        jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 12));
        this.add(jPanel2);
        JLabel jLabel = new JLabel("  Only display enrichments with a score less than 10^-X where X is:");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jLabel);
        jPanel3.setBackground(new Color(0.0f, 1.0f, 0.0f, 0.4f));
        jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel3);
        this.pvalLabel = new JLabel("X = " + (double)this.ninitval / 10.0 + "; score threshold is " + DREMGui_KeyInputs.doubleToSz(Math.pow(10.0, (double)(-this.ninitval) / 10.0)));
        this.dsetpval = Math.pow(10.0, (double)(-this.ninitval) / 10.0);
        this.theSlider = new JSlider(0, 120, this.ninitval);
        this.theDictionary = new Hashtable();
        for (int i = 0; i <= 12; ++i) {
            this.theDictionary.put(new Integer(i * 10), new JLabel("" + i));
        }
        this.theSlider.setLabelTable(this.theDictionary);
        this.theSlider.setMajorTickSpacing(10);
        this.theSlider.setMinorTickSpacing(5);
        this.theSlider.setPaintTicks(true);
        this.theSlider.setPaintLabels(true);
        this.theSlider.addChangeListener(this);
        this.theSlider.setPaintTicks(true);
        this.add(this.theSlider);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.pvalLabel);
        jPanel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel4);
        jPanel4.setBackground(Color.white);
        JPanel jPanel5 = new JPanel();
        JLabel jLabel2 = new JLabel("Score should be");
        jPanel5.setBackground(Color.white);
        jPanel5.add(jLabel2);
        this.pathButton = new JRadioButton("Overall Enrichments");
        this.splitButton = new JRadioButton("Split Enrichments");
        this.enrichmentGroup.add(this.pathButton);
        this.enrichmentGroup.add(this.splitButton);
        this.pathButton.addItemListener(this);
        this.splitButton.addItemListener(this);
        if (this.bsplitgolabels) {
            this.splitButton.setSelected(true);
        } else {
            this.pathButton.setSelected(true);
        }
        this.pathButton.setBackground(Color.white);
        this.splitButton.setBackground(Color.white);
        jPanel5.add(this.pathButton);
        jPanel5.add(this.splitButton);
        this.add(jPanel5);
        jPanel5.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(Color.white);
        this.hideButton = new JButton("Hide Labels");
        this.hideButton.setEnabled(false);
        this.hideButton.setActionCommand("hide");
        this.hideButton.addActionListener(this);
        jPanel6.add(this.hideButton);
        this.colorButton = new JButton("Change Labels Color");
        this.colorButton.setActionCommand("color");
        this.colorButton.setMinimumSize(new Dimension(800, 20));
        this.colorButton.addActionListener(this);
        this.colorButton.setForeground(dREMGui.tfLabelColor);
        jPanel6.add(this.colorButton);
        JButton jButton = new JButton("Unselect All");
        jButton.setActionCommand("selectnone");
        jButton.addActionListener(this);
        jPanel6.add(jButton);
        JButton jButton2 = new JButton("Select All");
        jButton2.setActionCommand("selectall");
        jButton2.addActionListener(this);
        jPanel6.add(jButton2);
        jPanel6.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBackground(Color.white);
        JButton jButton3 = new JButton("Apply Selection Constraints");
        jButton3.setActionCommand("applyselect");
        jButton3.addActionListener(this);
        jPanel7.add(jButton3);
        jPanel7.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel7);
        this.unapplyButton = new JButton("Unapply Selection Constraints");
        this.unapplyButton.setActionCommand("unapply");
        this.unapplyButton.addActionListener(this);
        this.unapplyButton.setEnabled(false);
        jPanel7.add(this.unapplyButton);
        JButton jButton4 = new JButton(Util.createImageIcon("Help16.gif"));
        jButton4.addActionListener(this);
        jButton4.setActionCommand("help");
        jPanel7.add(jButton4);
        jPanel7.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel7);
        jPanel6.setBackground(Color.white);
    }

    void setAll(boolean bl) {
        for (int i = 0; i < this.numrows; ++i) {
            for (int j = 1; j < this.numcols; ++j) {
                this.hmst.setValueAt(bl, i, j);
            }
        }
    }

    void setTFSetLabelTextVisible(DREM_Timeiohmm.Treenode treenode, boolean bl) {
        if (treenode != null) {
            treenode.tfsetText.setVisible(bl);
            for (int i = 0; i < treenode.numchildren; ++i) {
                this.setTFSetLabelTextVisible(treenode.nextptr[i], bl);
            }
        }
    }

    void setTFSetLabelTextColor(DREM_Timeiohmm.Treenode treenode, Color color) {
        if (treenode != null) {
            treenode.tfsetText.setTextPaint(color);
            for (int i = 0; i < treenode.numchildren; ++i) {
                this.setTFSetLabelTextColor(treenode.nextptr[i], color);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        boolean bl = false;
        if (string.equals("color")) {
            Color color = JColorChooser.showDialog(this, "Choose Color", this.theDREMGui.tfLabelColor);
            if (color != null) {
                this.theDREMGui.tfLabelColor = color;
                this.colorButton.setForeground(color);
                this.setTFSetLabelTextColor(this.rootptr, color);
            }
        } else if (string.equals("hide")) {
            if (this.theDREMGui.bshowtfsetlabels) {
                this.theDREMGui.bshowtfsetlabels = false;
                this.hideButton.setText("Show Labels");
                this.setTFSetLabelTextVisible(this.rootptr, false);
            } else {
                this.theDREMGui.bshowtfsetlabels = true;
                this.hideButton.setText("Hide Labels");
                this.setTFSetLabelTextVisible(this.rootptr, true);
            }
        } else if (string.equals("unapply")) {
            this.unapplyButton.setEnabled(false);
            for (int i = 0; i < this.theTimeiohmm.bindingData.gene2RegMaxBinding.length; ++i) {
                this.theDREMGui.bTFVisible[i] = true;
                boolean bl2 = this.theDREMGui.bglobalVisible && this.theDREMGui.bPathVisible[i] && this.theDREMGui.bGOVisible[i] && this.theDREMGui.bSetVisible[i];
                this.theDREMGui.plArray[i].setVisible(bl2);
                this.theDREMGui.plArray[i].setPickable(bl2);
            }
            this.theDREMGui.bfilterinput = false;
            this.theDREMGui.setFilterText();
            if (this.theDREMGui.theGOFilter != null) {
                this.theDREMGui.theGOFilter.addGOLabels(this.rootptr);
            }
            this.setTFSetLabelTextVisible(this.rootptr, false);
            this.theDREMGui.bapplytfsetlabels = false;
            this.bapplyset = false;
        } else if (string.equals("help")) {
            String string2 = "This dialog box allows the selection of a subset of genes based on being regulated by a common transcription factor (TF) or combination of TFs. For each TF from the 'TF-gene Interactions File', there is a checkbox for the values of '0' and '1'.  If '-1' values are also present in the 'TF-gene Interactions File', then there are also checkboxes for this value. If the option 'Genes selected must meet constraints for' is set to 'all TFs', then only genes which have TF-gene interaction values matching a checked box value for all TFs will be selected. In this case at least one value must be specified for every TF otherwise it is not possible to have a match.  If the option is set to 'at least one TF', then any gene with a predicted TF-gene regulation interaction that matches a checked box for at least one TF will be selected.  If the option 'Use Complement of Above Criteria' is selected the complement of the set of genes described by the above criteria will be selected.  To actually apply changes made to the checkboxes the button 'Apply Selection Constraints' must be pressed.  Pressing the button 'Unapply Selection Constraints' removes selection constraints based on TF-gene regulation interactions.  To have all the checkboxes selected press the button 'Select All', and to have no checkboxes selected press the button 'Unselect All'.\n\nIn addition to selecting genes, when the 'Apply Selection Constraints' button is pressed labels appear when the score for any set of genes is less than the score threshold determined by the setting of the slider under 'Only display enrichments with a score less than 10^{-X} where X is'.  The score can be based on 'Split Enrichments' or 'Overall Enrichments' for genes regulated by the selected TF regulation constraints.  Split enrichments are computed based on the hypergeometric distribution where the base set of genes are all genes going into the prior split on the path.  The base set of genes for 'Overall Enrichments' is all genes included in the expression data file or the 'Pre-filtered Gene File'.  Overall enrichments are currently only supported when selecting by a single TF.  Labels appear to the immediate right of the first node on the path out of the split.  The label contains the number of genes and then the score separated by a semi-colon.  To hide labels press the 'Hide Labels' button.  When the labels are hidden the button now reads 'Show Labels', and pressing it reverts the labels to being shown again.  The color of labels can be changed through the 'Change Labels Color' button.  The color of the TF labels will match that of the color of the text of this 'Change Labels Color' button.";
            Util.renderDialog(this.theFrame, string2, -200, -100);
        } else if (string.equals("applyselect")) {
            int n;
            int n2;
            this.bnegate = this.complementcheck.isSelected();
            this.theDREMGui.bapplytfsetlabels = true;
            this.unapplyButton.setEnabled(true);
            HashSet[] hashSetArray = new HashSet[this.numrows];
            this.boveralltfeligible = !this.bnegate;
            this.noveralltfrow = -1;
            for (n2 = 0; n2 < this.numrows; ++n2) {
                hashSetArray[n2] = new HashSet();
                for (n = 1; n < this.numcols; ++n) {
                    if (!((Boolean)this.hmst.getValueAt(n2, n)).booleanValue()) continue;
                    hashSetArray[n2].add(new Double(this.tfVals[n - 1]));
                    if (this.noveralltfrow == -1) {
                        this.noveralltfrow = n2;
                        this.noveralltfcol = n - 1;
                        continue;
                    }
                    this.boveralltfeligible = false;
                }
                this.theDREMGui.bfilterinput = true;
                this.theDREMGui.setFilterText();
            }
            n2 = this.intersectButton.isSelected() ? 1 : 0;
            if (n2 != 0) {
                this.boveralltfeligible = false;
                for (n = 0; n < this.theTimeiohmm.bindingData.gene2RegMaxBinding.length; ++n) {
                    int n3;
                    boolean bl3 = true;
                    int n4 = 0;
                    while (n4 < this.numrows && bl3) {
                        n3 = Arrays.binarySearch(this.theTimeiohmm.bindingData.gene2RegMaxBindingIndex[n], n4);
                        double d = n3 < 0 ? 0.0 : this.theTimeiohmm.bindingData.gene2RegMaxBinding[n][n3];
                        if (!hashSetArray[n4].contains(new Double(d))) {
                            bl3 = false;
                            continue;
                        }
                        ++n4;
                    }
                    if (this.bnegate) {
                        boolean bl4 = bl3 = !bl3;
                    }
                    if (!bl3) {
                        this.theDREMGui.bTFVisible[n] = false;
                        this.theDREMGui.plArray[n].setVisible(false);
                        this.theDREMGui.plArray[n].setPickable(false);
                        continue;
                    }
                    this.theDREMGui.bTFVisible[n] = true;
                    n3 = this.theDREMGui.bglobalVisible && this.theDREMGui.bPathVisible[n] && this.theDREMGui.bSetVisible[n] && this.theDREMGui.bGOVisible[n] ? 1 : 0;
                    this.theDREMGui.plArray[n].setVisible(n3 != 0);
                    this.theDREMGui.plArray[n].setPickable(n3 != 0);
                }
            } else {
                for (n = 0; n < this.theTimeiohmm.bindingData.gene2RegMaxBinding.length; ++n) {
                    int n5;
                    boolean bl5 = false;
                    int n6 = 0;
                    while (n6 < this.numrows && !bl5) {
                        n5 = Arrays.binarySearch(this.theTimeiohmm.bindingData.gene2RegMaxBindingIndex[n], n6);
                        double d = n5 < 0 ? 0.0 : this.theTimeiohmm.bindingData.gene2RegMaxBinding[n][n5];
                        if (hashSetArray[n6].contains(new Double(d))) {
                            bl5 = true;
                            continue;
                        }
                        ++n6;
                    }
                    if (this.bnegate) {
                        boolean bl6 = bl5 = !bl5;
                    }
                    if (!bl5) {
                        this.theDREMGui.bTFVisible[n] = false;
                        this.theDREMGui.plArray[n].setVisible(false);
                        this.theDREMGui.plArray[n].setPickable(false);
                        continue;
                    }
                    this.theDREMGui.bTFVisible[n] = true;
                    n5 = this.theDREMGui.bglobalVisible && this.theDREMGui.bPathVisible[n] && this.theDREMGui.bSetVisible[n] && this.theDREMGui.bGOVisible[n] ? 1 : 0;
                    this.theDREMGui.plArray[n].setVisible(n5 != 0);
                    this.theDREMGui.plArray[n].setPickable(n5 != 0);
                }
            }
            if (this.theDREMGui.theGOFilter != null) {
                this.theDREMGui.theGOFilter.addGOLabels(this.rootptr);
            }
            this.bapplyset = true;
            this.addSetLabels(this.rootptr);
            this.setTFSetLabelTextVisible(this.rootptr, this.theDREMGui.bshowtfsetlabels && (this.theDREMGui.bglobalnode || !this.theDREMGui.battachlabels));
            this.hideButton.setEnabled(true);
        } else if (string.equals("selectall")) {
            this.setAll(true);
        } else if (string.equals("selectnone")) {
            this.setAll(false);
        }
    }

    public void addSetLabels(DREM_Timeiohmm.Treenode treenode) {
        if (treenode != null && this.bapplyset) {
            int n;
            int n2;
            int n3;
            int n4 = 0;
            int n5 = 0;
            double d = -1.0;
            if (!this.bsplitgolabels) {
                for (n3 = 0; n3 < treenode.bInNode.length; ++n3) {
                    if (!this.theDREMGui.bTFVisible[n3] || !treenode.bInNode[n3]) continue;
                    ++n4;
                }
                n3 = treenode.numPath;
                treenode.sztfsetlabel = this.boveralltfeligible ? ((d = StatUtil.hypergeometrictail(n4 - 1, n2 = this.theTimeiohmm.filteredClassifier.nBaseCount[this.noveralltfrow][this.noveralltfcol], this.theTimeiohmm.ntotalcombined - n2, n = treenode.numPath)) <= this.dsetpval ? n4 + ";" + Util.doubleToSz(d) : "") : (d <= this.dsetpval ? n4 + ";" : "");
            } else if (treenode.parent != null && treenode.parent.numchildren >= 2) {
                n3 = 0;
                n2 = 0;
                for (n = 0; n < treenode.bInNode.length; ++n) {
                    if (!treenode.parent.bInNode[n]) continue;
                    ++n3;
                    if (treenode.bInNode[n]) {
                        ++n2;
                    }
                    if (!this.theDREMGui.bTFVisible[n]) continue;
                    ++n5;
                    if (!treenode.bInNode[n]) continue;
                    ++n4;
                }
                n = n4 - 1;
                d = StatUtil.hypergeometrictail(n, n2, n3 - n2, n5);
                treenode.sztfsetlabel = d <= this.dsetpval ? n4 + ";" + Util.doubleToSz(d) : "";
            } else {
                treenode.sztfsetlabel = "";
            }
            treenode.tfsetText.setText(treenode.sztfsetlabel);
            for (n3 = 0; n3 < treenode.numchildren; ++n3) {
                this.addSetLabels(treenode.nextptr[n3]);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.bsplitgolabels = !this.pathButton.isSelected();
        this.addSetLabels(this.rootptr);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            this.dsetpval = Math.pow(10.0, (double)(-jSlider.getValue()) / 10.0);
            this.pvalLabel.setText("X = " + (double)jSlider.getValue() / 10.0 + "; score threshold is " + DREMGui_KeyInputs.doubleToSz(this.dsetpval));
            this.addSetLabels(this.rootptr);
        }
    }
}

