/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.drem;

import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.TableSorter;
import edu.cmu.cs.sb.core.Util;
import edu.cmu.cs.sb.drem.DREMGui;
import edu.cmu.cs.sb.drem.DREMGui_FilterStaticModel;
import edu.cmu.cs.sb.drem.DREM_IO;
import edu.cmu.cs.sb.drem.DREM_Timeiohmm;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class DREMGui_EdgeTable
extends JPanel
implements ActionListener {
    DREMGui theDREMGui;
    DREM_Timeiohmm theTimeiohmm;
    JFrame theFrame;
    String[] columnNames;
    String[][] tabledata;
    JButton copyButton;
    JButton saveButton;
    JButton colorButton;
    TableSorter sorter;
    static final Color bgColor = Color.white;
    static final Color fgColor = Color.black;
    DREMGui_FilterStaticModel hmst;
    int numrows;
    DREM_Timeiohmm.Treenode ptr;
    BigInteger npathID;
    int nchild;
    int ndepth;
    NumberFormat nf;
    NumberFormat nf2;
    boolean bsplit;
    boolean broot;

    public DREMGui_EdgeTable(DREMGui dREMGui, JFrame jFrame, DREM_Timeiohmm dREM_Timeiohmm, DREM_Timeiohmm.Treenode treenode, BigInteger bigInteger, int n, int n2, int n3, boolean bl) {
        int n4;
        this.theDREMGui = dREMGui;
        this.theFrame = jFrame;
        this.theTimeiohmm = dREM_Timeiohmm;
        this.ptr = treenode;
        this.npathID = bigInteger;
        this.ndepth = n;
        this.nchild = n2;
        this.broot = bl;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        int n5 = dREM_Timeiohmm.bindingData.regNames.length;
        int n6 = dREM_Timeiohmm.bindingData.signedBindingValuesUnsorted.size();
        if (dREM_Timeiohmm.bindingData.signedBindingValuesUnsorted.contains(new Integer(0))) {
            --n6;
        }
        this.numrows = n5 * n6;
        boolean bl2 = this.bsplit = treenode.numchildren >= 2;
        if (this.bsplit) {
            this.columnNames = new String[11];
            n4 = 1;
            this.columnNames[2] = "Num Parent";
            this.columnNames[7] = "Expect Split";
            this.columnNames[8] = "Diff. Split";
            this.columnNames[9] = "Score Split";
            this.columnNames[10] = "% Split";
        } else {
            n4 = 0;
            this.columnNames = new String[6];
        }
        this.tabledata = new String[this.numrows][this.columnNames.length];
        this.columnNames[0] = "TF";
        this.columnNames[1] = "Num Total";
        this.columnNames[2 + n4] = "Num Path";
        this.columnNames[3 + n4] = "Expect Overall";
        this.columnNames[4 + n4] = "Diff. Overall";
        this.columnNames[5 + n4] = "Score Overall";
        this.nf2 = NumberFormat.getInstance(Locale.ENGLISH);
        this.nf2.setMinimumFractionDigits(2);
        this.nf2.setMaximumFractionDigits(2);
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < dREM_Timeiohmm.bindingData.signedBindingValuesSorted.length; ++j) {
                if (dREM_Timeiohmm.bindingData.signedBindingValuesSorted[j] == 0) continue;
                this.tabledata[n7][0] = dREM_Timeiohmm.bindingData.regNames[i] + " " + dREM_Timeiohmm.bindingData.signedBindingValuesSorted[j];
                this.tabledata[n7][1] = "" + dREM_Timeiohmm.filteredClassifier.nBaseCount[i][dREM_Timeiohmm.bindingData.signedBindingValuesSorted[j] + dREM_Timeiohmm.filteredClassifier.noffset];
                this.tabledata[n7][2 + n4] = "" + treenode.ncountvals[i][n2][j];
                this.tabledata[n7][3 + n4] = this.nf2.format(treenode.dexpectEdgeFull[n2][n7]);
                this.tabledata[n7][4 + n4] = this.nf2.format(treenode.ddiffEdgeFull[n2][n7]);
                this.tabledata[n7][5 + n4] = DREMGui_EdgeTable.doubleToSz(treenode.dpvalEdgeFull[n2][n7]);
                if (this.bsplit) {
                    this.tabledata[n7][2] = "" + treenode.ncountTotals[i][j];
                    this.tabledata[n7][7] = this.nf2.format(treenode.dexpectEdgeSplit[n2][n7]);
                    this.tabledata[n7][8] = this.nf2.format(treenode.ddiffEdgeSplit[n2][n7]);
                    this.tabledata[n7][9] = DREMGui_EdgeTable.doubleToSz(treenode.dpvalEdgeSplit[n2][n7]);
                    this.tabledata[n7][10] = treenode.ncountTotals[i][j] == 0 ? "0.00" : "" + this.nf2.format(100.0 * (double)treenode.ncountvals[i][n2][j] / (double)treenode.ncountTotals[i][j]);
                }
                ++n7;
            }
        }
        this.sorter = new TableSorter(new TableModelST(this.tabledata, this.columnNames));
        if (this.columnNames.length == 6 || n3 == 2) {
            this.sorter.setSortingStatus(5 + n4, 1);
        } else {
            this.sorter.setSortingStatus(9, 1);
        }
        JTable jTable = new JTable(this.sorter);
        for (int i = 0; i < this.columnNames.length; ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(100);
        }
        this.sorter.setTableHeader(jTable.getTableHeader());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(750, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 300)));
        this.add(jScrollPane);
        this.addBottom();
    }

    private void addBottom() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        String string = "Total number of genes most likely going through this path is " + this.ptr.nextptr[this.nchild].numPath;
        if (this.bsplit) {
            string = string + " (" + this.nf2.format(100.0 * (double)this.ptr.nextptr[this.nchild].numPath / (double)this.ptr.numPath) + "% of split genes)";
        }
        JLabel jLabel = new JLabel(string);
        jPanel.setBackground(Color.white);
        jPanel.add(jLabel);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
        this.nf = NumberFormat.getInstance(Locale.ENGLISH);
        this.nf.setMinimumFractionDigits(3);
        this.nf.setMaximumFractionDigits(3);
        String string2 = this.broot ? "Path output distribution at " + this.theTimeiohmm.theDataSet.dsamplemins[0] + " is Normal(mu =" + this.nf.format(this.ptr.dmean) + ",sigma = " + this.nf.format(this.ptr.dsigma) + ")" : "Path output distribution at " + this.theTimeiohmm.theDataSet.dsamplemins[this.ptr.ndepth + 1] + " is Normal(mu =" + this.nf.format(this.ptr.nextptr[this.nchild].dmean) + ",sigma = " + this.nf.format(this.ptr.nextptr[this.nchild].dsigma) + ")";
        JLabel jLabel2 = new JLabel(string2);
        jPanel2.setBackground(Color.white);
        jPanel2.add(jLabel2);
        jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel2);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        this.colorButton = new JButton("Change Color");
        this.colorButton.setActionCommand("color");
        this.colorButton.setMinimumSize(new Dimension(800, 20));
        this.colorButton.addActionListener(this);
        Integer n = this.theDREMGui.htLineIDtoColorID.get(this.ndepth + ";" + this.npathID);
        Color color = this.theDREMGui.htColorIDtoColor.get(n);
        this.colorButton.setForeground(color);
        jPanel3.add(this.colorButton);
        jPanel3.add(this.copyButton);
        jPanel3.add(this.saveButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel3.add(jButton);
        jPanel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel3);
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            printWriter.print(this.columnNames[n] + "\t");
        }
        printWriter.println(this.columnNames[this.columnNames.length - 1]);
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.sorter.getValueAt(n, i) + "\t");
            }
            printWriter.println(this.sorter.getValueAt(n, this.columnNames.length - 1));
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length - 1; ++n) {
            stringBuffer.append(this.columnNames[n] + "\t");
        }
        stringBuffer.append(this.columnNames[this.columnNames.length - 1] + "\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.sorter.getValueAt(n, i) + "\t");
            }
            stringBuffer.append(this.sorter.getValueAt(n, this.columnNames.length - 1) + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("color")) {
            Integer n = this.theDREMGui.htLineIDtoColorID.get(this.ndepth + ";" + this.npathID);
            Color color = this.theDREMGui.htColorIDtoColor.get(n);
            Color color2 = JColorChooser.showDialog(this, "Choose Color", color);
            if (color2 != null) {
                this.colorButton.setForeground(color2);
                ArrayList<PPath> arrayList = this.theDREMGui.htColorIDtoLinesList.get(n);
                int n2 = arrayList.size();
                this.theDREMGui.htColorIDtoColor.put(n, color2);
                for (int i = 0; i < n2; ++i) {
                    PPath pPath = arrayList.get(i);
                    if (this.theDREMGui.theSelectedRec.selectedNode != pPath || this.theDREMGui.theSelectedRec.bcircle) {
                        pPath.setStrokePaint(color2);
                        continue;
                    }
                    this.theDREMGui.htColors.put(this.theDREMGui.theSelectedRec.selectedNode, color2);
                }
                ArrayList<PNode> arrayList2 = this.theDREMGui.htColorIDtoCircleList.get(n);
                if (arrayList2 != null) {
                    n2 = arrayList2.size();
                    for (int i = 0; i < n2; ++i) {
                        PNode pNode = arrayList2.get(i);
                        if (this.theDREMGui.theSelectedRec.selectedNode != pNode || !this.theDREMGui.theSelectedRec.bcircle) {
                            pNode.setPaint(color2);
                            continue;
                        }
                        this.theDREMGui.htColors.put(this.theDREMGui.theSelectedRec.selectedNode, color2);
                    }
                }
                this.theDREMGui.setGeneColors();
            }
        } else if (string.equals("save")) {
            try {
                int n = DREM_IO.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = DREM_IO.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    if (string.equals("save")) {
                        this.printFile(printWriter);
                    }
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = "This table gives information about the TFs regulating genes on the selected path.  Consult section 4.13 of the user manual for more details on this table.  ";
            Util.renderDialog(this.theFrame, string2);
        }
    }

    public static String doubleToSz(double d) {
        String string;
        int n = 0;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(3);
        numberFormat.setMaximumFractionDigits(3);
        NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat2.setMinimumFractionDigits(2);
        numberFormat2.setMaximumFractionDigits(2);
        if (d <= 0.0) {
            string = "0.000";
        } else {
            double d2;
            for (d2 = d; d2 < 0.9995 && d2 > 0.0; d2 *= 10.0) {
                --n;
            }
            if (n < -2) {
                d2 = Math.pow(10.0, Math.log(d) / Math.log(10.0) - (double)n);
                string = numberFormat2.format(d2) + "e" + n;
            } else {
                string = numberFormat.format(d);
            }
        }
        return string;
    }
}

