/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.core;

import edu.cmu.cs.sb.core.DataTable;
import edu.cmu.cs.sb.core.SpringUtilities;
import edu.cmu.cs.sb.core.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDialog
extends JDialog
implements ActionListener {
    private JList list;
    public Vector<String> data;
    JButton mainButton;
    JButton removeButton;
    JButton okButton;
    JButton viewButton;
    public JRadioButton allButton;
    public JRadioButton indivButton;
    Color defaultColor;
    JFileChooser fc;
    public static Color buttonColor = new Color(255, 246, 143);
    JFrame frame;
    Color bColor;
    private JButton typeHButton = new JButton(Util.createImageIcon("Help16.gif"));

    public ListDialog(JFrame jFrame, Vector<String> vector, boolean bl, JButton jButton, Color color, Color color2, JFileChooser jFileChooser) {
        super(jFrame, "Repeat Data Files", false);
        this.data = vector;
        this.frame = jFrame;
        this.mainButton = jButton;
        this.bColor = color;
        this.defaultColor = color2;
        this.fc = jFileChooser;
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(new Dimension(145, 28));
        this.okButton.setMaximumSize(new Dimension(145, 28));
        this.removeButton = new JButton("Remove File");
        this.removeButton.setPreferredSize(new Dimension(145, 28));
        this.removeButton.setMaximumSize(new Dimension(145, 28));
        this.removeButton.setActionCommand("remove");
        this.viewButton = new JButton("View Selected File");
        this.viewButton.setPreferredSize(new Dimension(145, 28));
        this.viewButton.setMaximumSize(new Dimension(145, 28));
        this.viewButton.setActionCommand("view");
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(vector.size() > 0);
        this.viewButton.addActionListener(this);
        this.viewButton.setEnabled(vector.size() > 0);
        this.typeHButton.addActionListener(this);
        this.typeHButton.setActionCommand("help");
        final JButton jButton2 = new JButton("Add File", Util.createImageIcon("Open16.gif"));
        jButton2.setActionCommand("add");
        jButton2.addActionListener(this);
        jButton2.setPreferredSize(new Dimension(145, 28));
        jButton2.setMaximumSize(new Dimension(145, 28));
        this.getRootPane().setDefaultButton(jButton2);
        this.list = new JList(vector){

            public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
                int n3;
                if (n == 1 && n2 < 0 && (n3 = this.getFirstVisibleIndex()) != -1) {
                    Rectangle rectangle2 = this.getCellBounds(n3, n3);
                    if (rectangle2.y == rectangle.y && n3 != 0) {
                        Point point = rectangle2.getLocation();
                        --point.y;
                        int n4 = this.locationToIndex(point);
                        Rectangle rectangle3 = this.getCellBounds(n4, n4);
                        if (rectangle3 == null || rectangle3.y >= rectangle2.y) {
                            return 0;
                        }
                        return rectangle3.height;
                    }
                }
                return super.getScrollableUnitIncrement(rectangle, n, n2);
            }
        };
        this.list.setVisibleRowCount(-1);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    jButton2.doClick();
                }
            }
        });
        this.list.setSelectedIndex(0);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(600, 150));
        jScrollPane.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JLabel jLabel = new JLabel("Repeat Data File(s):");
        jLabel.setLabelFor(this.list);
        jPanel.add(jLabel);
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setAlignmentX(0.5f);
        JPanel jPanel2 = new JPanel(new SpringLayout());
        jPanel2.add(jButton2);
        jPanel2.add(this.removeButton);
        jPanel2.add(this.viewButton);
        jPanel2.setBackground(color);
        SpringUtilities.makeCompactGrid(jPanel2, 1, 3, 6, 6, 6, 6);
        JPanel jPanel3 = new JPanel(new SpringLayout());
        jPanel3.add(this.okButton);
        jPanel3.setBackground(color);
        SpringUtilities.makeCompactGrid(jPanel3, 1, 1, 6, 6, 6, 6);
        jPanel.setBackground(color);
        Container container = this.getContentPane();
        BoxLayout boxLayout = new BoxLayout(container, 3);
        container.setLayout(boxLayout);
        container.setBackground(color);
        this.allButton = new JRadioButton("Different time periods");
        this.allButton.setBackground(color);
        this.indivButton = new JRadioButton("The same time period ");
        this.indivButton.setBackground(color);
        if (bl) {
            this.allButton.setSelected(true);
        } else {
            this.indivButton.setSelected(true);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.allButton);
        buttonGroup.add(this.indivButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel("Repeat Data is from:"));
        jPanel4.add(this.allButton);
        jPanel4.add(this.indivButton);
        jPanel4.add(this.typeHButton);
        jPanel4.setBackground(color);
        container.add(jPanel);
        container.add(jPanel4);
        container.add(jPanel2);
        container.add(jPanel3);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            this.setVisible(false);
        } else if (string.equals("view")) {
            Object[] objectArray = this.list.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object == null) continue;
                final JFrame jFrame = this.frame;
                final String string2 = object.toString();
                if (new File(string2).exists()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DataTable dataTable = new DataTable(jFrame, string2, false);
                            JFrame jFrame2 = new JFrame(string2);
                            jFrame2.setDefaultCloseOperation(2);
                            jFrame2.setLocation(20, 50);
                            dataTable.setOpaque(true);
                            jFrame2.setContentPane(dataTable);
                            jFrame2.pack();
                            jFrame2.setVisible(true);
                        }
                    });
                    continue;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(jFrame, "File '" + string2 + "' was not found.", "Error", 0);
                    }
                });
            }
        } else if (string.equals("remove")) {
            Object[] objectArray = this.list.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object == null) continue;
                this.data.remove(object);
            }
            if (this.data.size() < 1) {
                this.removeButton.setEnabled(false);
                this.viewButton.setEnabled(false);
                this.mainButton.setBackground(this.defaultColor);
            } else if (this.list.getSelectedIndex() >= this.data.size()) {
                this.list.setSelectedIndex(this.data.size() - 1);
            }
        } else if (string.equals("add")) {
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                File file = this.fc.getSelectedFile();
                this.data.add(file.getAbsolutePath());
                this.removeButton.setEnabled(true);
                this.viewButton.setEnabled(true);
                this.mainButton.setBackground(buttonColor);
                this.list.setSelectedIndex(this.data.size() - 1);
            }
        } else if (string.equals("help")) {
            String string3 = " Click 'Add File' to select a repeat file to add to the list of repeat files.  To remove a file click on a file from the list and then click 'Remove File'.  To view a file click on the file and then click 'View Selected File'.  Click 'OK' to close the dialog window.\n\nRepeat files need to be in the same format as the original data file with the same genes in the same order.  All gene expression values will be normalized against their expression at first time point will be computed for each data set (repeat(s) and original).\n\nRepeat data can either represent repeat measurements taken on the same samples as the original experiment ('The Same Time Period'), or distinct full repeat experiments from different time periods ('Different Time Periods').  If the repeat data is from different time periods genes will be filtered that do not display a consistent expression profile between repeats (based on a parameter under the advanced options).  Also if the repeat data is from different time periods, then the clustering of model profiles can be adjusted using noise estimates from the repeat experiments (also based on a parameter under the advanced options).\n\nIf the values are from 'The Same Time Period' then each time point value is averaged by the median (in the case of two time points a simple mean is used).  If the values are from 'Different Time Periods' the median of values after normalization is used.\n\n";
            Util.renderDialog(this.frame, string3);
        }
        this.list.updateUI();
    }

    public void updateSettings(Vector<String> vector, boolean bl) {
        if (bl) {
            this.allButton.setSelected(true);
        } else {
            this.indivButton.setSelected(true);
        }
        this.list.setSelectedIndex(0);
        if (vector.size() > 0) {
            this.removeButton.setEnabled(true);
            this.viewButton.setEnabled(true);
            this.mainButton.setBackground(buttonColor);
        } else {
            this.removeButton.setEnabled(false);
            this.viewButton.setEnabled(false);
            this.mainButton.setBackground(this.defaultColor);
        }
        this.data.removeAllElements();
        this.data.addAll(vector);
        this.list.updateUI();
    }
}

