/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.core;

import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.Util;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetCore {
    public String szInputFile;
    public boolean bfullrepeat;
    public String[] otherInputFiles;
    public HashMap<String, String> htFiltered;
    public int nmaxmissing;
    public double dmincorrelation;
    public int numrows;
    public int numcols;
    public double[][] data;
    public int[][] pmavalues;
    public boolean bspotincluded;
    public int[][][] genespottimepma = null;
    public int[][][][] generepeatspottimepma = null;
    public double[][][] genespottimedata = null;
    public double[][][][] generepeatspottimedata = null;
    public boolean btakelog;
    public String[] probenames;
    public String[] genenames;
    public double[] sortedcorrvals = null;
    public String[] dsamplemins;
    public double dthresholdvalue = -1.0;
    public boolean bmaxminval;
    public boolean badd0 = false;
    public String szProbeHeader;
    public String szGeneHeader;

    public DataSetCore() {
    }

    private DataSetCore(String string, double[][][] dArray, double[][][][] dArray2, int[][][] nArray, int[][][][] nArray2, double[][] dArray3, int[][] nArray3, String[] stringArray, String[] stringArray2, double d, boolean bl, boolean bl2, boolean bl3, String[] stringArray3, double[] dArray4, int n, double d2, HashMap<String, String> hashMap, String string2, String string3, boolean bl4, String[] stringArray4, boolean bl5) {
        this.otherInputFiles = stringArray4;
        this.bfullrepeat = bl5;
        this.szInputFile = string;
        this.bmaxminval = bl4;
        this.htFiltered = hashMap;
        this.szProbeHeader = string2;
        this.szGeneHeader = string3;
        this.dmincorrelation = d2;
        this.nmaxmissing = n;
        this.genespottimedata = dArray;
        this.generepeatspottimedata = dArray2;
        this.genespottimepma = nArray;
        this.generepeatspottimepma = nArray2;
        this.data = dArray3;
        this.pmavalues = nArray3;
        this.probenames = stringArray;
        this.genenames = stringArray2;
        this.dthresholdvalue = d;
        this.btakelog = bl;
        this.bspotincluded = bl2;
        this.badd0 = bl3;
        this.numrows = dArray3.length;
        this.numcols = dArray3[0].length;
        this.dsamplemins = stringArray3;
        this.sortedcorrvals = dArray4;
    }

    public DataSetCore(DataSetCore dataSetCore) {
        this.szInputFile = dataSetCore.szInputFile;
        this.bfullrepeat = dataSetCore.bfullrepeat;
        this.otherInputFiles = dataSetCore.otherInputFiles;
        this.htFiltered = dataSetCore.htFiltered;
        this.nmaxmissing = dataSetCore.nmaxmissing;
        this.bmaxminval = dataSetCore.bmaxminval;
        this.dmincorrelation = dataSetCore.dmincorrelation;
        this.numrows = dataSetCore.numrows;
        this.numcols = dataSetCore.numcols;
        this.data = dataSetCore.data;
        this.bspotincluded = dataSetCore.bspotincluded;
        this.genespottimepma = dataSetCore.genespottimepma;
        this.genespottimedata = dataSetCore.genespottimedata;
        this.generepeatspottimepma = dataSetCore.generepeatspottimepma;
        this.generepeatspottimedata = dataSetCore.generepeatspottimedata;
        this.pmavalues = dataSetCore.pmavalues;
        this.btakelog = dataSetCore.btakelog;
        this.dthresholdvalue = dataSetCore.dthresholdvalue;
        this.probenames = dataSetCore.probenames;
        this.genenames = dataSetCore.genenames;
        this.sortedcorrvals = dataSetCore.sortedcorrvals;
        this.dsamplemins = dataSetCore.dsamplemins;
        this.badd0 = dataSetCore.badd0;
        this.szProbeHeader = dataSetCore.szProbeHeader;
        this.szGeneHeader = dataSetCore.szGeneHeader;
    }

    public void addExtraToFilter(GoAnnotations goAnnotations) {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.genenames != null) {
            for (n = 0; n < this.genenames.length; ++n) {
                hashSet.add(this.genenames[n]);
            }
        }
        n = goAnnotations.extragenes.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)goAnnotations.extragenes.get(i);
            if (hashSet.contains(string)) continue;
            String string2 = this.htFiltered.get(string);
            String string3 = (String)goAnnotations.extraprobes.get(i);
            if (string2 == null) {
                this.htFiltered.put(string, string3);
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens() && !bl) {
                if (!string3.equals(stringTokenizer.nextToken())) continue;
                bl = true;
            }
            if (bl) continue;
            this.htFiltered.put(string, string2 + ";" + string3);
        }
    }

    protected void dataSetReader(String string, int n, double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, FileNotFoundException, IllegalArgumentException {
        int n2;
        Object object;
        String string2;
        BufferedReader bufferedReader;
        this.htFiltered = new HashMap();
        if (string.equals("")) {
            throw new IllegalArgumentException("No input file specified!");
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string))));
        }
        catch (IOException iOException) {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        String string3 = bufferedReader.readLine();
        if (string3 == null) {
            throw new IllegalArgumentException("Input File " + string + " is empty!");
        }
        while (string3.equals("")) {
            string3 = bufferedReader.readLine();
            if (string3 != null) continue;
            throw new IllegalArgumentException("Input File " + string + " is empty!");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            object = new StringTokenizer(string2, " \t");
            if (((StringTokenizer)object).countTokens() < 1 && bl2) continue;
            arrayList.add(string2);
        }
        bufferedReader.close();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "\t");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "\t", true);
        this.numcols = stringTokenizer2.countTokens() - stringTokenizer.countTokens();
        if (string3.endsWith("\t")) {
            --this.numcols;
        }
        if (bl2) {
            --this.numcols;
        }
        if (bl4) {
            ++this.numcols;
        }
        this.dsamplemins = new String[Math.max(this.numcols, 1)];
        if (bl2) {
            this.szProbeHeader = stringTokenizer2.nextToken();
            if (!this.szProbeHeader.equals("\t")) {
                if (!stringTokenizer2.hasMoreTokens()) {
                    object = "Missing gene header.";
                    if (this.numcols == -1) {
                        object = (String)object + "\nConsider unchecking 'Spot IDs included in the data file'";
                    }
                    throw new IllegalArgumentException((String)object);
                }
                stringTokenizer2.nextToken();
            } else {
                this.szProbeHeader = "";
            }
        } else {
            this.szProbeHeader = "SPOT";
        }
        this.szGeneHeader = stringTokenizer2.nextToken();
        if (!this.szGeneHeader.equals("\t")) {
            if (stringTokenizer2.hasMoreTokens()) {
                stringTokenizer2.nextToken();
            }
        } else {
            this.szGeneHeader = "";
        }
        if (bl4) {
            this.dsamplemins[0] = "0";
            n2 = 1;
        } else {
            n2 = 0;
        }
        while (n2 < this.numcols) {
            if (!stringTokenizer2.hasMoreTokens()) {
                throw new IllegalArgumentException("Missing a column header");
            }
            String string4 = stringTokenizer2.nextToken();
            if (!string4.equals("\t")) {
                if (stringTokenizer2.hasMoreTokens()) {
                    stringTokenizer2.nextToken();
                }
            } else {
                string4 = "";
            }
            this.dsamplemins[n2] = string4;
            ++n2;
        }
        this.numrows = arrayList.size();
        if (this.numrows == 0) {
            throw new IllegalArgumentException(string + " is empty!");
        }
        this.data = new double[this.numrows][this.numcols];
        this.pmavalues = new int[this.numrows][this.numcols];
        this.probenames = new String[this.numrows];
        this.genenames = new String[this.numrows];
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.numrows; ++i) {
            int n3;
            int n4;
            String string5;
            string2 = (String)arrayList.get(i);
            stringTokenizer = new StringTokenizer(string2, "\t", true);
            if (bl2) {
                string5 = stringTokenizer.nextToken();
                if (string5.equals("\t")) {
                    String string6;
                    if (bl3) {
                        string6 = "Missing a Spot Name in the repeat/comparison set";
                    } else {
                        string6 = "Missing a Spot Name";
                        string6 = string6 + "\nConsider unchecking 'Spot IDs included in the data file'";
                    }
                    throw new IllegalArgumentException(string6);
                }
                if (hashMap.containsKey(string5)) {
                    String string7 = bl3 ? "Spot name " + string5 + " in repeat/comparison is not unique" : "Spot name " + string5 + " is not unique" + "\nConsider unchecking 'Spot IDs included in the data file'";
                    throw new IllegalArgumentException(string7);
                }
                hashMap.put(string5, null);
                this.probenames[i] = string5.trim().toUpperCase(Locale.ENGLISH);
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
            } else {
                this.probenames[i] = "ID_" + i;
            }
            if (!stringTokenizer.hasMoreTokens()) {
                this.genenames[i] = "0 (SPOT_" + this.probenames[i] + ")";
                for (n4 = 0; n4 < this.numcols; ++n4) {
                    this.data[i][n4] = 0.0;
                    this.pmavalues[i][n4] = 0;
                }
                continue;
            }
            string5 = stringTokenizer.nextToken();
            if (string5.equals("\t") || string5.equals("0")) {
                if (string5.equals("0") && stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
                string5 = "0 (SPOT_" + this.probenames[i] + ")";
            } else {
                if (string5.charAt(0) == '\"' && string5.charAt(string5.length() - 1) == '\"') {
                    string5 = string5.substring(1, string5.length() - 1);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
            }
            this.genenames[i] = string5.trim().toUpperCase(Locale.ENGLISH);
            n4 = 0;
            if (bl4) {
                this.data[i][0] = 0.0;
                this.pmavalues[i][0] = 2;
                n3 = 1;
            } else {
                n3 = 0;
            }
            while (n3 < this.numcols) {
                if (!stringTokenizer.hasMoreTokens()) {
                    n4 = 1;
                } else {
                    string5 = stringTokenizer.nextToken();
                }
                if (n4 != 0 || string5.equals("\t")) {
                    this.data[i][n3] = 0.0;
                    this.pmavalues[i][n3] = 0;
                } else {
                    try {
                        this.data[i][n3] = Double.parseDouble(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string8 = string5 + " is not a valid real number";
                        if (bl3) {
                            string8 = "In the repeat/comparison set " + string8;
                        } else if ((n3 == 0 || n3 == 1 && bl4) && !bl2) {
                            string8 = string8 + "\nConsider checking 'Spot IDs included in the data file'";
                        }
                        throw new IllegalArgumentException(string8);
                    }
                    this.pmavalues[i][n3] = bl && this.data[i][n3] <= 0.0 ? 0 : 2;
                    if (stringTokenizer.hasMoreTokens() && (string5 = stringTokenizer.nextToken()).equals("\n")) {
                        n4 = 1;
                    }
                }
                ++n3;
            }
        }
    }

    public DataSetCore filterMissing1point() {
        boolean[] blArray = new boolean[this.numrows];
        int n = 0;
        for (int i = 0; i < this.numrows; ++i) {
            if (this.pmavalues[i][0] != 0) {
                blArray[i] = true;
                ++n;
                continue;
            }
            blArray[i] = false;
        }
        return this.filtergenesgeneral(blArray, n, true);
    }

    public DataSetCore filterMissing() {
        boolean[] blArray = new boolean[this.numrows];
        int n = 0;
        for (int i = 0; i < this.numrows; ++i) {
            int n2 = 0;
            int n3 = 0;
            boolean bl = true;
            if (this.pmavalues[i][0] == 0) {
                bl = false;
            }
            while (bl && n3 < this.numcols) {
                if (this.pmavalues[i][n3] == 0) {
                    ++n2;
                }
                bl = n2 <= this.nmaxmissing;
                ++n3;
            }
            if (bl) {
                blArray[i] = true;
                ++n;
                continue;
            }
            blArray[i] = false;
        }
        return this.filtergenesgeneral(blArray, n, true);
    }

    public DataSetCore filterDuplicates() {
        boolean[] blArray = new boolean[this.numrows];
        int n = 0;
        Hashtable<String, ArrayList<Integer>> hashtable = new Hashtable<String, ArrayList<Integer>>();
        for (int i = 0; i < this.numrows; ++i) {
            ArrayList<Integer> arrayList = (ArrayList<Integer>)hashtable.get(this.genenames[i]);
            if (arrayList == null) {
                blArray[i] = true;
                arrayList = new ArrayList<Integer>();
                ++n;
                hashtable.put(this.genenames[i], arrayList);
                continue;
            }
            blArray[i] = false;
            arrayList.add(new Integer(i));
        }
        return this.filtergenesgeneral(blArray, n, false);
    }

    public DataSetCore averageAndFilterDuplicates() {
        boolean[] blArray = new boolean[this.numrows];
        int n = 0;
        Hashtable<String, ArrayList<Integer>> hashtable = new Hashtable<String, ArrayList<Integer>>();
        int n2 = 1;
        for (int i = 0; i < this.numrows; ++i) {
            blArray[i] = true;
            ArrayList<Integer> arrayList = (ArrayList<Integer>)hashtable.get(this.genenames[i]);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
                ++n;
                hashtable.put(this.genenames[i], arrayList);
                continue;
            }
            arrayList.add(new Integer(i));
            if (arrayList.size() <= n2) continue;
            n2 = arrayList.size();
        }
        double[] dArray = new double[n2 + 1];
        int n3 = -1;
        this.genespottimedata = new double[n][][];
        this.genespottimepma = new int[n][][];
        for (int i = 0; i < this.numrows; ++i) {
            if (!blArray[i]) continue;
            ArrayList arrayList = (ArrayList)hashtable.get(this.genenames[i]);
            int n4 = arrayList.size();
            this.genespottimedata[++n3] = new double[n4 + 1][];
            this.genespottimedata[n3][0] = this.data[i];
            this.genespottimepma[n3] = new int[n4 + 1][];
            this.genespottimepma[n3][0] = this.pmavalues[i];
            for (int j = 0; j < this.numcols; ++j) {
                int n5 = 0;
                int n6 = 0;
                if (this.pmavalues[i][j] != 0) {
                    dArray[n5] = this.data[i][j];
                    ++n5;
                    n6 = this.pmavalues[i][j];
                }
                for (int k = 0; k < n4; ++k) {
                    int n7 = (Integer)arrayList.get(k);
                    if (j == 0) {
                        this.genespottimedata[n3][k + 1] = this.data[n7];
                        this.genespottimepma[n3][k + 1] = this.pmavalues[n7];
                        blArray[n7] = false;
                        int n8 = i;
                        this.probenames[n8] = this.probenames[n8] + ";" + this.probenames[n7];
                    }
                    if (this.pmavalues[n7][j] == 0) continue;
                    dArray[n5] = this.data[n7][j];
                    ++n5;
                    n6 = Math.max(n6, this.pmavalues[n7][j]);
                }
                this.pmavalues[i][j] = n6;
                if (n5 <= 0) continue;
                this.data[i][j] = Util.getmedian(dArray, n5);
            }
        }
        return this.filtergenesgeneral(blArray, n, false);
    }

    public DataSetCore logratio2() {
        double d = Math.log(2.0);
        for (int i = 0; i < this.numrows; ++i) {
            int n;
            double d2 = this.data[i][0];
            this.data[i][0] = 0.0;
            if (this.pmavalues[i][0] == 0) {
                for (n = 1; n < this.numcols; ++n) {
                    this.data[i][n] = Double.POSITIVE_INFINITY;
                    this.pmavalues[i][n] = 0;
                }
                continue;
            }
            for (n = 1; n < this.numcols; ++n) {
                this.data[i][n] = this.btakelog ? Math.log(this.data[i][n] / d2) / d : this.data[i][n] - d2;
            }
        }
        return new DataSetCore(this.szInputFile, this.genespottimedata, this.generepeatspottimedata, this.genespottimepma, this.generepeatspottimepma, this.data, this.pmavalues, this.probenames, this.genenames, this.dthresholdvalue, this.btakelog, this.bspotincluded, this.badd0, this.dsamplemins, this.sortedcorrvals, this.nmaxmissing, this.dmincorrelation, this.htFiltered, this.szProbeHeader, this.szGeneHeader, this.bmaxminval, this.otherInputFiles, this.bfullrepeat);
    }

    public DataSetCore mergeDataSets(DataSetCore[] dataSetCoreArray) {
        this.otherInputFiles = new String[dataSetCoreArray.length];
        for (int i = 0; i < dataSetCoreArray.length; ++i) {
            this.otherInputFiles[i] = dataSetCoreArray[i].szInputFile;
        }
        double[][] dArray = new double[this.numrows][this.numcols];
        int[][] nArray = new int[this.numrows][this.numcols];
        double[] dArray2 = new double[dataSetCoreArray.length + 1];
        if (this.bfullrepeat) {
            this.generepeatspottimedata = new double[this.numrows][dataSetCoreArray.length + 1][][];
            this.generepeatspottimepma = new int[this.numrows][dataSetCoreArray.length + 1][][];
        } else {
            this.generepeatspottimedata = null;
            this.generepeatspottimepma = null;
        }
        for (int i = 0; i < this.numrows; ++i) {
            if (this.bfullrepeat) {
                this.generepeatspottimedata[i][0] = this.genespottimedata[i];
                this.generepeatspottimepma[i][0] = this.genespottimepma[i];
            }
            for (int j = 0; j < this.numcols; ++j) {
                int n = 0;
                int n2 = 0;
                if (this.pmavalues[i][j] != 0) {
                    dArray2[n] = this.data[i][j];
                    ++n;
                    n2 = this.pmavalues[i][j];
                }
                for (int k = 0; k < dataSetCoreArray.length; ++k) {
                    if (this.bfullrepeat) {
                        this.generepeatspottimedata[i][k + 1] = dataSetCoreArray[k].genespottimedata[i];
                        this.generepeatspottimepma[i][k + 1] = dataSetCoreArray[k].genespottimepma[i];
                    }
                    if (dataSetCoreArray[k].pmavalues[i][j] == 0) continue;
                    dArray2[n] = dataSetCoreArray[k].data[i][j];
                    ++n;
                    n2 = Math.max(n2, dataSetCoreArray[k].pmavalues[i][j]);
                }
                if (n > 0) {
                    dArray[i][j] = Util.getmedian(dArray2, n);
                }
                nArray[i][j] = n2;
            }
        }
        DataSetCore dataSetCore = new DataSetCore(this.szInputFile, this.genespottimedata, this.generepeatspottimedata, this.genespottimepma, this.generepeatspottimepma, dArray, nArray, this.probenames, this.genenames, this.dthresholdvalue, this.btakelog, this.bspotincluded, this.badd0, this.dsamplemins, this.sortedcorrvals, this.nmaxmissing, this.dmincorrelation, this.htFiltered, this.szProbeHeader, this.szGeneHeader, this.bmaxminval, this.otherInputFiles, this.bfullrepeat);
        return dataSetCore;
    }

    public DataSetCore filterdistprofiles(DataSetCore dataSetCore, DataSetCore[] dataSetCoreArray) {
        int n = (dataSetCoreArray.length + 1) * dataSetCoreArray.length / 2;
        double d = 1.0 / (double)n;
        int n2 = 0;
        this.sortedcorrvals = new double[this.numrows];
        boolean[] blArray = new boolean[this.numrows];
        for (int i = 0; i < this.sortedcorrvals.length; ++i) {
            this.sortedcorrvals[i] = 0.0;
            for (int j = 0; j < dataSetCoreArray.length; ++j) {
                int n3 = i;
                this.sortedcorrvals[n3] = this.sortedcorrvals[n3] + d * Util.correlation(dataSetCore.data[i], dataSetCoreArray[j].data[i], dataSetCore.pmavalues[i], dataSetCoreArray[j].pmavalues[i]);
                for (int k = j + 1; k < dataSetCoreArray.length; ++k) {
                    int n4 = i;
                    this.sortedcorrvals[n4] = this.sortedcorrvals[n4] + d * Util.correlation(dataSetCoreArray[j].data[i], dataSetCoreArray[k].data[i], dataSetCoreArray[j].pmavalues[i], dataSetCoreArray[k].pmavalues[i]);
                }
            }
            if (this.sortedcorrvals[i] > this.dmincorrelation) {
                blArray[i] = true;
                ++n2;
                continue;
            }
            blArray[i] = false;
        }
        Arrays.sort(this.sortedcorrvals);
        return this.filtergenesgeneral(blArray, n2, true);
    }

    public DataSetCore filtergenesgeneral(boolean[] blArray, int n, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl2;
        if (n < 1) {
            throw new IllegalArgumentException("All Genes Filtered");
        }
        double[][] dArrayArray = new double[n][];
        int[][] nArrayArray = new int[n][];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        boolean bl3 = this.genespottimedata != null && this.genespottimedata.length == this.numrows;
        boolean bl4 = bl2 = this.generepeatspottimedata != null && this.generepeatspottimedata.length == this.numrows;
        if (!bl3) {
            object4 = this.genespottimedata;
            object3 = this.genespottimepma;
        } else {
            object4 = new double[n][][];
            object3 = new int[n][][];
        }
        if (!bl2) {
            object2 = this.generepeatspottimedata;
            object = this.generepeatspottimepma;
        } else {
            object2 = new double[n][][][];
            object = new int[n][][][];
        }
        int n2 = 0;
        for (int i = 0; i < this.numrows; ++i) {
            if (blArray[i]) {
                stringArray[n2] = this.genenames[i];
                stringArray2[n2] = this.probenames[i];
                if (bl3) {
                    object4[n2] = this.genespottimedata[i];
                    object3[n2] = this.genespottimepma[i];
                }
                if (bl2) {
                    object2[n2] = this.generepeatspottimedata[i];
                    object[n2] = this.generepeatspottimepma[i];
                }
                nArrayArray[n2] = this.pmavalues[i];
                dArrayArray[n2] = this.data[i];
                ++n2;
                continue;
            }
            if (!bl) continue;
            this.htFiltered.put(this.genenames[i], this.probenames[i]);
        }
        return new DataSetCore(this.szInputFile, (double[][][])object4, (double[][][][])object2, (int[][][])object3, (int[][][][])object, dArrayArray, nArrayArray, stringArray2, stringArray, this.dthresholdvalue, this.btakelog, this.bspotincluded, this.badd0, this.dsamplemins, this.sortedcorrvals, this.nmaxmissing, this.dmincorrelation, this.htFiltered, this.szProbeHeader, this.szGeneHeader, this.bmaxminval, this.otherInputFiles, this.bfullrepeat);
    }

    public DataSetCore filtergenesthreshold2() {
        if (this.bmaxminval) {
            return this.filtergenesthreshold2maxmin();
        }
        return this.filtergenesthreshold2change();
    }

    private DataSetCore filtergenesthreshold2change() {
        boolean[] blArray = new boolean[this.numrows];
        int n = 0;
        for (int i = 0; i < this.numrows; ++i) {
            double d = 0.0;
            for (int j = 1; j < this.numcols; ++j) {
                if (this.pmavalues[i][j] <= 0 || !(Math.abs(this.data[i][j]) > d)) continue;
                d = Math.abs(this.data[i][j]);
            }
            if (d >= this.dthresholdvalue) {
                blArray[i] = true;
                ++n;
                continue;
            }
            blArray[i] = false;
        }
        return this.filtergenesgeneral(blArray, n, true);
    }

    private DataSetCore filtergenesthreshold2maxmin() {
        boolean[] blArray = new boolean[this.numrows];
        int n = 0;
        for (int i = 0; i < this.numrows; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 1; j < this.numcols; ++j) {
                if (this.pmavalues[i][j] > 0 && this.data[i][j] > d) {
                    d = this.data[i][j];
                }
                if (this.pmavalues[i][j] <= 0 || !(this.data[i][j] < d2)) continue;
                d2 = this.data[i][j];
            }
            if (d - d2 >= this.dthresholdvalue) {
                blArray[i] = true;
                ++n;
                continue;
            }
            blArray[i] = false;
        }
        return this.filtergenesgeneral(blArray, n, true);
    }

    public DataSetCore filtergenesthreshold1point() {
        boolean[] blArray = new boolean[this.numrows];
        int n = 0;
        for (int i = 0; i < this.numrows; ++i) {
            double d = Math.abs(this.data[i][0]);
            if (d >= this.dthresholdvalue) {
                blArray[i] = true;
                ++n;
                continue;
            }
            blArray[i] = false;
        }
        return this.filtergenesgeneral(blArray, n, true);
    }
}

