/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.chromviewer;

import edu.cmu.cs.sb.chromviewer.BareBonesBrowserLaunch;
import edu.cmu.cs.sb.chromviewer.Gene;
import edu.cmu.cs.sb.chromviewer.GenomeFileParser;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;

public class GeneRectangle
extends PPath {
    private GenomeFileParser yp;
    protected boolean mHorizontalOrientation = true;
    public Gene mGeneInfo = null;
    public String mGeneAlias = null;
    protected double mWidthScale = 0.0;
    protected boolean mLeftToRight = true;
    protected GeneMouseOverHandler mInputListener = null;

    public GeneRectangle(Gene gene, String string, float f, double d, boolean bl, GenomeFileParser genomeFileParser) {
        this.mGeneInfo = gene;
        this.mGeneAlias = string;
        this.yp = genomeFileParser;
        this.mLeftToRight = bl;
        int n = this.mGeneInfo.end - this.mGeneInfo.start + 1;
        this.setPathToRectangle(0.0f, 0.0f, n, f);
        this.setWidthScale(d);
    }

    public void clearGenes() {
        this.removeAllChildren();
    }

    public void setWidthScale(double d) {
        if (d == this.mWidthScale) {
            return;
        }
        this.mWidthScale = d;
        int n = this.mGeneInfo.end - this.mGeneInfo.start;
        this.setWidth((double)n * this.mWidthScale);
    }

    public String getName() {
        if (this.mGeneAlias != null) {
            return this.mGeneAlias;
        }
        return this.mGeneInfo.namechrom;
    }

    public class GeneMouseOverHandler
    extends PBasicInputEventHandler {
        private boolean mMouseIn = false;
        private PPath mHoverNode = null;
        private Vector genesUnder = new Vector();

        public void mouseClicked(PInputEvent pInputEvent) {
            String[] stringArray;
            if (!this.mMouseIn) {
                return;
            }
            GeneRectangle geneRectangle = (GeneRectangle)pInputEvent.getPickedNode();
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            Enumeration enumeration = this.genesUnder.elements();
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                int n3 = stringArray.mGeneInfo.start;
                int n4 = stringArray.mGeneInfo.end;
                if (n3 < n) {
                    n = n3;
                }
                if (n4 <= n2) continue;
                n2 = n4;
            }
            stringArray = GeneRectangle.this.yp.getSpecies().split(" ");
            String string = "http://www.ensembl.org/";
            string = string + stringArray[0] + "_" + stringArray[1];
            string = string + "/contigview?chr=";
            string = string + ((GeneRectangle)GeneRectangle.this).yp.getChroms()[geneRectangle.mGeneInfo.chromosome].namechrom;
            string = string + "&vc_start=" + n + "&vc_end=" + n2;
            BareBonesBrowserLaunch.openURL(string);
        }

        public void mouseEntered(PInputEvent pInputEvent) {
            this.mMouseIn = true;
            try {
                GeneRectangle geneRectangle = (GeneRectangle)pInputEvent.getPickedNode();
                GeneRectangle geneRectangle2 = (GeneRectangle)geneRectangle.getParent();
                PBounds pBounds = geneRectangle.getGlobalBounds();
                PText pText = new PText("");
                pText.setTextPaint(geneRectangle.getPaint());
                pText.setText("");
                boolean bl = false;
                ListIterator listIterator = geneRectangle2.getChildrenIterator();
                while (listIterator.hasNext()) {
                    GeneRectangle geneRectangle3 = (GeneRectangle)listIterator.next();
                    PBounds pBounds2 = geneRectangle3.getGlobalBounds();
                    if (geneRectangle.mGeneInfo.strand != geneRectangle3.mGeneInfo.strand || !(pBounds2.getX() <= pBounds.getX() + pBounds.getWidth() + 1.0) || !(pBounds2.getX() + pBounds2.getWidth() >= pBounds.getX() - 1.0)) continue;
                    if (bl) {
                        pText.setText(pText.getText() + "\n");
                    }
                    bl = true;
                    int n = geneRectangle3.mGeneInfo.start;
                    int n2 = geneRectangle3.mGeneInfo.end;
                    pText.setText(pText.getText() + geneRectangle3.getName() + "\n" + n + ".." + n2);
                    this.genesUnder.add(geneRectangle3);
                }
                this.mHoverNode = PPath.createRectangle(0.0f, 0.0f, (float)pText.getWidth() + 4.0f, (float)pText.getHeight() + 4.0f);
                this.mHoverNode.setStrokePaint(Color.GRAY);
                this.mHoverNode.addChild(pText);
                pText.setOffset(2.0, 2.0);
                geneRectangle2.addChild(this.mHoverNode);
                geneRectangle2.moveToFront();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void mouseMoved(PInputEvent pInputEvent) {
            if (this.mHoverNode == null) {
                return;
            }
            try {
                GeneRectangle geneRectangle = (GeneRectangle)pInputEvent.getPickedNode().getParent();
                this.mHoverNode.setOffset(pInputEvent.getPositionRelativeTo(geneRectangle));
                this.mHoverNode.translate(this.mHoverNode.getX() + 10.0, this.mHoverNode.getY() + 10.0);
                this.mHoverNode.repaint();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void mouseExited(PInputEvent pInputEvent) {
            if (!this.mMouseIn) {
                return;
            }
            this.mMouseIn = false;
            if (this.mHoverNode == null) {
                return;
            }
            try {
                GeneRectangle geneRectangle = (GeneRectangle)pInputEvent.getPickedNode().getParent();
                geneRectangle.removeChild(this.mHoverNode);
                this.mHoverNode = null;
                this.genesUnder.clear();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

