/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.chromviewer;

import edu.cmu.cs.sb.chromviewer.Gene;
import edu.cmu.cs.sb.chromviewer.GeneRectangle;
import edu.cmu.cs.sb.chromviewer.GenomeFileParser;
import edu.umd.cs.piccolo.PNode;
import java.awt.Paint;

public class ChromRectangle
extends GeneRectangle {
    private boolean mChangeLayout = false;
    private GenomeFileParser gp;

    public ChromRectangle(Gene gene, float f, double d, boolean bl, GenomeFileParser genomeFileParser) {
        super(gene, null, f, d, bl, genomeFileParser);
        this.gp = genomeFileParser;
    }

    public void layoutChildren() {
        if (!this.mChangeLayout) {
            return;
        }
        this.mChangeLayout = false;
        int n = this.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            PNode pNode = this.getChild(i);
            if (!pNode.getClass().getName().equals("GeneRectangle")) continue;
            GeneRectangle geneRectangle = (GeneRectangle)pNode;
            geneRectangle.setWidthScale(this.mWidthScale);
            if (this.mLeftToRight) {
                n2 = geneRectangle.mGeneInfo.start;
                geneRectangle.setOffset((double)n2 * this.mWidthScale, geneRectangle.getYOffset());
                continue;
            }
            n2 = this.mGeneInfo.end - geneRectangle.mGeneInfo.end;
            geneRectangle.setOffset((double)n2 * this.mWidthScale, geneRectangle.getYOffset());
        }
    }

    public void setWidthScale(double d) {
        super.setWidthScale(d);
        this.mChangeLayout = true;
    }

    public void addGene(Gene gene, String string, Paint paint) {
        GeneRectangle geneRectangle = new GeneRectangle(gene, string, (float)this.getHeight() / 2.0f - 1.0f, this.mWidthScale, this.mLeftToRight, this.gp);
        geneRectangle.setStrokePaint(paint);
        geneRectangle.setPaint(paint);
        geneRectangle.addInputEventListener(new GeneRectangle.GeneMouseOverHandler(this));
        double d = 0.0;
        double d2 = 0.0;
        if (this.mLeftToRight) {
            d = (double)gene.start * this.mWidthScale;
        } else {
            double d3 = this.mGeneInfo.end - gene.end;
            d = d3 * this.mWidthScale;
        }
        d2 = gene.strand == '+' ? 0.0 : geneRectangle.getHeight();
        this.addChild(geneRectangle);
        geneRectangle.setOffset(d, d2);
        this.repaint();
    }
}

