/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.sb.chromviewer;

import edu.cmu.cs.sb.chromviewer.ChromFrame;
import edu.cmu.cs.sb.chromviewer.Gene;
import edu.cmu.cs.sb.chromviewer.GenomeFileParser;
import edu.cmu.cs.sb.chromviewer.TableSorterRoman;
import edu.cmu.cs.sb.core.DataSetCore;
import edu.cmu.cs.sb.core.GoAnnotations;
import edu.cmu.cs.sb.core.MultiLineHeaderRenderer;
import edu.cmu.cs.sb.core.StatUtil;
import edu.cmu.cs.sb.core.TableModelST;
import edu.cmu.cs.sb.core.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ChromEnrichmentTable
extends JPanel
implements ActionListener {
    private boolean DEBUG = false;
    JFrame theFrame;
    DataSetCore theDataSet;
    GoAnnotations.GoResults tgr;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    JButton saveButton;
    JButton copyButton;
    String[][] tabledata = null;
    String[] columnNames = null;
    TableSorterRoman sorter;
    HashSet htinames;
    String szTitle;
    ChromFrame cf;
    static final int PVALUE_INDEX = 5;
    static final int CORRECTEDPVALUE_INDEX = 6;

    public ChromEnrichmentTable(JFrame jFrame, GenomeFileParser genomeFileParser, int n) {
        String[] stringArray;
        int n2;
        this.setLayout(new BoxLayout(this, 3));
        this.setBackground(bg);
        this.setForeground(fg);
        this.theFrame = jFrame;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumFractionDigits(1);
        numberFormat.setGroupingUsed(false);
        int n3 = 7;
        Gene[] geneArray = genomeFileParser.getChromArray();
        this.columnNames = new String[n3];
        this.columnNames[0] = "Chromosome";
        this.columnNames[1] = "#Genes\nBase Set";
        this.columnNames[2] = "#Genes\nAssigned";
        this.columnNames[3] = "#Genes\nExpected";
        this.columnNames[4] = "#Genes\nEnriched";
        this.columnNames[5] = "p-value";
        this.columnNames[6] = "Corrected\np-value";
        this.tabledata = new String[geneArray.length][];
        NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat2.setMinimumFractionDigits(3);
        numberFormat2.setMaximumFractionDigits(3);
        int[] nArray = genomeFileParser.getBaseCountPerChrom();
        int[] nArray2 = genomeFileParser.getActiveCountPerChrom();
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < geneArray.length; ++i) {
            n4 += nArray[i];
            n5 += nArray2[i];
        }
        RecRow[] recRowArray = new RecRow[geneArray.length];
        for (n2 = 0; n2 < geneArray.length; ++n2) {
            double d;
            stringArray = new String[this.columnNames.length];
            stringArray[0] = geneArray[n2].namechrom;
            stringArray[1] = "" + nArray[n2];
            stringArray[2] = "" + nArray2[n2];
            double d2 = (double)(nArray[n2] * n5) / (double)n4;
            stringArray[3] = numberFormat.format(d2);
            double d3 = (double)nArray2[n2] - d2;
            stringArray[4] = numberFormat.format(d3);
            double d4 = StatUtil.hypergeometrictail(nArray2[n2] - 1, nArray[n2], n4 - nArray[n2], n5);
            double d5 = (double)geneArray.length * d4;
            stringArray[5] = Util.doubleToSz(d4);
            if (!genomeFileParser.brandcorrectedpval) {
                stringArray[6] = Util.doubleToSz(Math.min(1.0, d4 * (double)geneArray.length));
            }
            if ((d = Double.parseDouble(stringArray[3])) > 0.0) {
                stringArray[3] = "+" + stringArray[3];
            } else if (d == 0.0) {
                stringArray[3] = "0.0";
            }
            recRowArray[n2] = new RecRow(stringArray, d4);
        }
        Arrays.sort(recRowArray, new RecRowCompare());
        if (genomeFileParser.brandcorrectedpval) {
            this.ComputeCorrectedPval(recRowArray, genomeFileParser, nArray, genomeFileParser.nsamplespval, n);
        }
        for (n2 = 0; n2 < recRowArray.length; ++n2) {
            this.tabledata[n2] = recRowArray[n2].therow;
        }
        this.sorter = new TableSorterRoman((TableModel)new TableModelST(this.tabledata, this.columnNames), 0);
        JTable jTable = new JTable(this.sorter);
        stringArray = new MultiLineHeaderRenderer(this.sorter);
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer((TableCellRenderer)stringArray);
        }
        this.sorter.setTableHeader(jTable.getTableHeader());
        jTable.setPreferredScrollableViewportSize(new Dimension(800, Math.min((jTable.getRowHeight() + jTable.getRowMargin()) * jTable.getRowCount(), 400)));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(40);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(40);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(40);
        tableColumn = jTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(40);
        tableColumn = jTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(40);
        tableColumn = jTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(40);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add(jScrollPane);
        this.copyButton = new JButton("Copy Table", Util.createImageIcon("Copy16.gif"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMinimumSize(new Dimension(800, 20));
        this.copyButton.addActionListener(this);
        this.saveButton = new JButton("Save Table", Util.createImageIcon("Save16.gif"));
        this.saveButton.setActionCommand("save");
        this.saveButton.setMinimumSize(new Dimension(800, 20));
        this.saveButton.addActionListener(this);
        jTable.setSelectionMode(0);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.add(this.copyButton);
        jPanel.add(this.saveButton);
        JButton jButton = new JButton(Util.createImageIcon("Help16.gif"));
        jButton.addActionListener(this);
        jButton.setActionCommand("help");
        jPanel.add(jButton);
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.add(jPanel);
    }

    public void printFile(PrintWriter printWriter) {
        int n;
        for (n = 0; n < this.columnNames.length; ++n) {
            String string = this.columnNames[n];
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    printWriter.print(" ");
                    continue;
                }
                printWriter.print(c);
            }
            if (n >= this.columnNames.length - 1) continue;
            printWriter.print("\t");
        }
        printWriter.println();
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                printWriter.print(this.tabledata[n][i] + "\t");
            }
            printWriter.println(this.tabledata[n][this.tabledata[n].length - 1]);
        }
    }

    public void writeToClipboard() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.columnNames.length; ++n) {
            String string = this.columnNames[n];
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    stringBuffer.append(" ");
                    continue;
                }
                stringBuffer.append(c);
            }
            if (n >= this.columnNames.length - 1) continue;
            stringBuffer.append("\t");
        }
        stringBuffer.append("\n");
        for (n = 0; n < this.tabledata.length; ++n) {
            for (int i = 0; i < this.tabledata[n].length - 1; ++i) {
                stringBuffer.append(this.tabledata[n][i] + "\t");
            }
            stringBuffer.append(this.tabledata[n][this.tabledata[n].length - 1] + "\n");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("copy")) {
            this.writeToClipboard();
        } else if (string.equals("save")) {
            try {
                int n = Util.theChooser.showSaveDialog(this);
                if (n == 0) {
                    File file = Util.theChooser.getSelectedFile();
                    PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                    this.printFile(printWriter);
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                final FileNotFoundException fileNotFoundException2 = fileNotFoundException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fileNotFoundException2.getMessage(), "Exception thrown", 0);
                    }
                });
                fileNotFoundException.printStackTrace(System.out);
            }
        } else if (string.equals("help")) {
            String string2 = "The table contains a Chromosome enrichment analysis for the set of genes in the displayed set. The columns are as follows +'Chromosome' - the ID of the Chromosome\n+'#Genes Base Set' - how many genes were assigned to that chromosome in the base set of genes before any filtering\n+'#Genes Assigned' - the # genes in the current set assigned to that chromosome\n+'#Genes Expected' - the # genes expected to be assigned to chromosome if a set of the same size as currently displayed was randomly drawn from the base set without replacement\n+'#Genes Enriched' - the difference between the number of genes assigned and expected\n+'p-value' - the enrichment p-value based on the hypergeometric distribution\n+'Corrected p-value' - the corrected p-value for the enrichment using the same method as specified for the p-value correction method for the Go Analysis (either Bonferroni or Randomization).";
            Util.renderDialog(this.theFrame, string2);
        }
    }

    private void ComputeCorrectedPval(RecRow[] recRowArray, GenomeFileParser genomeFileParser, int[] nArray, int n, int n2) {
        int n3;
        int n4;
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        int n5 = genomeFileParser.basegenesets.length;
        int[] nArray2 = new int[n2];
        double[] dArray = new double[n];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[genomeFileParser.m_chromArray.length];
        int n6 = 0;
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (nArray[n4] <= n6) continue;
            n6 = nArray[n4];
        }
        for (n4 = 0; n4 < n; ++n4) {
            int n7;
            int n8;
            for (n3 = 0; n3 < nArray3.length; ++n3) {
                nArray3[n3] = n6 + 1;
            }
            dArray[n4] = 1.0;
            for (n3 = 0; n3 < n2; ++n3) {
                nArray2[n3] = n3;
            }
            for (n3 = n2; n3 < n5; ++n3) {
                if (!(Math.random() < (double)n2 / (double)(n3 + 1))) continue;
                nArray2[(int)Math.floor((double)((double)n2 * Math.random()))] = n3;
            }
            for (n8 = 0; n8 < nArray4.length; ++n8) {
                nArray4[n8] = 0;
            }
            for (n8 = 0; n8 < n2; ++n8) {
                HashSet hashSet = genomeFileParser.basegenesets[nArray2[n8]];
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    int n9 = n7 = ((Gene)iterator.next()).chromosome;
                    nArray4[n9] = nArray4[n9] + 1;
                }
            }
            for (n8 = 0; n8 < nArray4.length; ++n8) {
                int n10 = nArray4[n8];
                n7 = nArray[n8];
                if (n10 < 1 || nArray3[--n10] <= n7) continue;
                nArray3[n10] = n7;
            }
            n8 = n6 + 1;
            for (int i = nArray3.length - 1; i >= 0; --i) {
                double d;
                if (nArray3[i] >= n8) continue;
                String string = i + "," + nArray3[i];
                Object v = hashMap.get(string);
                n8 = nArray3[i];
                if (v == null) {
                    d = StatUtil.hypergeometrictail(i, nArray3[i], n5 - nArray3[i], n2);
                    hashMap.put(string, new Double(d));
                } else {
                    d = (Double)v;
                }
                if (!(d < dArray[n4])) continue;
                dArray[n4] = d;
            }
        }
        Arrays.sort(dArray);
        n4 = 0;
        for (n3 = 0; n3 < recRowArray.length; ++n3) {
            double d = Double.parseDouble(recRowArray[n3].therow[5]);
            while (n4 < dArray.length && dArray[n4] <= d) {
                ++n4;
            }
            recRowArray[n3].therow[6] = "" + (double)n4 / (double)dArray.length;
        }
    }

    static class RecRowCompare
    implements Comparator {
        RecRowCompare() {
        }

        public int compare(Object object, Object object2) {
            RecRow recRow = (RecRow)object;
            RecRow recRow2 = (RecRow)object2;
            if (recRow.dpval < recRow2.dpval) {
                return -1;
            }
            if (recRow.dpval > recRow2.dpval) {
                return 1;
            }
            return recRow.therow[0].compareTo(recRow2.therow[0]);
        }
    }

    static class RecRow {
        String[] therow;
        double dpval;

        RecRow(String[] stringArray, double d) {
            this.therow = stringArray;
            this.dpval = d;
        }
    }
}

