/* constants */

FACING_LEFT = 1;
FACING_RIGHT = 4;
FIELD_WIDTH = 10;
BOUNDARY_WIDTH = 5;
FIELD_HEIGHT = 6;

MX = {left: -1,  right: 1, up: 0, down: 0};
MY = {up: -1,  down: 1, left: 0, right: 0};

/*
 global state

 numPlace
 curscore

 curMove
 curMoveT
 nextMove

 wugx
 wugy
 
 facing
 
 debugTxt // debugging window

 music

 depthCounter

 script

 items

 inventory

 */

var allClips = [];
var jump = new Sound(); jump.attachSound("ijump");
var drop = new Sound(); drop.attachSound("idrop");
var score = new Sound(); score.attachSound("iscore");
var pickup = new Sound(); pickup.attachSound("ipickup");

var music = new Sound();
music.attachSound("imusic");
  
function initialize() {
  numPlace = 0;
  curscore = 0;
  depthCounter = 1;
  scoreAnims = [];
  wugx = 0;
  wugy = 0;
  facing = FACING_LEFT;
  curMove = undefined;
  curMoveT = 0;
  nextMove = undefined;
  
  
  music.onSoundComplete = function () { music.start(0); };
  music.start(0);

  mainKeyListener = {onKeyDown: mainKeyHandler};
  Key.addListener( mainKeyListener );
  this.onEnterFrame = onEnterHandler;
  initField();
}

function clear() {
  debugTxt.text = "";
}

function debug(txt) {
/*   var  d = new Date(); */
/*   var ms = d.getMilliseconds(); */
//   debugTxt.text = debugTxt.text + "\n" +  s.position + " " + ms + " " + txt; 
   debugTxt.text = debugTxt.text +  txt + "\n"; 
}

function attach(c, n, d) {
  var x = _root.attachMovie(c, n, d);
  allClips.push(x);
  return x;
}

function removeAll() {
  for (var i = 0; i < allClips.length; i++) {
    allClips[i].removeMovieClip();
  }
  allClips = [];
}

function computeScoreDir(wugx, wugy, dir) {
  var newx = wugx + MX[dir];
  var newy = wugy + MY[dir];

  // debug(newx + ", " + newy + ", " + BOUNDARY_WIDTH);
  if (newx >= BOUNDARY_WIDTH && newx < FIELD_WIDTH &&
      newy >= 0 && newy < FIELD_HEIGHT
      &&     items[newx][newy] != undefined)
 {
    var newf = items[newx][newy]._currentFrame - 1; 
    var oldf = items[wugx][wugy]._currentFrame - 1;
    //    debug(" GRABBING " + wugx + "," + wugy + " ---- " + newf + ", " + oldf);
    var score = 0;

    score += ((Math.floor(newf / 3) == Math.floor(oldf / 3)) ? 1 : 0);
    score += ((newf % 3 == oldf % 3) ? 1 : 0);

    if (score > 0) {
      var depth =  2000 + depthCounter++; 
      var movieName = score == 2 ? "sc200" : "sc100";
      var sc = attach(movieName ,  "s" + depth  ,  depth); 
      sc._x = 64 * (wugx + newx) / 2 ; 
      sc._y = 64 * (wugy + newy) / 2;
      sc._xscale = 200; 
      sc._yscale = 200; 
      scoreAnims.push([sc, 0]); 
    } 
    return score;
  }
  else return 0;
}


function computeScore(wugx, wugy) {
  var dscore = computeScoreDir(wugx, wugy, "left") +
    computeScoreDir(wugx, wugy, "up") +
    computeScoreDir(wugx, wugy, "down") +
    computeScoreDir(wugx, wugy, "right");
  curscore += 100 * dscore;
  return dscore;
}


function mainKeyHandler () {

  if (nextMove != undefined) return;

  var c = Key.getCode();
  //   debug( "Key code: " + c);	
  var tryMove = undefined;
  if (c == 37) tryMove = "left";
  else if (c == 39) tryMove = "right";
  else if (c == 40) tryMove = "down";
  else if (c == 38) tryMove = "up";

  if (tryMove != undefined) {
    var newx = wugx + MX[tryMove];
    var newy = wugy + MY[tryMove];
    if (newx >= 0 && newx < FIELD_WIDTH &&
	newy >= 0 && newy < FIELD_HEIGHT) {
      nextMove = tryMove;
      wugx = newx;
      wugy = newy;
      jump.start(0.1);
    }
  }

  if (c == 32) { 
    if (inventory == undefined) {
      if (wugx < BOUNDARY_WIDTH && items[wugx][wugy] != undefined) {
	inventory = items[wugx][wugy];
	nextMove = "pickup";
	items[wugx][wugy] = undefined;
	pickup.start(0.1);
      }
    }
    else {
      if (wugx >= BOUNDARY_WIDTH && items[wugx][wugy] == undefined) {
	inventory._x = wugx * 64;
	inventory._y = wugy * 64;
	numPlace++;

	if (numPlace >= BOUNDARY_WIDTH * FIELD_HEIGHT) 
	  nextMove = "outro";
	else
	  nextMove = "pickup";

	// debug("DROPPING " + inventory + "->" + wugx + " " + wugy);
	items[wugx][wugy] = inventory;
	inventory = undefined;

	if (computeScore(wugx,wugy) > 0) 
	  score.start(0.1);
	else
	  drop.start(0.1);
      }
    }

  }
}

script = new Object;
script["left"] = [function() {wuganim.gotoAndStop(2);  facing = FACING_LEFT;},
		  function() {wuganim.gotoAndStop(3); move_wug(-32,0);},
		  function() {wuganim.gotoAndStop(1); move_wug(-32,0);}
		  ];
script["right"] = [function() {wuganim.gotoAndStop(5);  facing = FACING_RIGHT;},
		   function() {wuganim.gotoAndStop(6);  move_wug(32,0);},
		   function() {wuganim.gotoAndStop(4); move_wug(32,0);}
		  ];
script["up"] = [function() {wuganim.gotoAndStop(facing + 1); },
		function() {wuganim.gotoAndStop(facing + 2); move_wug(0,-32);},
		function() {wuganim.gotoAndStop(facing + 0); move_wug(0,-32);}
		];
script["down"] = [function() {wuganim.gotoAndStop(facing + 1); },
		  function() {wuganim.gotoAndStop(facing + 2); move_wug(0,32);},
		function() {wuganim.gotoAndStop(facing + 0);move_wug(0,32);}
		];
script["pickup"] = [function() {wuganim.gotoAndStop(facing + 1); },
		    function() {wuganim.gotoAndStop(facing + 0); redraw_inventory(); }
		];
script["outro"] = [
		   function() {wuganim.gotoAndStop(facing + 2); },
		   function() {wuganim.gotoAndStop(facing + 2); },
		   function() {wuganim.gotoAndStop(facing + 0); },
		   function() {wuganim.gotoAndStop(facing + 0); },
		   function() {wuganim.gotoAndStop(facing + 2); },
		   function() {wuganim.gotoAndStop(facing + 2); },
		   function() {wuganim.gotoAndStop(facing + 0); },
		   function() {wuganim.gotoAndStop(facing + 0); },
		   function() {wuganim.gotoAndStop(facing + 2); },
		   function() {wuganim.gotoAndStop(facing + 2); },
		   function() {wuganim.gotoAndStop(facing + 0); },
		   function() {wuganim.gotoAndStop(facing + 0); },
		   function() {wuganim.gotoAndStop(facing + 2); },
		   function() {wuganim.gotoAndStop(facing + 2); },
		   function() {wuganim.gotoAndStop(facing + 0); },
		   function() {wuganim.gotoAndStop(facing + 0); },
		   function() {outro(); }
		];


function move_wug(dx,dy) {
  wuganim._x += dx;
  wuganim._y += dy;
  redraw_inventory();
}
function redraw_inventory() {
  if (inventory != undefined) {
    inventory._x = wuganim._x;
    inventory._y = wuganim._y - 24;
  }
}

function onEnterHandler() {

  var newScoreAnims = [];
  for (var i = 0; i < scoreAnims.length; i++) {
    var x = scoreAnims[i];
    var sprite = x[0];
    var ttl = x[1];
    if (ttl == 10) {
      sprite.removeMovieClip();
    }
    else {
      sprite._y--;
      newScoreAnims.push([sprite,ttl+1]);
    }
  }
  scoreAnims = newScoreAnims;

  if (curMove == undefined) {
    curMove = nextMove;
    nextMove = undefined;
    curMoveT = 0;
  }
  else {
    var f = script[curMove][curMoveT];
    f();
    curMoveT++;
    if (curMoveT >= script[curMove].length) 
      curMove = undefined;
  }
}

function initField() {
  attach("mcfield", "mcfield", 0);

  items = new Array();
  for (i=0; i<BOUNDARY_WIDTH; i++) {
    items[i] = new Array();
    for (j=0; j<6; j++) {
      var sx = attach("shapespr" ,  "s" + (depthCounter++)  ,  depthCounter);
      sx._xscale = 200;
      sx._yscale = 200;
      sx._x = i * 64;
      sx._y = j * 64;
      sx.gotoAndStop (1 + Math.floor(Math.random() * 9));
      items[i][j] = sx;
    }
  }
  
  for (i=BOUNDARY_WIDTH; i<FIELD_WIDTH; i++) {
    items[i] = new Array();
  }
  
  var wug = attach("wuganim", "wuganim", 1000);
  wug._xscale = 200;
  wug._yscale = 200;
  wug._x = 0;
  wug._y = 0;
}

function intro() {
  var splash = attach("mcintro", "mcintro", 0);
  // this.createTextField("debugTxt", 3000, 0, 200, 500, 200);
  splash.onpress = function() { splash.removeMovieClip(); initialize(); };
}

function outro() {
  removeAll();
  music.stop();
  Key.removeListener( mainKeyListener );
  this.onEnterFrame = undefined;
  var outro = attach("mcoutro", "mcoutro", 0);
  createTextField("t", 1, 30, 130, 300, 300);
  t.text = "Your score was:\n" + curscore + "\n\nThat's one classy wug!";
  var f = new TextFormat();
  f.size = 24;
  f.font = "nitz";
  f.color = 0xffffff;
  f.align = "center";
  t.setTextFormat(f);
  outro.onpress = function() { t.removeTextField(); outro.removeMovieClip(); intro(); };
}

intro();
