/*
	This is a simple data class
	
	Using the work from the previous class,
	
	we added constructors (which are overloaded).
	we added a toString method (which overrides the default).
	
	Overloading methods means that we have multiple methods
	with the same name
	
	Overriding a method means that we replace a pre-existing method (which,
	by default, we inherited) with a version better suited to our needs
*/

public class Student {

	// instance variables
	private String name;
	private int age;

	// constructors
	public Student (String n, int a) {
		name = n;
		age = a;
	}

	public Student (String n) {
		name = n;
		age = 18;
	}

	public Student () {
		name = "unknown";
		age = -1;
	}
	
	
	
	// accessors
	public String getName () {
		return name;
	}

	public int getAge () {
		return age;
	}
	
	public String toString() {
	// this method overrides the default toString
	// this returns a minimal textual representation of
	// the state of the object
		return name + "," + age;	
	}
			
	// mutators
	public void setAge( int a) {
		age = a;
	}

	public void setName ( String n) {
		name = n;
	}
		
}