/*
	This version is an attempt to solve the problem of providing
	multiple pieces of information
	
	It happens to work in the particular example but
	it would not work in general circumstances (e.g., if more than
	one primitive type is required - say age and gpa)
	
	This takes advantage of the StringBuffer class that can be used
	instead of String. Strings can't be changed but a StringBuffer
	has methods that allow it to be modified.
	
	Parameters corresponding to objects can be modified by a method (if the
	method calls one of that object's mutators)
	
	Primitive type parameters are always copied and can never be changed.
	
	Object type parameters are also copied but recall that the value
	of an object type is the location of (i.e., reference to) the object.
	Hence what is copied is where the object can be found.
	
*/

public class Students {

	public static TextInput kb = new TextInput();

	public static void main(String args[]) {
		System.out.println("Students (version 3)");
		
		StringBuffer studentName = new StringBuffer("unknown");
		int studentAge = -5;		
		
		studentAge = getInfo(studentName);
		
		System.out.println (studentName + " is " 
						+ studentAge + " years old.");
	}
	
	
	public static int getInfo (StringBuffer n) {
	// This method gets student info; it modifies the original name n
	// to be one that is provided by the student. 
	// The method returns the age of the student
		char answer;
		String name;
		int age;
		do {
			System.out.print ("What is the student's name? ");
			name = kb.readLine();
			System.out.print ("What is the student's age? ");
			age = kb.readInt();
		
			System.out.print ("Is this info correct ");
			answer = kb.readChar();
		} while (answer != 'Y' && answer != 'y');

		n.replace(0,n.length(),name);

		return age;
	}
	
}
