/*
	This version is the first solution to the problem of providing
	multiple pieces of information
	
	This is achieved by using class-level variables (sometimes called global variables)
	to store the results. The calling method (here, main) also has access to these
	variables.
	
	The method getInfo modifies the class-level variables implicitly rather than
	explicitly. This is called a side-effect.
	
	In the early days of programming, this technique was used a lot. However, as
	programs grew in size, there ended up being huge numbers of such variables. 
	This made programs hard to read. And since these variables are accessible to 
	all methods of the program, there was a strong potential for variables to
	be modified in error. If an incorrect computation is detected, programmers would
	have to examine the entire program for where the bug might have occurred.
	
*/

public class Students {

	public static String studName;
	public static int studAge;
	
	public static TextInput kb = new TextInput();
	
	public static void main(String args[]) {
		System.out.println ("Students (version 2)");
		getInfo();
		System.out.println(studName + " is " + studAge + " years old.");

	}
		
	public static void getInfo () {
	// This method gets student info.
	// Via side effects, it modifies class-level (global) variables
	// that store the results. The main program can then use the results
		char answer;
		String name;
		int age;
		do {
			System.out.print ("What is the student's name? ");
			name = kb.readLine();
			System.out.print ("What is the student's age? ");
			age = kb.readInt();
		
			System.out.print ("Is this info correct ");
			answer = kb.readChar();
		} while (answer != 'Y' && answer != 'y');

		studName = name;
		studAge = age;
	}
	
}
