/*
	The MonitorSorts class does a benchmark comparison of 
	three sorting algorithms.	

	Written by Jeff Carroll 11/09/03
*/

import java.io.*;
import java.util.*;

public class MonitorSorts {

	private static BufferedReader keybd =
		new BufferedReader(new InputStreamReader(System.in));

	private static final int MAX_CAPACITY = 1000000;

	private static Random rng = new Random();
	private static int numElements = 1000;
	private static int posRange = 10000;

	private static int[] unsorted = new int[MAX_CAPACITY],
				sorted = new int[MAX_CAPACITY];


	public static void main(String args[]) {
		System.out.println( "Test program to guage performance of sorting algorihtms.");

		//create an unsorted array
		generateArray();

		long startTimer, stopTimer;

		char choice;
		do { 
			choice = getBasicMenuSelection();
			switch (choice) {
				case 'C' :
				case 'R' : break;
				case 'G' :	
					generateArray();
					break;
				case 'S' :
					copy();			
					startTimer = System.currentTimeMillis();
					doSelectionSort();
					stopTimer = System.currentTimeMillis();
					System.out.println ("The selection sort on " + numElements + 
						" ints took " + (stopTimer-startTimer) + " milliseconds.");
					break;
				case 'M' :
					copy();							
					startTimer = System.currentTimeMillis();
					doMergeSort();
					stopTimer = System.currentTimeMillis();
					System.out.println ("The selection sort on " + numElements + 
						" ints took " + (stopTimer-startTimer) + " milliseconds.");
					break;				
				case 'I' :
					copy();			
					startTimer = System.currentTimeMillis();
					doInsertionSort();
					stopTimer = System.currentTimeMillis();
					System.out.println ("The insertion sort on " + numElements + 
						" ints took " + (stopTimer-startTimer) + " milliseconds.");
					break;			
				case 'L' : showList(unsorted);
					break;
				case 'K' : showList(sorted);
					break;
				default : displayMenu();
			}
			System.out.println();
		} while (choice != 'Q');
	}

	/* *********************************************************
	 *    Basic Menu methods
	 * *********************************************************/
	 
	private static char getBasicMenuSelection () {
		// gets a user selection (as a character)
		// if the user selection requires a parameter ('C' or 'R')
		// then the static variable numElements orposRange
		// is changed as a side effect.
		String answer ="";
		char response;
		do {
			displayMenu();
			System.out.print ("What do you want to do? ");
			try {
				answer= keybd.readLine().toUpperCase();
			} catch (Exception e)
				{response = 'A'; //something invalid
				}

			StringTokenizer st = new StringTokenizer(answer);
			response = st.nextToken().charAt(0);
			if (isValid(response)) {
				if (response != 'C' && response != 'R') 
					return response;
				int size = 0;
				try {
					size = Integer.parseInt(st.nextToken());
					if (response == 'C')
						numElements = size;
					else
						posRange = size;
					return response;
				} catch (Exception e) {
					System.out.println ("This command requires an integer parameter");
				}
			}
			System.out.println("Sorry, that wasn't a valid option.");
			System.out.println();
		} while (true);
	}

	private static boolean isValid(char c) {
		// determines if the char is a valid menu selection
		return c == 'G' || c == 'I' ||  c == 'S' || c == 'M' || c == 'C' || c == 'L' 
				|| c == 'K' || c == 'R' || c == 'Q';
	}
	
	private static void displayMenu () {
		// does menu display
		System.out.println ("Your options:");
		System.out.println ("  G: generate a new (unsorted) array based on current settings");
		System.out.println ("  C n: change size of array to n");
		System.out.println ("  R n: set range of array elements to extend to n");
		System.out.println ("  L: list the unsorted array");
		System.out.println ("  K: list the sorted array");		
		System.out.println ("  I: do an insertion sort.");
		System.out.println ("  S: do a selection sort.");		
		System.out.println ("  M: do a merge sort.");			
		System.out.println ("  Q: quit this program");
		System.out.println ("");
	}

	/* *********************************************************
	 *    Basic operations
	 * *********************************************************/

	private static void generateArray() {
	// remove any prior elements from the array
		for (int i = 0; i < numElements; i++) 
			unsorted[i] = rng.nextInt(posRange);
	}

	private static void copy() {
	// copies the unsorted array into the sorted array
		for (int i = 0; i < numElements; i++)
			sorted[i] = unsorted[i];
	}
		
	private static void showList(int[] a) {
	// displays the chosen array
		for (int i = 0; i < numElements; i++) {
			System.out.print(" " + a[i]);
			if (i % 10 == 9)
				System.out.println();
		}
	}
	

	private static void doInsertionSort() {
	// performs an insertion sort of the array sorted

		for (int i = 1; i < numElements; i++) {
		
			// insert sorted[i] into the array
			// sorted[0]..sorted[i-1] which is already sorted
			
			int saved = sorted[i];
			int pos = i;
			
			while ( pos > 0 && saved < sorted[pos-1] ) {
				sorted[pos] = sorted[pos-1];
				pos--;
			}
		
			sorted[pos] = saved;			
		}
	}

	
	private static void doSelectionSort() {
	// does a selection sort of the array
		for (int i = 0; i < numElements-1; i++) {

			int smallest = i;
			for (int j = i+1; j < numElements; j++) {
				if ( sorted[j] < sorted[smallest])
					smallest = j;
			}
			int tmp = sorted[i];
			sorted[i] = sorted[smallest];
			sorted[smallest] =tmp;
		}
	}

	
	private static void doMergeSort() {
	// does a merge sort
		mergeSort(sorted,0,numElements-1);
	}

    private static void mergeSort (int[] a, int low, int high) {
	// does a merge sort of the array a over the range from
	// low to high (inclusive)
		
		if (high <= low)
			return;
		if (low+1 == high) {
			if (a[low] > a[high]) {
				//swap
				int tmp = a[low];
				a[low] = a[high];
				a[high] = tmp;
			}	
			return;
		}
		
		// recursively sort each half
		int mid = (high+low)/2;
		mergeSort (a,low,mid); 
		mergeSort (a, mid+1, high);
		
		// merge the two halves into a temporary array
		int[] tmp = new int[1+high-low];
		int loPos = low, hiPos = mid+1, tmpPos = 0;
		
		while (loPos <= mid && hiPos <= high)
			if (a[loPos] < a[hiPos])
				tmp[tmpPos++] = a[loPos++];
			 else
				tmp[tmpPos++] = a[hiPos++];
			
		while (loPos <= mid)
			tmp[tmpPos++] = a[loPos++];
		while (hiPos <= high)
			tmp[tmpPos++] = a[hiPos++];
		
		// copy the temporary array back into a
		for (int i = low; i <= high; i++)
			a[i] = tmp [i-low];
	}
	
}



