/*
	Demonstration of method syntax
	
	I took the code from the previous class (loop demo 3)
	and modified it to show how I might have written the
	program had I assumed that I knew how to use methods
	in the first place.

	One important thing to notice is that the use of methods
	makes it much clearer what is being accomplished in the main
	program
	
	You might also notice that one can organize work into methods
	differently. Take note of the pair of cases 1 and 2 (or 5 and 6) which 
	did similar things but were organized into different types of methods
		
*/

public class Methods1 {

	public static final int SENTINEL = 0;

	public static TextInput keybrd = new TextInput();
	// doing this makes the variable keybrd known to all methods of this class
	

	public static void main(String args[]) {		
		System.out.println("Method Demo");
		int option = 9;
		
		do {
			option = getMenuOption (option);
						
			switch (option) {
			
			case 1: doSummingSentinel();
					break;
			case 2: int answer = getSummingContinue();
					System.out.println ("The sum is " + answer);		
					break;
					
			case 3: doMaxMinSentinel();
					break;
			case 4: doMaxMinContinue();
					break;
					
			case 5: TextInput fileReader1 = getFileReader("What is the file of strings?");
					String shortest = findShortestInFile (fileReader1);
					System.out.println ("The shortest line is " + shortest);											
					break;

			case 6: sumIntsInFile();
					break;
										
			case 7: playRPS();
					break;
					
			case 8: // quitting
					break;
			default:
					System.out.println ("Next time, pick a number between 1 and 8");
					option = 9;
			}
		} while (option != 8);
	}
	
	
	public static TextInput getFileReader (String prompt) {
	// This method continually prompts the typist for the name of a file
	// until a file name is entered that can be used as a source of input
	// A valid (for reading) TextInput object is returned.
		TextInput reader;
		do {
			System.out.print (prompt + " ");
			String name = keybrd.readLine();
			reader = new TextInput(name);
			if (!reader.isValidSource())
				System.out.println("Sorry, no such file found.");
		} while (!reader.isValidSource());
		return reader;	
	}
	
	
	public static int getMenuOption (int opt) {
	// This method gets the next menu option chosen by the typist. If the
	// initial value of opt is not a valid option, then the menu will be displayed.
	// The new option is returned
		if (opt > 8 || opt < 1) {
			System.out.println ("Menu of Options:");
			System.out.println ("1	run a summing loop with a sentinel");
			System.out.println ("2	run a summing loop with continue prompts");
			System.out.println ("3	run a max/min loop with a sentinel");
			System.out.println ("4	run a max/min loop with continue prompts");
			System.out.println ("5	read from a text file to find shortest line");
			System.out.println ("6	read from a text file of ints to find the sum");
			System.out.println ("7	play a game of Rock Paper Scissors");
			System.out.println ("8	Quit");
		}
		System.out.print ("Pick an option (from 1 to 8): ");
		opt = keybrd.readInt();
		return opt;
	}
	
	public static String getValidRPSGuess() {
	// this method asks the typist for an RPS guess until the
	// typist enters a valid string.
	// That string is returned
		boolean isValidGuess;
		String guess;
		do {
			System.out.print ("What is your guess? ");
			guess = keybrd.readLine();
			isValidGuess = guess.equalsIgnoreCase("rock") ||
							guess.equalsIgnoreCase("paper") ||
							guess.equalsIgnoreCase("scissors");
			if (!isValidGuess) {
				System.out.println("Sorry, that is an invalid guess");
				System.out.println ("You must type \"Rock\", \"Paper\", or \"Scissors\"");
			}
		} while (!isValidGuess);
		return guess;	
	}
	
	public static void playRPS () {
	// plays a game of Rock Paper Scissors
	// it gets a valid string from the typist but the computer
	// cheats and always picks a winner against the player
		String guess = getValidRPSGuess();
		System.out.println ("Sorry you lose.");
		System.out.print ("The computer picked ");
		if (guess.equalsIgnoreCase("rock"))
			System.out.println("paper");
		else if (guess.equalsIgnoreCase("paper"))
			System.out.println("scissors");
		else
			System.out.println("rock");
	}
	
	public static String findShortestInFile (TextInput src) {
	// This method finds the shortest string for the file corresponding to the
	// TextInput object src.
	// It is assume that src corresponds to a valid file of strings
	// The shortest string found in the file is returned.
		String least = src.readLine();
		System.out.println(least);

		while (!src.atEndOfFile()) {
			String next = src.readLine();
			System.out.println(next);
			if (next.length() < least.length())
				least = next;
		}
		return least;
	}

	public static void sumIntsInFile() {
	// This method asks the typist for a file of ints, reads that file of ints
	// determines the sum of all ints in the file and displays the result				
		TextInput reader = getFileReader("What is the file of ints?");
		int sum = 0;
		while (!reader.atEndOfFile()) {
			int num = reader.readInt();
			System.out.println ("adding " + num);
			sum += num;
		}
		System.out.println ("The sum is " + sum);	
	}
	
	public static void doSummingSentinel(){
	// This method is a demonstration of how to write a summing loop using input 
	// from the typist where the typist enters a sentinel value to stop
		int sum = 0;

		System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
		int num = keybrd.readInt();					
		
		while (num != SENTINEL) {
			sum += num;
			System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
			num = keybrd.readInt();					
		}
		System.out.println ("The sum is " + sum);
	}

	public static int getSummingContinue() {
	// This method is a demonstration of how to write a summing loop using input 
	// from the typist where the typist is continually asked whether there are more values
		int sum  = 0;
		boolean wantsToContinue = true;
		while ( wantsToContinue ) {
			System.out.print ("What is the next number ? ");
			int num = keybrd.readInt();	
			sum += num;
			System.out.print ("Are there more numbers? ");
			char response = keybrd.readChar();
			wantsToContinue = response == 'Y' || response == 'y';
		}
		return sum;
	}

	public static void doMaxMinSentinel() {
	// This method is a demonstration of how to write a max/min loop using input 
	// from the typist where the typist enters a sentinel value to stop	
		System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
		int num = keybrd.readInt();					
		if (num == SENTINEL) {
			System.out.println("There are no numbers to find largest or smallest");
			return;
		}
		int	smallestSeen = num,
			largestSeen = num;
			
		while (num != SENTINEL) {
			if (num < smallestSeen)
				smallestSeen = num;
			else if (num > largestSeen)
				largestSeen = num;
						
			System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
			num = keybrd.readInt();					
		}
		System.out.println ("The smallest number was " + smallestSeen);	
		System.out.println ("The largest number was " + largestSeen);		
	}

	public static void doMaxMinContinue() {
		System.out.print ("What is the first number ? ");
		int smallestFound = keybrd.readInt();

		int largestFound = smallestFound;
		
		boolean wantsToContinue = true;
		
		while ( wantsToContinue ) {
		
			System.out.print ("What is the next number ? ");
			int num = keybrd.readInt();	
			if (num < smallestFound)
				smallestFound = num;
			else if (num > largestFound)
				largestFound = num;
			
			System.out.print ("Are there more numbers? ");
			char response = keybrd.readChar();
			wantsToContinue = response == 'Y' || response == 'y';
		}
		System.out.println ("The smallest number was " + smallestFound);	
		System.out.println ("The largest number was " + largestFound);
	}	
}
