/*
	Third demonstration of iteration (looping)
	
	1) I've left in the code from the last ending point
	   and have added the new demos and additional
	   menu items
	   
	2) I've also enclosed the switch statement within a loop
	   so that more than one option can be done
	    
	3) Added options to:
	
	    a) read a file of strings
	    b) read a file of ints
	    (both versions have code to get a valid TextInput object)
	    c) play a game of Rock,Paper,Scissors
	
*/

public class LoopDemo3 {

	public static final int SENTINEL = 0;

	public static void main(String args[]) {

		TextInput keybrd = new TextInput();
		
		System.out.println("Loop Demo III");
		int option = 9;
		
		do {
		
			if (option > 8) {
				System.out.println ("Menu of Options:");
				System.out.println ("1	run a summing loop with a sentinel");
				System.out.println ("2	run a summing loop with continue prompts");
				System.out.println ("3	run a max/min loop with a sentinel");
				System.out.println ("4	run a max/min loop with continue prompts");
				System.out.println ("5	read from a text file to find shortest line");
				System.out.println ("6	read from a text file of ints to find the sum");
				System.out.println ("7	play a game of Rock Paper Scissors");
				System.out.println ("8	Quit");
			}
			System.out.print ("Pick an option (from 1 to 8): ");
			option = keybrd.readInt();
			
			
			switch (option) {
			
			case 1: // Summing via a sentinel
					int sum1 = 0;
			
					System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
					int num1 = keybrd.readInt();					
					
					while (num1 != SENTINEL) {
						sum1 += num1;
									
						System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
						num1 = keybrd.readInt();					
					}
					System.out.println ("The sum is " + sum1);
					break;


			case 2: // Summing via prompting to continue
					int sum2  = 0;
					boolean wantsToContinue = true;
			
					while ( wantsToContinue ) {
						System.out.print ("What is the next number ? ");
						int num = keybrd.readInt();	
						sum2 += num;
				
						System.out.print ("Are there more numbers? ");
						char response = keybrd.readChar();
						wantsToContinue = response == 'Y' || response == 'y';
					}
					System.out.println ("The sum is " + sum2);		
					break;
					
					
					
			case 3: // Finding max/min via sentinel

					System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
					int num3 = keybrd.readInt();					
					if (num3 == SENTINEL) {
						System.out.println("There are no numbers to find largest or smallest");
						break;
					}
					int	smallestSeen = num3,
						largestSeen = num3;
						
					while (num3 != SENTINEL) {
						if (num3 < smallestSeen)
							smallestSeen = num3;
						else if (num3 > largestSeen)
							largestSeen = num3;
									
						System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
						num3 = keybrd.readInt();					
					}
					System.out.println ("The smallest number was " + smallestSeen);	
					System.out.println ("The largest number was " + largestSeen);		
					break;
					
					
			case 4: // Finding max/min via prompting to continue
					System.out.print ("What is the first number ? ");
					int smallestFound = keybrd.readInt();

					int largestFound = smallestFound;
					
					wantsToContinue = true;
					
					while ( wantsToContinue ) {
					
						System.out.print ("What is the next number ? ");
						int num = keybrd.readInt();	
						if (num < smallestFound)
							smallestFound = num;
						else if (num > largestFound)
							largestFound = num;
						
						System.out.print ("Are there more numbers? ");
						char response = keybrd.readChar();
						wantsToContinue = response == 'Y' || response == 'y';
					}
					System.out.println ("The smallest number was " + smallestFound);	
					System.out.println ("The largest number was " + largestFound);	
					break;

			case 5: // reading from a file to find shortest string
					TextInput fileReader1;
					do {
						System.out.print ("What is the file ? ");
						String name1 = keybrd.readLine();
						fileReader1 = new TextInput(name1);
						if (!fileReader1.isValidSource())
							System.out.println("Sorry, no such file found.");
					} while (!fileReader1.isValidSource());
					
					String shortest = fileReader1.readLine();
					System.out.println(shortest);

					while (!fileReader1.atEndOfFile()) {
						String next = fileReader1.readLine();
						System.out.println(next);
						if (next.length() < shortest.length())
							shortest = next;
					}
					System.out.println ("The shortest line is " + shortest);	
										
					break;

			case 6: // reading from a file of ints to find sum
					System.out.print ("What is the file name ? ");
					String name2 = keybrd.readLine();
					TextInput fileReader2 = new TextInput(name2);
					while (!fileReader2.isValidSource()) {
						System.out.println("Sorry, no such file found.");
						System.out.println("Please try again.");
						System.out.print ("What is the file ? ");
						name2 = keybrd.readLine();
						fileReader2 = new TextInput(name2);
					}
					
					int sum = 0;
					while (!fileReader2.atEndOfFile()) {
						int num = fileReader2.readInt();
						System.out.println ("adding " + num);
						sum += num;
					}
					System.out.println ("The sum is " + sum);	
					break;
					
			case 7: // play a game of Rock Paper Scissors
					String guess;
					boolean isValidGuess;
					do {
						System.out.print ("What is your guess? ");
						guess = keybrd.readLine();
						isValidGuess = guess.equalsIgnoreCase("rock") ||
										guess.equalsIgnoreCase("paper") ||
										guess.equalsIgnoreCase("scissors");
						if (!isValidGuess) {
							System.out.println("Sorry, that is an invalid guess");
							System.out.println ("You must type \"Rock\", \"Paper\", or \"Scissors\"");
						}
					} while (!isValidGuess);
					// the computer cheats at the game !!!!
					System.out.println ("Sorry you lose.");
					System.out.print ("The computer picked ");
					if (guess.equalsIgnoreCase("rock"))
						System.out.println("paper");
					else if (guess.equalsIgnoreCase("paper"))
						System.out.println("scissors");
					else
						System.out.println("rock");
					break;
					
			case 8: // quitting
					break;
			default:
					System.out.println ("Next time, pick a number between 1 and 8");
					option = 9;
			}
		} while (option != 8);
	}
}
