/*
	Second demonstration of iteration (looping)
	
	1) I've included a menu and corresponding switch statement
	   to allow you to choose which of the four sample loops
	   to use
	   	
	2) we did two applications: 
	    a) summing
	    b) finding max & min
	    
	3) we took two approaches to getting looped input:
	    a) sentinels
	    b) asking to continue

	In class, we only did one approach to finding max & min
	
*/

public class LoopDemo2 {

	public static final int SENTINEL = 0;

	public static void main(String args[]) {

		TextInput keybrd = new TextInput();
		
		System.out.println("Loop Demo II");
		
		System.out.println ("Options:");
		System.out.println ("1	run a summing loop with a sentinel");
		System.out.println ("2	run a summing loop with continue prompts");
		System.out.println ("3	run a max/min loop with a sentinel");
		System.out.println ("4	run a max/min loop with continue prompts");
		
		System.out.print ("Pick from 1 to 4: ");
		int option = keybrd.readInt();
		
		
		switch (option) {
		
		case 1: // Summing via a sentinel
				int sum1 = 0;
		
				System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
				int num1 = keybrd.readInt();					
				
				while (num1 != SENTINEL) {
					sum1 += num1;
								
					System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
					num1 = keybrd.readInt();					
				}
				System.out.println ("The sum is " + sum1);
				break;


		case 2: // Summing via prompting to continue
				int sum2  = 0;
				boolean wantsToContinue = true;
		
				while ( wantsToContinue ) {
					System.out.print ("What is the next number ? ");
					int num = keybrd.readInt();	
					sum2 += num;
			
					System.out.print ("Are there more numbers? ");
					char response = keybrd.readChar();
					wantsToContinue = response == 'Y' || response == 'y';
				}
				System.out.println ("The sum is " + sum2);		
				break;
				
				
				
		case 3: // Finding max/min via sentinel

				System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
				int num3 = keybrd.readInt();					
				if (num3 == SENTINEL) {
					System.out.println("There are no numbers to find largest or smallest");
					break;
				}
				int	smallestSeen = num3,
					largestSeen = num3;
					
				while (num3 != SENTINEL) {
					if (num3 < smallestSeen)
						smallestSeen = num3;
					else if (num3 > largestSeen)
						largestSeen = num3;
								
					System.out.print ("What is the next number (use " + SENTINEL + " to stop) ? ");
					num3 = keybrd.readInt();					
				}
				System.out.println ("The smallest number was " + smallestSeen);	
				System.out.println ("The largest number was " + largestSeen);		
				break;
				
				
		case 4: // Finding max/min via prompting to continue
				System.out.print ("What is the first number ? ");
				int smallestFound = keybrd.readInt();

				int largestFound = smallestFound;
				
				wantsToContinue = true;
				
				while ( wantsToContinue ) {
				
					System.out.print ("What is the next number ? ");
					int num = keybrd.readInt();	
					if (num < smallestFound)
						smallestFound = num;
					else if (num > largestFound)
						largestFound = num;
					
					System.out.print ("Are there more numbers? ");
					char response = keybrd.readChar();
					wantsToContinue = response == 'Y' || response == 'y';
				}
				System.out.println ("The smallest number was " + smallestFound);	
				System.out.println ("The largest number was " + largestFound);	
				break;
		default:
				System.out.println ("Next time, pick a number between 1 and 4");		
		}
	}
}
