/*
	First demonstration of iteration (looping)
	
	1) syntax vs. semantics of the while loop
	
	2) a counting loop pattern
	
	3) a summing loop pattern
	
*/

public class LoopDemo1 {

	public static final int DEFAULT_RANGE = 10,
							DEFAULT_STEP = 1;

	public static void main(String args[]) {

		TextInput keybrd = new TextInput();
		
		System.out.println("Loop Demo I");
		
		/*
			Syntax for a while loop:
		
				while ( boolean_test ) {
					loop_body
				}
		
			Although a loop has only two syntactic parts, there
			are four things to balance when trying to write
			a semantically correct loop
			
			1) initializing (or setting up) the loop
			      Are the pre-conditions for the loop appropriate?
			      
		    2) boolean test for continuation
		    	  Will the loop terminate (i.e., will the test stop
		    	  being true) exactly when you want it to stop
		    	  
		    3) the bulk of the loop body 
		          What belongs here depends upon your goal.
		          
		    4) changing something about the boolean test 
		          If the boolean test condition is not modified,
		          you'll be in an infinite loop
		*/


		/*
			The counting loop pattern
		*/
		
		System.out.print ("Do you wish to run the counting loop? ");
		char response = keybrd.readChar();
		
		if (response == 'Y' || response == 'y') {
		
			// in class, we set up arbitrary conditions
			// but here, we'll get them via input
			System.out.print ("What is the inclusive minimum of the range? ");
			int min = keybrd.readInt();
			
			System.out.print ("What is the inclusive maximum of the range? ");
			int max = keybrd.readInt();
			
			if (max < min) {
				System.out.println("Your maximum must be at least as large as your mininum");
				max = min + DEFAULT_RANGE;
				System.out.println("Arbitrarily setting your maximum to " + max);
			}
			
			System.out.print ("By what number do you wish to count? ");
			int step = keybrd.readInt();
			if (step <= 0) {
				System.out.println("You must step from min to max by a positive int");
				step = DEFAULT_STEP;
				System.out.println("Arbitrarily setting your step to " + step);
			}
			
			
			// Finally, the loop itself
			
			int counter = min;
			
			while (counter <= max) {
			
				System.out.println("counter = " + counter);
								
				counter = counter + step;
			}

			System.out.println("Finished with counter = " + counter);
			System.out.println();		
		}
		
		/*
			Second loop pattern
		*/
		
		System.out.print ("Do you wish to run the summing loop? ");
		response = keybrd.readChar();
		
		if (response == 'Y' || response == 'y') {
			
			System.out.print ("What is the number that you wish to sum to? ");
			int max = keybrd.readInt();
			
			if (max < 0) {
				System.out.println("Your maximum must be non-negative");
				max = Math.abs(max);
				System.out.println("Arbitrarily setting your maximum to " + max);
			}
			


			// And now, the loop (& its initialization conditions)
			
			int counter = 1;
			int sum = 0;
			 
			while (counter <= max) {

				// we can use += to shorten incrementing
				//sum = sum + counter;
				sum += counter;
			
				//counter = counter + 1;
				//counter += 1;
				//incrementing by 1 can be made even shorter
				counter++;
			}
			
			
			System.out.println("The sum of all pos ints up to " + max + " inclusive is " + sum);
		}
	}
}
