/*
	This is a demonstration of the basics of doing
	true input and output (without relying on TextInput).
	
	For the second day, we've made the methods more robust
	by having try-catches wherever an exception might be raised.
	
	
	Shown here are three approaches to using try-catch
	
	a) (in main) one big try-catch: casting a wide net can be dangerous however.
	   If any exception occurs while debugging, the one exception handler deals with
	   all problems. You don't get information about which statement causes
	   the exception

	b) (in getOutputStream) a new try-catch for every statement that might generate
	   an exception. This approach involves the most code but it also the safest
	   to write for new programmers
	

	c) (in getInputStream) fewer try-catches but with multiple exception handlers.
	   This more sophisticated approach requires greater understanding of exceptions
	   since one has to be aware of which exception might be generated for each statement. Further,
	   One also has to be aware of the relationships between exceptions. The more
	   specific exceptions must be handled first.
	   
*/

import java.io.*;
public class InputOutputDemo {

	public static BufferedReader kb = new BufferedReader (
									 			new InputStreamReader(System.in) );


	
	public static void main(String args[])  {
			
		try {
		
			PrintStream outStream = getOutputStream ("What is the file to write to? ");
					
			System.out.println("Enter text to be written to a file");
			System.out.println("Enter a blank line to quit.");
				
			String nextLine = kb.readLine();
			while (nextLine.length() > 0 ) {
			
				outStream.println (nextLine);
				nextLine = kb.readLine();
			}
			outStream.close();
			
			
			BufferedReader br = getInputStream ("What file would you like to read? ");
			System.out.println("Here it is:");
			
			nextLine = br.readLine();
			
			while (nextLine != null) { // Once at the end of file, readLine returns null
				System.out.println(nextLine);
				nextLine = br.readLine();
			}
		
		} 
		catch (Exception e) {
			System.out.println("An exception occurred: " + e);
		}
	}

	public static PrintStream getOutputStream (String prompt) {
	// prompts the user for a file to be used for output. The method
	// creates a PrintStream object (that is returned) that can write
	// to the file
		FileOutputStream fos = null;
	
		do {

			System.out.print(prompt);
			String fileName = null;

			try {
				fileName = kb.readLine();
			}
			catch (IOException e) {
				System.out.println (e);
			}
			
			File theFile = new File (fileName);
					
			try {
				fos = new FileOutputStream (theFile);
			}
			catch (FileNotFoundException e) {
				System.out.println("Sorry, you do not have permission to write to this file");
			}
		
		} while (fos == null);
				
		return new PrintStream(fos);
	}


	public static BufferedReader getInputStream (String prompt) {
	// prompts the user for a file to be used for input. The method
	// creates a BufferedReader object (that is returned) that can read
	// from the file

		FileInputStream fis = null;
	
		do {
			System.out.print(prompt);
			
			try {
				String fileName = kb.readLine(); // can generate IOException
				File theFile = new File (fileName);
				fis = new FileInputStream (theFile); // can generate FileNotFoundException
			}
			catch (FileNotFoundException e) { // this exception is also an IOException
				System.out.println("Sorry, the file you requested doesn't exist or can't be read");
			} 
			catch (IOException e) {
				System.out.println("I'm surprised that this exception occurred.");
			}
			
		} while (fis == null);
				
		return new BufferedReader(new InputStreamReader (fis));
	}

}
