/*
	This is a demonstration of the basics of doing
	true input and output (without relying on TextInput).
	
	At this stage, our program is not robust because we have
	side-stepped the issue of exceptions by adding throws 
	clauses to all of our methods.
	
*/

import java.io.*;
public class InputOutputDemo {

	// First, we construct a keyboard object

	public static BufferedReader kb = new BufferedReader (
									 			new InputStreamReader(System.in) );


	// to avoid addressing exceptions today, we add "throws IOException to
	// every method that we write
	
	public static void main(String args[]) throws IOException {
			
		PrintStream outStream = getOutputStream ("What is the file to write to? ");
				
		System.out.println("Enter text to be written to a file");
		System.out.println("Enter a blank line to quit.");
			
		String nextLine = kb.readLine();
		while (nextLine.length() > 0 ) {
		
			outStream.println (nextLine);
			nextLine = kb.readLine();
		}
		outStream.close();
		
		BufferedReader br = getInputStream ("What file would you like to read? ");
		System.out.println("Here it is:");
		
		nextLine = br.readLine();
		
		while (nextLine != null) { // Once at the end of file, readLine returns null
			System.out.println(nextLine);
			nextLine = br.readLine();
		}
	}

	public static PrintStream getOutputStream (String prompt) throws IOException {
	// prompts the user for a file to be used for output. The method
	// creates a PrintStream object (that is returned) that can write
	// to the file
		System.out.print(prompt);
		String fileName = kb.readLine();
		
		File theFile = new File (fileName); // associates the name with a file
	
		FileOutputStream fos = new FileOutputStream (theFile); //attempts to create
		// a low-level output stream (of bytes) with the file as the destination
		
		PrintStream os = new PrintStream(fos); //creates a high-level
		// output stream (of Strings)
		
		return os;
	}


	public static BufferedReader getInputStream (String prompt) throws IOException {
	// prompts the user for a file to be used for input. The method
	// creates a BufferedReader object (that is returned) that can read
	// from the file
		System.out.print(prompt);
		String fileName = kb.readLine();
		
		File theFile = new File (fileName); // associates the name with a file
	
		FileInputStream fis = new FileInputStream (theFile); //attempts to create
		// a low-level input stream (of bytes) with the file as the source
		
		InputStreamReader isr = new InputStreamReader (fis); // creates an intermediate
		// level input stream (of chars) fashioned from the low-level byte stream
		
		
		return new BufferedReader(isr);
		// returns a high-level input stream (of Strings);
	}

}
