/*
	A demonstration of the basic functionality of the
	class TextInput which simplifies the process of
	obtaining input of Strings and of primitive types
	
	Not all sections arrived at the same ending point;
	this is a compromise version. We went further in some
	sections but not as far in others.
	
*/

public class InputDemo {

	public static void main(String args[]) {
		
		TextInput keyboard = new TextInput ( );
		// This first declares the variable keyboard to be of type TextInput
		// The variable is then assigned a new object of that type.
		// The reserved word new tells the compiler to create/initialize
		// the new object
		// There is code within the class TextInput that tells the compiler
		//  how to initialize the object
		
		// With this variable defined, we can use the variable to read
		// information from the keyboard
		

		// Every attempt to get input should be preceded by a "prompt"
		// like the one below. Using print (not println) and having a
		// space following the text makes it easier for the typist to read

		System.out.print ("Please enter an integer: " );

		int answer = keyboard.readInt();
	
		// The method readInt interprets what was typed as an int
		// if the value typed is not truly an int, then the value
		// for the answer ends up being Integer.MIN_VALUE
	
		System.out.println ("You typed : " + answer);
	
	
		System.out.print ("Please enter a double: " );
		double answer2 = keyboard.readDouble();
		System.out.println ("You typed : " + answer2);	
		// The method readDouble interprets what was typed as a double
		// if the value typed cannot be so represented, then the value
		// for the answer ends up being NaN
	
	
				
		System.out.print ("What is your first name? ");
		String firstName = keyboard.readLine();	
		// The method readLine gets the String that was typed; all
		// input can be interpreted as a string
	
		
		System.out.print ("What is your middle initial? ");
		char middleInit = keyboard.readChar();	
		// The method readChar gets the first character from the string
		// that was typed; any remaining characters are ignored.
		
		
		System.out.println("Hello, " + firstName + ' ' + middleInit + '.');	
		

	}
}
