/*
	An applet that plays a guessing game
	
	Currently, only the layout of the game
	is available
	
	Written by Jeff Carroll 11/26/04
*/

import java.awt.*;
import java.applet.Applet;

public class GuessingGameApplet extends Applet
{

	public static final int GAME_ROWS = 5,
							GAME_COLS = 6,
							NUM_TOKENS = 5;
	
	private GuessingGame g = new GuessingGame(GAME_ROWS,GAME_COLS,NUM_TOKENS);

	private	Button [][] buttonMatrix = new Button[GAME_ROWS][GAME_COLS];
	private Button newGame = new Button("New Game");
	private Label[] rowCounts = new Label[GAME_ROWS];
 	private	Label[] colCounts = new Label[GAME_COLS];
	private Label score, starsLeft;
	
	public void init() {
	
		Panel gamePanel = new Panel();
		gamePanel.setLayout(new GridLayout(GAME_ROWS+1,GAME_COLS+1));

		for (int r = 0; r < GAME_ROWS; r++) {
		
			for (int c = 0; c < GAME_COLS; c++) {
				buttonMatrix[r][c] = new Button(" " + g.get(r,c,false)+ " ");
				gamePanel.add(buttonMatrix[r][c]);
			}
						
			rowCounts[r] = new Label(" " + g.countRow(r)+ " ");
			gamePanel.add(rowCounts[r]);
			
		}
		for (int c = 0; c < GAME_COLS; c++) {
			colCounts[c] = new Label(""+g.countCol(c),Label.CENTER);
			gamePanel.add(colCounts[c]);
		}
				
		Panel scorePanel = new Panel();
		scorePanel.add(new Label ("Current Score: "));
		score = new Label("  "+g.getScore()+" ");
		scorePanel.add(score);
		scorePanel.add(new Label ("   Stars to Find: "));
		starsLeft = new Label(" " + g.getMissing());
		scorePanel.add(starsLeft);
		setLayout(new BorderLayout());
		add (scorePanel, BorderLayout.NORTH);
		add (gamePanel, BorderLayout.CENTER);

		// trick to get game off of the edge of the applet
		add (new Label("   "),BorderLayout.WEST);
		
		Panel agp = new Panel();
		agp.add(newGame);
		add (agp,BorderLayout.SOUTH);
	}
	


}
