/*
	This is the GuessingGame class 
	
	Updated for GUI usage 11/26/04
*/

import java.util.*;
public class GuessingGame {

	private final static char HIDDEN_SPACE = '?',
							  FOUND_SPACE = ' ',
							  FOUND_TOKEN = '*',
							  HIDDEN_TOKEN = '%';

	private Random rng = new Random();

	// instance variables
	private char[][] game;
	private int numRows, numCols, numTokens;
	private int score = 0;
	private int hidden;
	
	// Constructor
	public GuessingGame (int row, int col, int tokens) {
		numRows = row;
		numCols = col;
		numTokens = tokens;
		hidden = tokens;
		
		game = new char[numRows][numCols];
		
		// initialize the game board to all hidden spaces
		for (int r = 0; r < numRows; r++)
			for (int c = 0; c < numCols; c++)
				game[r][c] = HIDDEN_SPACE;
	
		// randomly insert numTokens many hidden tokens
		int count = 0;
		while (count < numTokens) {
			int randR = rng.nextInt(numRows);
			int randC = rng.nextInt(numCols);
			if (game[randR][randC] != HIDDEN_TOKEN) {
				game[randR][randC] = HIDDEN_TOKEN;
				count++;
			}
		}	
	}


	// Assessors
	public String display() {
		// displays state of game (not needed for GUI version)
		return "stub";
	}
	
	public int getScore () {
		return score;
	}
	
	public int getMissing() {
	// returns the number of tokens that are still hidden
		return hidden;
	}
	
	
	// Mutators
	public boolean makeGuess(int r, int c) {
	// the player's guess of row and col (r & c) are assumed to represent
	// a valid gameboard location.
	// The method returns true if and only if a new token is found.
	// If a new token is not found the score is increased
		if (game[r][c] == HIDDEN_TOKEN) {
			game[r][c] = FOUND_TOKEN;
			hidden--;
			return true;
		}
		score++;
		if (game[r][c] == HIDDEN_SPACE)
			game[r][c] = FOUND_SPACE;
		return false;
	}
	
	
	public int countRow(int theRow) {
	// counts the number of tokens on the particular row
		if (theRow < 0 || theRow > numRows)
			return 0;
		int count = 0;
		for (int c = 0; c < numCols; c++)
			if (game[theRow][c] == HIDDEN_TOKEN || game[theRow][c] == FOUND_TOKEN)
				count++;
		return count;
	}
	
	public int countCol(int theCol) {
	// counts the number of tokens on the particular col
		if (theCol < 0 || theCol > numCols)
			return 0;
		int count = 0;
		for (int r = 0; r < numRows; r++)
			if (game[r][theCol] == HIDDEN_TOKEN || game[r][theCol] == FOUND_TOKEN)
				count++;
		return count;
	}

	public char get (int r, int c, boolean showHidden) {
	// returns the character value of the game at <r,c>.
	// if <r,c> is invalid, only ' ' is returned
	// if showHidden is true, only ' ' & '*' will be returned
	// if showHidden is false, '?', ' ' & '*' will be returned
	
		if (r < 0 || r > numRows || c < 0 || c > numCols)
			return FOUND_SPACE;
		char theChar = game[r][c];
		if (showHidden) {
			if (theChar == HIDDEN_TOKEN)
				theChar = FOUND_TOKEN;
			else if (theChar == HIDDEN_SPACE)
				theChar = FOUND_SPACE;
		}
		else if (theChar == HIDDEN_TOKEN)
				theChar = HIDDEN_SPACE;
		return theChar;
	}		
}