/*
	An applet that plays a guessing game
		
	Layout written by Jeff Carroll 11/26/04

	Event handling written by Jeff Carroll 12/1/04

*/

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;
import java.util.*;

public class GuessingGameApplet extends Applet implements ActionListener
{

	public static final int GAME_ROWS = 5,
							GAME_COLS = 6,
							NUM_TOKENS = 5;
							
	public static final String NEW_GAME = " Another game? ",
							    GIVE_UP = "    Quit?    ";
	
	private GuessingGame g = new GuessingGame(GAME_ROWS,GAME_COLS,NUM_TOKENS);

	private	Button [][] buttonMatrix = new Button[GAME_ROWS][GAME_COLS];
	private Button newGame = new Button(GIVE_UP);
	private Label[] rowCounts = new Label[GAME_ROWS];
 	private	Label[] colCounts = new Label[GAME_COLS];
	private Label score, starsLeft;
	
	public void init() {
	
		Panel gamePanel = new Panel();
		gamePanel.setLayout(new GridLayout(GAME_ROWS+1,GAME_COLS+1));

		for (int r = 0; r < GAME_ROWS; r++) {
		
			for (int c = 0; c < GAME_COLS; c++) {
				buttonMatrix[r][c] = new Button(" " + g.get(r,c,false)+ " ");
				gamePanel.add(buttonMatrix[r][c]);
				buttonMatrix[r][c].addActionListener(this);
				buttonMatrix[r][c].setActionCommand(r+","+c);

			}
						
			rowCounts[r] = new Label(" " + g.countRow(r)+ " ");
			gamePanel.add(rowCounts[r]);
			
		}
		for (int c = 0; c < GAME_COLS; c++) {
			colCounts[c] = new Label(""+g.countCol(c),Label.CENTER);
			gamePanel.add(colCounts[c]);
		}
				
		Panel scorePanel = new Panel();
		scorePanel.add(new Label ("Current Score: "));
		score = new Label("  "+g.getScore()+" ");
		scorePanel.add(score);
		scorePanel.add(new Label ("   Stars to Find: "));
		starsLeft = new Label(" " + g.getMissing());
		scorePanel.add(starsLeft);
		setLayout(new BorderLayout());
		add (scorePanel, BorderLayout.NORTH);
		add (gamePanel, BorderLayout.CENTER);

		// trick to get game off of the edge of the applet
		add (new Label("   "),BorderLayout.WEST);
		
		Panel agp = new Panel();
		newGame.addActionListener(this);
		agp.add(newGame);
		add (agp,BorderLayout.SOUTH);
	}
	
	public void actionPerformed(ActionEvent e) {
	// this method must be provided in order to implement the interface ActionListener
	// (and to have this class be thought of (polymorphically) as an ActionListener
	
		String command = e.getActionCommand();
		if (command.equals(GIVE_UP)) {
			// show the answer
			for (int r = 0; r < GAME_ROWS; r++) {
				for (int c = 0; c < GAME_COLS; c++) 
					buttonMatrix[r][c].setLabel(" " + g.get(r,c,true)+ " ");						
				rowCounts[r].setText(" " + g.countRow(r)+ " ");		
			}			
			newGame.setLabel(NEW_GAME);
		}
		else if (command.equals(NEW_GAME)) {
		
			// set up a new game
			g = new GuessingGame(GAME_ROWS,GAME_COLS,NUM_TOKENS);
			for (int r = 0; r < GAME_ROWS; r++) {
				for (int c = 0; c < GAME_COLS; c++) 
					buttonMatrix[r][c].setLabel(" " + g.get(r,c,false)+ " ");						
				rowCounts[r].setText(" " + g.countRow(r)+ " ");		
			}
			for (int c = 0; c < GAME_COLS; c++) 
				colCounts[c].setText(""+g.countCol(c));			
			newGame.setLabel(GIVE_UP);		
		
		}	
		else {
		
			// the user is playing the game
			StringTokenizer st = new StringTokenizer(command,",");
			int r = Integer.parseInt(st.nextToken());
			int c = Integer.parseInt(st.nextToken());
			// the button pressed was <r,c>
			// so the graphics input is determined
			g.makeGuess(r,c);
			
			// refresh the parts of the game that change
			buttonMatrix[r][c].setLabel(" " + g.get(r,c,false)+ " ");
			rowCounts[r].setText(" " + g.countRow(r));
			colCounts[c].setText(" " + g.countCol(c));
			score.setText("  "+g.getScore()+" ");
			starsLeft.setText("  "+g.getMissing()+" ");
			
			if (g.getMissing()==0) { // the game is over				
				newGame.setLabel(NEW_GAME);
			}
		}
	}
}
