/*
	A method-based program built from a design that ended up being something like
	
		1) create the answer
		2) get the guess
		3) compare the guess to the answer
		4) if not correct, go back to step 2
	
	
	The following improvements were made upon what was done in class
	
	a) getGuess makes certain the guess is valid
	b) createAnswer produces an appropriate random value when LOWEST doesn't happen to be zero
	c) a score is maintained
	
*/

import java.util.*;

// or one could be more specific with
// import java.util.Random;

public class GuessingGame {

	public static final int LOWEST = -500, 
							HIGHEST = 500;

	public static TextInput kb = new TextInput();
	// We make kb a class-level variable because most of the time, 
	// most methods need to use it.
	// In general, however, you want to keep the majority of the variables
	// local to the method that uses it. Class-level variables have the potential
	// to introduce unintentional mistakes (called side effects) and their
	// overuse can make the program harder to understand
	
	
	
	public static void main(String args[]) {
	// This corresponds to the general outline for the program
	
		// create the answer	
		int answer = createAnswer();
		int numGuesses = 0;
		
		String result;
		
		do {
			// get the guess
			int guess = getGuess();
			numGuesses++;	
			// compare the answer to the guess
			result = examineGuess(guess, answer);
			System.out.println ("Your guess was " + result);
		
		} while ( !result.equals("correct") );
		System.out.println("It took you " + numGuesses + " guesses to find the answer");
	}
	
	public static int createAnswer () {
	// This method returns a random number in the range of LOWEST to HIGHEST
	// inclusive
		Random rng = new Random();
		
		return LOWEST + rng.nextInt(HIGHEST+1 - LOWEST);
		
		//in class, we used
		// return rng.nextInt(HIGHEST+1);
		// but that answer assumes that LOWEST = 0;
		// the solution here is the correct adjustment to an arbitrary (inclusive) range of
		// values
	}
	
	public static int getGuess() {
	// This method returns a player's valid guess (i.e., a guess between LOWEST & HIGHEST
	
		System.out.print ("Enter your guess (between " + LOWEST + " and " + HIGHEST + " inclusive): ");
		int g = kb.readInt();
		while (g<LOWEST || g >HIGHEST) {
			System.out.println("Sorry, that is not a valid guess");
			System.out.print ("Enter your guess betwen " + LOWEST + " and " + HIGHEST + ": ");
			g = kb.readInt();			
		}
		return g;
	}
	
	public static String examineGuess (int g, int ans) {
	// This method returns a value of "low" , "high", or "correct" based upon the
	// comparison of the player's guess (g) and the computer's answer (ans).
		if (g < ans)
			return "low";
		if (g > ans)
			return "high";
		return "correct";
	//Note: The else's are unnecessary because the action performed when true is
	//to exit the method (via return).	
		
	}
	
}
