/*
	An expansion on conditionals
	  a) boolean expressions with char
	  b) boolean expressions with String
	  c) short-circuit evaluation
	
*/

public class ConditionalDemo3 {

	// A constant String representing the password
	public static final String PASSWORD = "Shazam";


	public static void main(String args[]) {
		
		TextInput keyboard = new TextInput ( );

		boolean isValidPassword = false;
		// a boolean variable can be used to store the outcome of a test
		// so that the outcome can be remembered instead of requiring that
		// the test is repeated
		// It is natural to give this a default value of false because
		// we have not yet determined that the password is valid


		System.out.print ("Do you wish to run the password demo (Y or N)? ");
		char response = keyboard.readChar();	
		// when dealing with char, we us == (because char is a primitive type)
		// However, with char, the issue of case must always be addressed

		if (response == 'y' || response == 'Y') {



			// A Demo on Passwords (in reality, an example with testing String equality)
							
			System.out.print ("Please enter the password: ");
			String passwdGuess = keyboard.readLine();
			
			//
			
			
			isValidPassword = passwdGuess.equals(PASSWORD);
			
			// The following would be reasonable in some settings:
			// isValidPassword = passwdGuess.equalsIgnoreCase(PASSWORD);
							
			
			// However the following doesn't work
			//isValidPassword = (passwdGuess == PASSWORD);
			
			// == is only natural for primitive types (ints, doubles, char)
			// With object types, == is only true if the references are
			// equal (which mean that both sides refer to the very same object)
			// To test if two different objects have the same content, we
			// must use the "equals" method
				
			
			if (isValidPassword) 
				System.out.println("Welcome");
			else
				System.out.println("Sorry, that password was incorrect.");
			
	
		} else
			// User passed on test 1; 
			System.out.println("You skipped the password section (bad idea)");


		if (isValidPassword) {
			System.out.println("Running the lazy evaluation test");
			
			int a = 5, b = 0;
			
			// The following conditional crashes the program
			// because this test tells you to divide a by zero causing a run-time error

			// if (a / b > 1) 
			//		System.out.println("Hi");
			
			if (b != 0 && a / b > 1)
				System.out.println("Hi");
			else
				System.out.println("Bye");
			// because of lazy evaluation, the compiler doesn't attempt to divide by zero
			// Why? 
			// Well, since b is zero, "b != 0" is false; if the first clause of the "and"
			// is false, the whole expression must be false so the compiler, being "lazy",
			// doesn't bother to execute the second test - and division by zero is avoided.
			
		}
		
	}
}
