/*
	An expansion on conditionals
	  a) using complex boolean expressions
	  b) finding better ways to write condtionsals

	Also, using constants
	
*/

public class ConditionalDemo2 {

	// A constant representing a perfect score
	public static final int MAX_SCORE = 50;
	
	// the reserved word "final" indicates that the
	// value cannot be changed after being initialized.
	// It is therefore constant
	// Java style dictates that constants should be
	// written in all caps with underscores separating words
	
	// Constants representing threshold grades
	public static final double MIN_A = 0.86 * MAX_SCORE,
							   MIN_B = 0.72 * MAX_SCORE,
							   MIN_C = 0.6 * MAX_SCORE,
							   MIN_D = 0.5 * MAX_SCORE;
	// the above usage is preferrable to using a constant
	// like PERCENTAGE_FOR_MINIMUM_A which would entail 
	// having to do the arithmetic within the program


	public static void main(String args[]) {
		
		TextInput keyboard = new TextInput ( );

		System.out.print ("Please enter a test score: ");
		int score = keyboard.readInt();
		char grade = '?';
		
		System.out.println ("Your score is " + score );
		
		if (score > MAX_SCORE || score < 0) {
			// the score is invalid
			System.out.println ("Sorry, this score is invalid");
			System.out.println ("Please run the program again with a number between 0 and "
								 + MAX_SCORE);
						
		} else { // the score is valid

			// Initially, grade was defined here
			//char grade = '?';

			// When defined here, the scope of the variable 
			// grade runs from the first left brace above 
			// the declaration of the variable down to 
			// its corresponding right brace. Consequently,
			// it would not be defined after the conditional
			
			
			// In class, I presented three different ways to 
			// write the next conditional. 
			
			// This one is being used because it is the cleanest
			// solution: involves the least amount of computation
			// and it is not redundant
								
			if ( score >= MIN_A ) // had been (score >= 90)
				grade = 'A';
			else if ( score >= MIN_B)
				grade = 'B';
			else if (score >= MIN_C)
				grade = 'C';
			else if (score >= MIN_D)
				grade = 'D';
			else
				grade = 'F';


		}
		
		System.out.println ("Your grade is " + grade);		
		
	}
}
