/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class TextInput {
    private BufferedReader textReader;
    private String fileName;
    private boolean isValid;

    public TextInput() {
        this.textReader = new BufferedReader(new InputStreamReader(System.in));
        this.fileName = "KeyBoard";
        this.isValid = true;
    }

    public TextInput(String fileName) {
        this.fileName = fileName;
        File f = new File(fileName);
        try {
            FileInputStream fis = new FileInputStream(f);
            this.textReader = new BufferedReader(new InputStreamReader(fis));
            this.isValid = true;
        }
        catch (IOException iOException) {
            this.isValid = false;
            System.out.println("TextInput object creation error:\n   the file \"" + fileName + "\" does not exist or cannot be read from." + "\n   Attempts to use this TextInput object" + " will not produce valid results.");
        }
    }

    public boolean isValidSource() {
        return this.isValid;
    }

    public boolean atEndOfFile() {
        if (!this.isValid) {
            return true;
        }
        try {
            return this.textReader.ready() ^ true;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public String readLine() {
        if (!this.isValid) {
            System.out.println("The file '" + this.fileName + "' cannot be read.");
            return null;
        }
        try {
            return this.textReader.readLine();
        }
        catch (Exception exception) {
            if (!this.isValid) {
                System.out.println("ERROR discovered by TextInput>> The source text " + this.fileName + "is invalid");
            }
            return null;
        }
    }

    public char readChar() {
        try {
            return this.readLine().charAt(0);
        }
        catch (Exception exception) {
            System.out.println("INPUT ERROR discovered by TextInput>> A char was expected.");
            System.out.println("                                      the char'\u0000' will be used");
            return '\u0000';
        }
    }

    public double readDouble() {
        try {
            return Double.parseDouble(this.readLine());
        }
        catch (Exception exception) {
            System.out.println("INPUT ERROR discovered by TextInput>> A double was expected.");
            System.out.println("                                      the double NaN will be used");
            return Double.NaN;
        }
    }

    public int readInt() {
        try {
            return Integer.parseInt(this.readLine());
        }
        catch (Exception exception) {
            System.out.println("INPUT ERROR discovered by TextInput>> An int was expected.");
            System.out.println("                                      the int -2147483648 will be used");
            return Integer.MIN_VALUE;
        }
    }

    public long readLong() {
        try {
            return Long.parseLong(this.readLine());
        }
        catch (Exception exception) {
            System.out.println("INPUT ERROR discovered by TextInput>> A long was expected.");
            System.out.println("                                      the long -9223372036854775808 will be used");
            return Long.MIN_VALUE;
        }
    }

    public short readShort() {
        try {
            return Short.parseShort(this.readLine());
        }
        catch (Exception exception) {
            System.out.println("INPUT ERROR discovered by TextInput>> A short was expected.");
            System.out.println("                                      the short -32768 will be used");
            return Short.MIN_VALUE;
        }
    }

    public byte readByte() {
        try {
            return Byte.parseByte(this.readLine());
        }
        catch (Exception exception) {
            System.out.println("INPUT ERROR discovered by TextInput>> A byte was expected.");
            System.out.println("                                      the byte -128 will be used");
            return -128;
        }
    }

    public float readFloat() {
        try {
            return Float.parseFloat(this.readLine());
        }
        catch (Exception exception) {
            System.out.println("INPUT ERROR discovered by TextInput>> A float was expected.");
            System.out.println("                                      the float NaN will be used");
            return Float.NaN;
        }
    }

    public boolean readBoolean() {
        try {
            return this.readLine().equalsIgnoreCase("true");
        }
        catch (Exception exception) {
            System.out.println("INPUT ERROR discovered by TextInput>> A boolean was expected.");
            System.out.println("                                      the boolean false will be used");
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println("This program demonstrates how the class TextInput works.");
        System.out.println();
        System.out.println("First demonstrating basic keyboard input:");
        System.out.println();
        TextInput kb = new TextInput();
        System.out.print("Please enter an int ");
        int theIntYouTyped = kb.readInt();
        System.out.println("The int that you typed: " + theIntYouTyped);
        System.out.println();
        System.out.print("Please enter another int ");
        double theDoubleYouTyped = kb.readInt();
        System.out.println("The int that you typed: " + theDoubleYouTyped);
        System.out.println("Any integer is also a double");
        System.out.println();
        System.out.print("Please enter a double this time (with a decimal point ");
        theDoubleYouTyped = kb.readDouble();
        System.out.println("The double that you typed: " + theDoubleYouTyped);
        System.out.println();
        System.out.print("Please enter a double again ");
        theIntYouTyped = kb.readInt();
        System.out.println("The program tried to read this as an int");
        System.out.println("The int received: " + theIntYouTyped);
        System.out.println("Whenever the typist uses a decimal point, you can't use an int");
        System.out.println();
        System.out.print("Please enter an int with exactly 12 digits ");
        theIntYouTyped = kb.readInt();
        System.out.println("The program tried to read this as an int");
        System.out.println("The int received: " + theIntYouTyped);
        System.out.println("There is a maximum int: 2147483647");
        System.out.println("The number you typed couldn't be stored as an int");
        System.out.println("The 'long' type is used for bigger integers");
        System.out.println();
        System.out.print("Please enter an long with at least 18 digits ");
        long theLongYouTyped = kb.readLong();
        System.out.println("The long that you typed: " + theLongYouTyped);
        System.out.println("There is a maximum long though: 9223372036854775807");
        System.out.println();
        System.out.print("Please the same long with at least 18 digits ");
        theDoubleYouTyped = kb.readLong();
        System.out.println("The long that you typed as a double: " + theDoubleYouTyped);
        System.out.println("Notice that, although doubles can hold big numbers, they also can lose accuracy");
        System.out.println();
        System.out.print("Please enter two ints on this line: ");
        theIntYouTyped = kb.readInt();
        System.out.println("The program tried to read this as a single int");
        System.out.println("The int received: " + theIntYouTyped);
        System.out.println("You can only read one numeric item per line");
        System.out.println("Next, just hit Return");
        int theOtherInt = kb.readInt();
        System.out.println("The program tried to read the second int you typed");
        System.out.println("However, the second value is always ignored.");
        System.out.println("This was the second value: " + theOtherInt);
        System.out.println();
        System.out.println("The same thing happens when you try to read more than one double on a line");
        System.out.println();
        System.out.print("Please enter an int on this line (but precede it with a space): ");
        theIntYouTyped = kb.readInt();
        System.out.println("The program tried to read this ");
        System.out.println("The int received: " + theIntYouTyped);
        System.out.println();
        System.out.print("Please enter an int on this line (but follow it with a space): ");
        theIntYouTyped = kb.readInt();
        System.out.println("The program tried to read this ");
        System.out.println("The int received: " + theIntYouTyped);
        System.out.println();
        System.out.print("Please enter any string on this line: ");
        String theStringYouTyped = kb.readLine();
        System.out.println("The String received: \"" + theStringYouTyped + "\"");
        System.out.println();
        System.out.print("Enter another string with interesting white space: ");
        theStringYouTyped = kb.readLine();
        System.out.println("The String received: \"" + theStringYouTyped + "\"");
        System.out.println();
        System.out.print("Enter two ints on this line: ");
        theStringYouTyped = kb.readLine();
        System.out.println("The String received: \"" + theStringYouTyped + "\"");
        System.out.println();
        System.out.print("Enter a single char: ");
        char theCharYouTyped = kb.readChar();
        System.out.println("The char received: '" + theCharYouTyped + "'");
        System.out.println();
        System.out.print("Enter a string of at least two characters: ");
        theCharYouTyped = kb.readChar();
        System.out.println("The char received: '" + theCharYouTyped + "'");
        System.out.println();
        System.out.print("Enter a string beginning with whitespace: ");
        theCharYouTyped = kb.readChar();
        System.out.println("The char received: '" + theCharYouTyped + "'");
        System.out.println();
        System.out.print("Just hit <Enter> without typing any characters: ");
        theCharYouTyped = kb.readChar();
        System.out.println("The char received: '" + theCharYouTyped + "'");
        System.out.println();
        System.out.print("Type the following filename exactly \"test1.txt\" (without the quotes): ");
        String fileNameType = kb.readLine();
        System.out.println("Attempt to create the TextInput object for the file \"" + fileNameType + "\"");
        TextInput fileSource = new TextInput(fileNameType);
        System.out.println();
        System.out.println("You should have seen an error message printed.");
        System.out.println("The value returned by applying the isValidSource method to this object is " + fileSource.isValidSource());
        System.out.println();
        System.out.println("Next, the program will try to read a string from the file.");
        String theStringFromFile = fileSource.readLine();
        System.out.println("You should have seen an error message printed.");
        System.out.println("The string received: \"" + theStringFromFile + "\"");
        System.out.println();
        System.out.println("Next, the program will try to read an int from the file.");
        int theIntFromFile = fileSource.readInt();
        System.out.println("You should have seen an error message printed.");
        System.out.println("The int received: \"" + theIntFromFile + "\"");
        System.out.println();
        System.out.println("The remaining cases for the other primitive types are similar");
        System.out.println();
        System.out.println("The file \"test2.txt\" actually exists.");
        System.out.print("Type the abovefilename exactly (without the quotes): ");
        fileNameType = kb.readLine();
        System.out.println("Attempt to create the TextInput object for the file \"" + fileNameType + "\"");
        fileSource = new TextInput(fileNameType);
        System.out.println();
        System.out.println("The value returned by applying the isValidSource method to this new object is " + fileSource.isValidSource());
        System.out.println();
        System.out.println("The remaining lines show how the class treats the various lines:");
        String firstLine = fileSource.readLine();
        System.out.println("The first line was read as the string: \"" + firstLine + "\"");
        int secondLine = fileSource.readInt();
        System.out.println("The second line was read as the int: " + secondLine);
        double thirdLine = fileSource.readDouble();
        System.out.println("The third line was read as the double: " + thirdLine);
        char fourthLine = fileSource.readChar();
        System.out.println("The fourth line was read as the char: " + fourthLine);
        System.out.println("I'm attempting to read the last line as an int");
        int lastLine = fileSource.readInt();
        System.out.println("The value returned is " + lastLine);
    }
}

