/*
	This class is an example of a menu class
	
*/

import java.io.*;
public class Menu {

    public static final String NL = System.getProperty( "line.separator" );
	
	private String options;
	private String prompt;
	private int numberOfChoices;
    private BufferedReader keyboard;
		
	public Menu (String options, String prompt, int numberOfChoices) {
	// creates a menu object where options is a string displaying the menu choices
	// numberOfChoices is the number of menu choices, and prompt is the request
	// to the typist
	  this.options = options;
	  this.prompt = prompt;
	  this.numberOfChoices = numberOfChoices;
      keyboard = new BufferedReader (new InputStreamReader (System.in));
	}
	
	
	public void displayMenu() {
	// displays the menu	
		  System.out.println (options);
		  System.out.println ();
	}
	
	public int getChoice() {
	
	  int choice=-1;
	  String selectionString= null;
	  	 
	  while (true) {

			try {
				  System.out.print(prompt);
				  selectionString = keyboard.readLine();
				  choice = Integer.parseInt (selectionString);
				  if (0 < choice && choice <= numberOfChoices)
				      return choice;   	      
				  else
				     System.out.println("Sorry, that was not a valid menu choice.");
			}
			catch (NumberFormatException nfe) { 
		 	    System.out.println (selectionString + " is not an option. Press enter to try again.");
			}
			catch (IOException ioe) { 
			    System.out.println ("Input device error. Press enter to try again.");
			}
			displayMenu();
	 } 
  }	
}
