/*
	This is the beginning stage of a collection class for CD objects
	that encapsulates primitive arrays and their operations
	
	Added Friday 4/1:
	a) added a sort by duration (using insertionSort)
	b) added a sort by title (using selectionSort)
	
	Added Wednesday 3/20:
	a) added a compareTo to the CD class & use it with insert & delete
	b) wrote a delete method (called remove)
	
	
	Added Monday 3/28:
	a) a default toString (not discussed in class)
	b) a doubling method
	c) an insert method
	d) a two-step insert method
	
*/

public class CDCollection {

	private static final int DEFAULT_CAPACITY = 1;
	// soon we'll see that physical capacity will not be an issue
	
	// instance variables (the two pieces of information
	// associated with primitive arrays)
	private CD[] collection;
	private int size;
	
	
	// constructors
	public CDCollection (int capacity) {
		collection = new CD[capacity];
		size = 0;
	}
	
	public CDCollection () {
		this (DEFAULT_CAPACITY);
	}
	
	// accessors
	public int getSize() {
		return size;
	}
	
	public CD get(int index) {
	// returns the CD at the given index;
	// throws the ArrayIndexOutOfBoundsException even if
	// the index is logically out of bounds although not physically out of bounds
		if (index < 0 || index >= size)
			throw new ArrayIndexOutOfBoundsException ("The CD array currently only has "+ size + " elements.");
		return collection[index];
	}

	public boolean isEmpty() {
	// returns true iff the logical size is zero
		return size == 0;
	}

	public boolean exists (String t, String a) {
	// returns true if and only if the collection contains a CD
	// that matches the title (t) and artist (a)
		CD dummyCD = new CD (t,a);
		for (int i = 0; i < size; i++)
			if (dummyCD.equals (collection[i]) )
				return true;
		return false;
	}
	
	public CD search (String t, String a) {
	// Searches the collection for a CD that matches
	// the title (t) and artist (a)
		CD dummyCD = new CD (t,a);
		
		for (int i = 0; i < size; i++)
			if (dummyCD.equals (collection[i]) )
				return collection[i];
		return null;
	}
	
	public String toString () {
	// a default toString method for the CD collection
		String result = "    CDCollection[" + "used=" +size + "/length=" + collection.length + "\n";
		for (int i = 0; i < size; i++)
		    result += "      CDCollection["+i+"]= " + collection[i] + "\n";
		return result + " ]";
	}
	
	
	public CDCollection filterByArtist (String a) {
	// produces a CD collection which contains only those
	// CD's by the specified artist a
		CDCollection filtered = new CDCollection(size);
		
		for (int i = 0; i < size; i++)
			if (a.equals ( collection[i].getArtist() ))
				filtered.append( collection[i] );	
		return filtered;
	}

	public CDCollection filterByLength (int minLength) {
	// produces a CD collection which contains only those
	// CD's which are longer (in minutes) than the specified
	// integer length
		CDCollection filtered = new CDCollection(size);
		
		for (int i = 0; i < size; i++)
			if (collection[i].getRunningTime() > minLength )
				filtered.append( collection[i] );	
		return filtered;
	}

	// mutators
	
	private void doubleSize() {
	// doubles the physical capacity of the array
		//System.out.println("Annotation: doubling the array to " + 2*collection.length);
		CD[] temp = new CD[2*collection.length];	
		for (int i = 0; i < collection.length; i++)
			temp[i] = collection[i];
		collection = temp;
	}
	

	public void append ( CD theCD) {
	// adds the new CD to the end of the array
		if (size == collection.length)
			doubleSize();
		collection[size++] = theCD;
	}
	
	
	
	
	public void remove (String artist, String title) {
		
		// Stage 1: find the CD (if it is in the collection)
		// 		(Note: I did this wrong in the 8:30 class)
		CD temp = new CD(title,artist);
		
		int pos = 0;
		while (pos < size && temp.compareTo(collection[pos]) > 0)
			pos++;
		
		// we are here because either
		// a) we found the cd to remove
		// b) we discovered that the cd isn't there
		
		if (pos == size || temp.compareTo(collection[pos]) != 0)
			 // didn't find the CD
			 // generally, we find a larger CD before finding the CD we're
			 // looking for (so the CD wasn't there) BUT sometimes
			 // the CD we're looking for is larger than all CD's in the collection
			 // (i.e., when pos == size)
			return;
		
		
		
		// Stage 2: left-shift all elements to the right of pos
		
		for (int i = pos; i < size-1 ; i++)
			collection[i] = collection[i+1];
		
		// An alternative point of view (but the same work is done):	
			//for (int j = pos+1; j < size; j++)
			//	collection [j-1] = collection[j];
		
		// Don't forget to change the size after the removal
		size--;
	}
	
	
	/* ****************************************** *
		The insert done in class
	 * ****************************************** */
	 
	public void insert (CD theCD) {
	// inserts the CD into its appropriate position in the array
	// where "appropriate" is determined by the isBiggerThan method
	
		append(theCD); // adds the CD to the end of the array
		// as a side effect, doingthis also takes care of problems of full arrays
		
		int pos = size - 2; // the index of the last entry in the sorted
		// array -- The last entry in the array is at index size-1 BUT
		// we just appended the new CD so we want to start comparing with size-2
		
		while ( pos >= 0 && collection[pos].compareTo(theCD) > 0 )  {
			// the first condition is for the special case of inserting
			// an element less than all other values in the array
			
			// the new CD belongs to the left of the CD at pos
			// so, shift the old CD one to its right
			collection[pos+1] = collection[pos];
			
			// the next CD to consider is one to the left 
			pos--;
		}
		
		// we exit the loop because either
		//   a) pos = -1 (and the new CD belongs at index 0) or
		//   b) the CD at pos is the largest CD that is less than the new CD
		// In either case, the new CD belongs at pos+1
		collection[pos+1] = theCD;	
	}	

	/* ****************************************** *
		An alternate two-step insert
	 * ****************************************** */
	private int find(CD theCD) {
	// finds the location where the new CD should be inserted
		int i = 0;
		while (i < size && theCD.compareTo ( collection[i]) > 0)
			 i++;
		return i; 
	}

	private void rightShift (int startingWith) {
	// right shifts (by 1) all elements in the collection from the right of
	// startingWith inclusive
		if (size == collection.length)
			doubleSize();
		for (int i = size-1; i >= startingWith; i--)
			collection[i+1] = collection[i];	
	}
	
	public void insert2(CD theCD) {
	// inserts the cd into the appropriate position in a two stage process
	
		int pos = find(theCD);
	
		rightShift(pos);
	
		collection[pos] = theCD;
		size++; // an element has been added
	}

	/* *************************************** *
			Sorting algorithms
	 * *************************************** */

	private CDCollection shallowCopy () {
	// makes a shallow copy of the array
		CDCollection temp = new CDCollection(size);
		for (int i = 0; i < size; i++)
			temp.append( collection[i]);
		return temp;
	}
	
	public CDCollection getSortedByLength() {
	// produces another CDCollection that is sorted by length of CD
		CDCollection temp = shallowCopy();
		temp.sortByLength();
		return temp;
	}

	public CDCollection getSortedByTitle() {
		CDCollection temp = shallowCopy();
		temp.sortByTitle();
		return temp;
	}

	private void sortByLength() {
	// An example of InsertionSort
	// does an insertionSort to sort the CD's by their length
	
	
		for (int idx = 1 ; idx < size; idx++) {
		
			// wma that the array from index 0 up to (but not including) idx
			// is sorted.
			
			// We want to INSERT collection[idx] into its proper position
			
			CD temp = collection[idx];
			
			int pos = idx-1;
			while (pos >= 0 && temp.getRunningTime() < collection[pos].getRunningTime() )
				collection[pos+1] = collection[pos--];
			
			collection[pos+1] = temp;
		}	
	}
	


	private void sortByTitle () {
	// An example of SelectionSort
	// does an selectionSort to sort the CD's by their titles (ignoring duplicate titles)
	
		for (int idx = 0; idx < size-1; idx++) {
		
			// wma that array from index 0 up to (but not including) idx
			// contains the idx-most smallest elements in the array and that
			// these are in order
			
			// We want to find the (idx+1)-th smallest element in the array
			// (it will be smallest amongst the values from idx to size-1)
			// and swap it with the the element at position idx
			
			// Stage 1: find the location of the smallest
			int minAt = idx; // the location of the smallest seen so far
			for (int j = idx+1; j < size; j++)
				if (collection[j].compareTo(collection[minAt]) < 0)
					// the new smallest seen so far
					minAt = j;
		
			// now, the item at minAt is the smallest in the remainder of the array
			// we now swap the CD's at the two locations
			CD temp = collection[minAt];
			collection[minAt] = collection[idx];
			collection[idx] = temp;
		
		}
	
	}

}