/*
	This is the beginning stage of a collection class for CD objects
	that encapsulates primitive arrays and their operations
	
	Added Monday 3/28:
	a) a default toString (not discussed in class)
	b) a doubling method
	c) an insert method
	d) a two-step insert method
	
*/
public class CDCollection {

	private static final int DEFAULT_CAPACITY = 1;
	// soon we'll see that physical capacity will not be an issue
	
	// instance variables (the two pieces of information
	// associated with primitive arrays)
	private CD[] collection;
	private int size;
	
	
	// constructors
	public CDCollection (int capacity) {
		collection = new CD[capacity];
		size = 0;
	}
	
	public CDCollection () {
		this (DEFAULT_CAPACITY);
	}
	
	// accessors
	public int getSize() {
		return size;
	}
	
	public CD get(int index) {
	// returns the CD at the given index;
	// throws the ArrayIndexOutOfBoundsException even if
	// the index is logically out of bounds although not physically out of bounds
		if (index < 0 || index >= size)
			throw new ArrayIndexOutOfBoundsException ("The CD array currently only has "+ size + " elements.");
		return collection[index];
	}

	public boolean isEmpty() {
	// returns true iff the logical size is zero
		return size == 0;
	}

	public boolean exists (String t, String a) {
	// returns true if and only if the collection contains a CD
	// that matches the title (t) and artist (a)
		CD dummyCD = new CD (t,a);
		for (int i = 0; i < size; i++)
			if (dummyCD.equals (collection[i]) )
				return true;
		return false;
	}
	
	public CD search (String t, String a) {
	// Searches the collection for a CD that matches
	// the title (t) and artist (a)
		CD dummyCD = new CD (t,a);
		
		for (int i = 0; i < size; i++)
			if (dummyCD.equals (collection[i]) )
				return collection[i];
		return null;
	}
	
	public String toString () {
	// a default toString method for the CD collection
		String result = "    CDCollection[" + "used=" +size + "/length=" + collection.length + "\n";
		for (int i = 0; i < size; i++)
		    result += "      CDCollection["+i+"]= " + collection[i] + "\n";
		return result + " ]";
	}
	
	
	public CDCollection filterByArtist (String a) {
	// produces a CD collection which contains only those
	// CD's by the specified artist a
		CDCollection filtered = new CDCollection(size);
		
		for (int i = 0; i < size; i++)
			if (a.equals ( collection[i].getArtist() ))
				filtered.append( collection[i] );	
		return filtered;
	}

	public CDCollection filterByLength (int minLength) {
	// produces a CD collection which contains only those
	// CD's which are longer (in minutes) than the specified
	// integer length
		CDCollection filtered = new CDCollection(size);
		
		for (int i = 0; i < size; i++)
			if (collection[i].getRunningTime() > minLength )
				filtered.append( collection[i] );	
		return filtered;
	}

	// mutators
	
	private void doubleSize() {
	// doubles the physical capacity of the array
		System.out.println("Annotation: doubling the array to " + 2*collection.length);
		CD[] temp = new CD[2*collection.length];	
		for (int i = 0; i < collection.length; i++)
			temp[i] = collection[i];
		collection = temp;
	}
	

	public void append ( CD theCD) {
	// adds the new CD to the end of the array
		if (size == collection.length)
			doubleSize();
		collection[size++] = theCD;
	}
	
	
	/*
		All sections ended with at least this method; we'll see in the next class
		a better way to do this
	*/
	public boolean isBiggerThan(CD first, CD second) {
	// returns true iff the first is bigger than the second
		return first.getArtist().compareTo (second.getArtist()) > 0;
	}
	
	
	
	/* ****************************************** *
		The insert done in class
	 * ****************************************** */
	 
	public void insert (CD theCD) {
	// inserts the CD into its appropriate position in the array
	// where "appropriate" is determined by the isBiggerThan method
	
		append(theCD); // adds the CD to the end of the array
		// as a side effect, doingthis also takes care of problems of full arrays
		
		int pos = size - 2; // the index of the last entry in the sorted
		// array -- The last entry in the array is at index size-1 BUT
		// we just appended the new CD so we want to start comparing with size-2
		
		while ( pos >= 0 && isBiggerThan(collection[pos],theCD) ) {
			// the first condition is for the special case of inserting
			// an element less than all other values in the array
			
			// the new CD belongs to the left of the CD at pos
			// so, shift the old CD one to its right
			collection[pos+1] = collection[pos];
			
			// the next CD to consider is one to the left 
			pos--;
		}
		
		// we exit the loop because either
		//   a) pos = -1 (and the new CD belongs at index 0) or
		//   b) the CD at pos is the largest CD that is less than the new CD
		// In either case, the new CD belongs at pos+1
		collection[pos+1] = theCD;	
	}	

	/* ****************************************** *
		An alternate two-step insert
	 * ****************************************** */
	private int findInsertionPoint(CD theCD) {
	// finds the location where the new CD should be inserted
		int i = 0;
		while (i < size && isBiggerThan (theCD, collection[i]))
			 i++;
		return i; 
	}

	private void rightShift (int startingWith) {
	// right shifts (by 1) all elements in the collection from the right of
	// startingWith inclusive
		if (size == collection.length)
			doubleSize();
		for (int i = size-1; i >= startingWith; i--)
			collection[i+1] = collection[i];	
	}
	
	public void insert2(CD theCD) {
	// inserts the cd into the appropriate position in a two stage process
	
		int pos = findInsertionPoint(theCD);
	
		rightShift(pos);
	
		collection[pos] = theCD;
		size++; // an element has been added
	}
	
}