/*
	This class represents a simple version of
	the Compact Disk class.
	
	CD objects are distinquished by examining the name of the CD
	and the artist producing the CD 
	
	A few other attributes are currently included.
	There are other attributes of a CD that can be added later.
	
*/

public class CD {
	
	public final static int SECONDS_PER_MINUTE = 60;
	
	// instance variables
	private String title,
				   artist;
	private int tracks;
	private int runningTime; // in seconds
	
	
	/* ******************************** *
	 * 		Constructors				*
	 * ******************************** */
	 
	public CD (String recordingTitle, String artistName, 
				int numTracks,
				int totalMinutes, int remainingSeconds) {
	// this constructor initializes all instance variables
	// the object being created
		title = recordingTitle;
		artist = artistName;			
		tracks = numTracks;
		runningTime = SECONDS_PER_MINUTE*totalMinutes + remainingSeconds;
	}
	
	public CD (String recordingTitle, String artistName) {
	// this constructor initializes the minimal number of
	// instance variables of the object being created
		this (recordingTitle,artistName,0,0,0);
	}
	
	/* ******************************** *
	 * 		Accessors					*
	 * ******************************** */
	 
	public String getTitle() {
		return title;
	}
	public String getArtist() {
		return artist;
	}

	public int getNumberOfTracks() {
		return tracks;
	}

	public int getRunningTimeMinutes() {
		return runningTime/SECONDS_PER_MINUTE;
	}
	public int getRunningTimeSeconds() {
		return runningTime%SECONDS_PER_MINUTE;
	}	
	public double getRunningTime() {
		return (double)runningTime/SECONDS_PER_MINUTE;
	}	

	public boolean equals(Object o) {
	// two CD's are considered equal if the artist's names
	// and the CD titles match.
		CD second = (CD)o;
		return artist.equals(second.artist) &&
				title.equals(second.title);
	}

	public String toString () {
		if (tracks == 0)
			return title + "," + artist;
		else
			return title + "," + artist + "," + tracks + "," + runningTime;	
	}
	
	
	/* ******************************** *
	 * 		Mutators					*
	 * ******************************** */

	public void setTracks (int numTracks) {
		tracks = numTracks;
	}
	
	public void setRunningTime(int totalMinutes, int totalSeconds) {
		runningTime = totalMinutes*SECONDS_PER_MINUTE + totalSeconds;
	}
	
	public void setRunningTime(double time) {
		runningTime = (int)(time*SECONDS_PER_MINUTE);
	}

}