/*
	This is the beginning stage of a collection class for CD objects
	that encapsulates primitive arrays and their operations
	
*/
public class CDCollection {

	private static final int DEFAULT_CAPACITY = 35;
	// soon we'll see that physical capacity will not be an issue
	
	// instance variables (the two pieces of information
	// associated with primitive arrays)
	private CD[] collection;
	private int size;
	
	
	// constructors
	public CDCollection (int capacity) {
		collection = new CD[capacity];
		size = 0;
	}
	
	public CDCollection () {
		this (DEFAULT_CAPACITY);
	}
	
	// accessors
	public int getSize() {
		return size;
	}
	
	public CD get(int index) {
	// returns the CD at the given index;
	// throws the ArrayIndexOutOfBoundsException even if
	// the index is logically out of bounds although not physically out of bounds
		if (index < 0 || index >= size)
			throw new ArrayIndexOutOfBoundsException ("The CD array currently only has "+ size + " elements.");
		return collection[index];
	}

	public boolean isEmpty() {
	// returns true iff the logical size is zero
		return size == 0;
	}

	public boolean exists (String t, String a) {
	// returns true if and only if the collection contains a CD
	// that matches the title (t) and artist (a)
		CD dummyCD = new CD (t,a);
		for (int i = 0; i < size; i++)
			if (dummyCD.equals (collection[i]) )
				return true;
		return false;
	}
	
	public CD search (String t, String a) {
	// Searches the collection for a CD that matches
	// the title (t) and artist (a)
		CD dummyCD = new CD (t,a);
		
		for (int i = 0; i < size; i++)
			if (dummyCD.equals (collection[i]) )
				return collection[i];
		return null;
	}
	
	
	public CDCollection filterByArtist (String a) {
	// produces a CD collection which contains only those
	// CD's by the specified artist a
		CDCollection filtered = new CDCollection(size);
		
		for (int i = 0; i < size; i++)
			if (a.equals ( collection[i].getArtist() ))
				filtered.append( collection[i] );	
		return filtered;
	}

	public CDCollection filterByLength (int minLength) {
	// produces a CD collection which contains only those
	// CD's which are longer (in minutes) than the specified
	// integer length
		CDCollection filtered = new CDCollection(size);
		
		for (int i = 0; i < size; i++)
			if (collection[i].getRunningTime() > minLength )
				filtered.append( collection[i] );	
		return filtered;
	}
	
	
	// mutators
	public void append ( CD theCD) {
		collection[size++] = theCD;
	}	
}