/*
	For today's update tothe array list demo, I've added
	two different ways to search for an item in the ArrayList
	
	Unlike what we did in class, the two techniques have each been
	written as methods. Although I could have used the same format for
	both methods, I used two different styles.
	
	Written by Jeff Carroll 3/16/05
*/

import java.util.*;
public class ArrayListDemo {

	public static TextInput kb = new TextInput();

	public static void main(String args[]) {
		System.out.println("Array List Demo");
		System.out.println("Aquarium inventory program");

		//At first, we hard coded the fish into the inventory
				
		/* 				
		ArrayList aquariumInventory = new ArrayList();
		aquariumInventory.add ( new Fish ("Tetra", 250, 0.75) );	
		aquariumInventory.add ( new Fish ("Guppy", 500,0.50) );
		aquariumInventory.add ( new Fish ("Electric Eel", 5, 25.0) );		
		aquariumInventory.add ( new Fish ("Oscar", 50, 7.50) );		
		*/
		
		// Here, we read the inventory from a file
		
		TextInput src = getFile("What is the aquarium inventory file?");
		
		ArrayList aquariumInventory = readInventory(src);
		System.out.println();
		
		System.out.println("Fish Inventory contents");
		displayList(aquariumInventory);
		System.out.println();
		
		
		System.out.println ("General search: ");
		System.out.print ("What is the name of the fish you would like to buy? ");
		String fishName = kb.readLine();

		Fish resultFish = doGeneralSearch(aquariumInventory,fishName);
		if (resultFish != null)
			System.out.println ("We have " + resultFish.getOnHand() + " available for $" +
							resultFish.getCost() + " apiece");
		else
			System.out.println ("Sorry, we don't carry that species");
			
					
		System.out.println();
		System.out.println ("Search via ArrayList's IndexOf: ");
		System.out.print ("What is the name of the fish you would like to buy? ");
		fishName = kb.readLine();
		doKeySearch(aquariumInventory,fishName);		
	}
	
	public static Fish doGeneralSearch (ArrayList fl, String fName) {
	// Searches fl (the array list storing the fish inventory) for
	// a fish whose name matches fName. If found, the object is returned,
	// if not found, null is returned
	
	// This search method can be generalized to search for any
	// characteristic by changing the boolean test in the conditional
	// of the while loop
		int idx = 0;
		Fish f = null;
		while (idx < fl.size()) {
			f = (Fish)fl.get(idx);
			if (f.getName().equals(fName))
				break;
			idx++;
		}
		if (idx < fl.size())
			return f;
		else
			return null;
	}
	
	public static void doKeySearch (ArrayList fl, String fName) {
	// Searches fl (the array list storing the fish inventory) for
	// a fish whose name matches fName (which is the key value of the object Fish)
	
	// This search method can only be used for searching on the object's key value
	// as defined by the equals method of the class Fish.

		Fish searchFish = new Fish(fName,0,0);
		
		int idx = fl.indexOf(searchFish);
	
		if (idx != -1) { // Alternatively, use 
						 // if (fl.contains(searchFish)){
			Fish f = (Fish)fl.get(idx);
			System.out.println ("We have " + f.getOnHand() + " available for $" +
							f.getCost() + " apiece");		
		}
		else
			System.out.println ("Sorry, we don't carry that species");
	}
	
	public static void displayList(ArrayList fl){
	// Displays the contents of fl (the array list storing the fish inventory)
		for (int idx = 0; idx < fl.size(); idx++) {		
			Fish f = (Fish)fl.get(idx);
			System.out.println (f.getName() + ": there are " + f.getOnHand() +
						" on hand and each one costs $" + f.getCost());
		}
	}
	
	
	
	public static ArrayList readInventory(TextInput src) {
	// Assuming that the TextInput src (source) is valid and
	// corresponds to a formatted file of Fish objects,
	// this method reads the entire file and returns an ArrayList
	// of the Fish that were read
		ArrayList a = new ArrayList();
		while (!src.atEndOfFile()) {
			Fish f = readFish(src);
			a.add(f);
		}
		return a;
	}
	
		
	public static Fish readFish(TextInput src) {
	// reads from the src TextInput file (assuming it corresponds
	// to a file of Fish) enough information to create one fish object.
		String n = src.readLine();
		int q = src.readInt();
		double p = src.readDouble();
		return new Fish (n,q,p);
	}
	
	public static TextInput getFile (String prompt) {
	// a method we've used in the past
	// This method continually prompts the typist for the name of a
	// file. This doesn't guarentee that the file is formatted correctly.
		System.out.print(prompt+" ");
		String fName = kb.readLine();
		TextInput src = new TextInput(fName);
		while (!src.isValidSource()) {
			System.out.println ("Sorry, the file doesn't exist or you don't have read privileges");
			System.out.println ("Choose another file");
			System.out.print(prompt+" ");
			fName = kb.readLine();
			src = new TextInput(fName);		
		}	
		return src;
	}

}
