/*
	This program demonstrates
	a) the simple use of an ArrayList; and
	b) how to read a formatted file of objects and load it into
	   an ArrayList
*/

import java.util.*;
public class ArrayListDemo {

	public static TextInput kb = new TextInput();

	public static void main(String args[]) {
		System.out.println("Array List Demo");
		System.out.println("Aquarium inventory program");

		//At first, we hard coded the fish into the inventory
				
		/* 				
		ArrayList aquariumInventory = new ArrayList();
		aquariumInventory.add ( new Fish ("Tetra", 250, 0.75) );	
		aquariumInventory.add ( new Fish ("Guppy", 500,0.50) );
		aquariumInventory.add ( new Fish ("Electric Eel", 5, 25.0) );		
		aquariumInventory.add ( new Fish ("Oscar", 50, 7.50) );		
		*/
		
		// Here, we read the inventory from a file
		
		TextInput src = getFile("What is the aquarium inventory file?");
		ArrayList aquariumInventory = readInventory(src);
		System.out.println();
		
		for (int idx = 0; idx < aquariumInventory.size(); idx++) {
		
			// System.out.println ( aquariumInventory.get(idx) );
		
			Fish f = (Fish)aquariumInventory.get(idx);
			System.out.println (f.getName() + ": there are " + f.getOnHand() +
						" on hand and each one costs $" + f.getCost());
		}
	
	}
	
	
	public static ArrayList readInventory(TextInput src) {
	// Assuming that the TextInput src (source) is valid and
	// corresponds to a formatted file of Fish objects,
	// this method reads the entire file and returns an ArrayList
	// of the Fish that were read
		ArrayList a = new ArrayList();
		while (!src.atEndOfFile()) {
			Fish f = readFish(src);
			a.add(f);
		}
		return a;
	}
	
		
	public static Fish readFish(TextInput src) {
	// reads from the src TextInput file (assuming it corresponds
	// to a file of Fish) enough information to create one fish object.
		String n = src.readLine();
		int q = src.readInt();
		double p = src.readDouble();
		return new Fish (n,q,p);
	}
	
	public static TextInput getFile (String prompt) {
	// a method we've used in the past
	// This method continually prompts the typist for the name of a
	// file. This doesn't guarentee that the file is formatted correctly.
		System.out.print(prompt+" ");
		String fName = kb.readLine();
		TextInput src = new TextInput(fName);
		while (!src.isValidSource()) {
			System.out.println ("Sorry, the file doesn't exist or you don't have read privileges");
			System.out.println ("Choose another file");
			System.out.print(prompt+" ");
			fName = kb.readLine();
			src = new TextInput(fName);		
		}	
		return src;
	}

}
