/* The class ball is a thread which draws a moving ball
   on the canvas provided (via the constructor)
 */

import java.awt.*;
public class Ball extends Thread {

	private static final int minX = 0, minY = 0;

	Ball (Canvas c, int w, int h, int startX, int startY) {

		this.c = c;

		width = w;
		height = h;
		xLoc = startX;
		yLoc = startY;
		
		diameter = 10;
		bColor = Color.red;
		deltaX = 7;
		deltaY = 4;
	}

	public Color getColor () {
		return bColor;
	}
	public void setColor (Color c) {
		bColor = c;
	}
	
	public int getDiameter () {
		return diameter;
	}
	public void setDiameter (int d) {
		diameter = d;
	}

	public void toggleMode () {
		BilliardMode = !BilliardMode;
	}
		
	public int getX () {
		return xLoc;
	}
	public int getY () {
		return yLoc;
	}

	public void setDirection (int deltaW, int deltaH) {
		deltaX = deltaW;
		deltaY = deltaH;
	}

	public void move () {
		xLoc += deltaX;
		yLoc += deltaY;
		if (BilliardMode)
			moveBilliard();
		else 
			moveSphere();
	}

	public void moveSphere () {
		if (xLoc > width)
			xLoc -= width;
		else if (xLoc < minX)
			xLoc = minX - xLoc;
		if (yLoc > height)
			yLoc -= height;
		else if (yLoc < minY)
			yLoc = minY - yLoc;	
	}

	public void moveBilliard () {
		if (xLoc+diameter > width || xLoc < minX) {
			xLoc -= deltaX;
			deltaX = -deltaX;
		}
		if (yLoc+diameter > height || yLoc < minY) {
			yLoc -= deltaY;
			deltaY = -deltaY;
		}
	}
	
	public void run () {
	// a presupposed method of any class extending thread
	// When a thread is started, it will call this method.
	// The run method indicates what the thread is supposed
	// to do (essentially, it is the "main" program for
	// a thread)
	
		Graphics gc = c.getGraphics ();
		Color bg = c.getBackground();
		
		while (keepRunning) {
			if (keepDrawing) {
				// erase the old ball
				gc.setColor (bg);
				gc.fillOval(xLoc,yLoc,diameter,diameter);
				move ();
				// draw the new ball
				gc.setColor (bColor);
				gc.fillOval(xLoc,yLoc,diameter,diameter);
				// this is needed to slow down the drawing
				try {
					sleep (20);
				} catch (Exception e) {}
			}
		}
	}
	
	public void suspendMe () {
	 	// the thread class has a suspend method but it is kept
	 	// secure (it is a "final", or constant, method) which cannot
	 	// be "overridden". This was not the case with previous
	 	// versions of Java.
	 	// Here, we want to provide a method to imitate
	 	// suspending the CURRENT thread (i.e., this thread object)
		keepDrawing = false;
	}
	
	public void resumeMe () {
	// like suspend, resume is a final method
		keepDrawing = true;
		c.repaint();
	}
	
	public void stopMe () {
	// ditto
		keepRunning = false;
	}
	
	private int width, height; // area for balls to move in
	private int diameter; // size of ball
	private int xLoc,yLoc;	// location of ball
	private int deltaX,deltaY; // direction of ball

	private Canvas c;
	private Color bColor;

	private boolean keepDrawing = true;
	private boolean keepRunning = true;
	private boolean BilliardMode = true;
}