/*
	An applet that uses threads to extend 
	the moving ball applet
	
*/

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;
import java.util.*;

public class BallApplet extends Applet implements ActionListener
{

	private static final int Width = 500;
	private static final int Height = 300;

	private static final int minBallDiameter = 16, 
							 maxBallDiameter = 32;

	private static Random rpg = new Random();


	private Canvas c;
	private Button wait, stop, launch;
	private ArrayList Balls = new ArrayList();
	
	public void init() {
		c = new Canvas();
		c.setSize(Width,Height);
		c.setBackground(Color.green);

		wait = new Button ("Pause");
		wait.addActionListener(this);
		stop = new Button ("Stop");
		stop.addActionListener(this);
		launch = new Button("Launch");
		launch.addActionListener(this);
		
		Panel s = new Panel(new BorderLayout());
		s.add("North",wait);
		s.add("South", stop);
		
		Panel l = new Panel();
		l.add(launch);
		
		Panel p = new Panel (new BorderLayout());
		p.add("Center",l);
		p.add("South",s);
		
		setLayout (new BorderLayout());
		add ("West",p);
		add ("East",c);

		repaint();
	}
	
	
	public void actionPerformed (ActionEvent ae) {
	
		String s = ae.getActionCommand();
		if ( s.equals("Pause") ) {
			wait.setLabel("Resume");
			Iterator e = Balls.iterator();
			while (e.hasNext()) {
				Ball b = (Ball) e.next();
				b.suspendMe();
			}
		}
		else if (s.equals ("Resume") ){
			wait.setLabel("Pause");
			Iterator e = Balls.iterator();
			while (e.hasNext()) {
				Ball b = (Ball) e.next();
				b.resumeMe();
			}
		}
		else if (s.equals ("Stop") ) {
			Iterator e = Balls.iterator();
			while (e.hasNext()) {
				Ball b = (Ball) e.next();
				b.stopMe();
			}
		}
		else {
			Ball b = getRandomBall();
			b.start();
			Balls.add(b);
		}
	}

	private Ball getRandomBall() {
	// generates a "random" ball

		int newD = rpg.nextInt(maxBallDiameter-minBallDiameter) + minBallDiameter;
				
		Ball b = new Ball (c,Width,Height,
						rpg.nextInt(Width-newD),
						rpg.nextInt(Height-newD));
		b.setDiameter(newD);
	
		Color rc = new Color (rpg.nextInt(256), rpg.nextInt(256),rpg.nextInt(256));
		b.setColor(rc);	
			
		int xdir = rpg.nextInt(10)+1;
		int ydir = rpg.nextInt(10)+1;
		switch(rpg.nextInt(4)) {
			case 1:
				xdir = -xdir;break;
			case 2:
				ydir = -ydir;
			case 3:
				xdir = -xdir;break;
			default:
				break;
		}
		
		b.setDirection(xdir, ydir);
		return b;
	}

	
}
