import java.awt.*;
public class Ball {

	private static final int minX = 0, minY = 0;

	Ball (int w, int h, int startX, int startY) {
		width = w;
		height = h;
		xLoc = startX;
		yLoc = startY;
		
		diameter = 10;
		bColor = Color.red;
		deltaX = 7;
		deltaY = 4;
		BilliardMode = false;
	}

	public Color getColor () {
		return bColor;
	}
	public void setColor (Color c) {
		bColor = c;
	}
	
	public int getDiameter () {
		return diameter;
	}
	public void setDiameter (int d) {
		diameter = d;
	}

	public void toggleMode () {
		BilliardMode = !BilliardMode;
	}
		
	public int getX () {
		return xLoc;
	}
	public int getY () {
		return yLoc;
	}

	public void setDirection (int deltaW, int deltaH) {
		deltaX = deltaW;
		deltaY = deltaH;
	}

	public void move () {
		xLoc += deltaX;
		yLoc += deltaY;
		if (BilliardMode)
			moveBilliard();
		else 
			moveSphere();
	}

	public void moveSphere () {
		if (xLoc > width)
			xLoc -= width;
		else if (xLoc < minX)
			xLoc = minX - xLoc;
		if (yLoc > height)
			yLoc -= height;
		else if (yLoc < minY)
			yLoc = minY - yLoc;	
	}

	public void moveBilliard () {
		if (xLoc+diameter > width || xLoc < minX) {
			xLoc -= deltaX;
			deltaX = -deltaX;
		}
		if (yLoc+diameter > height || yLoc < minY) {
			yLoc -= deltaY;
			deltaY = -deltaY;
		}
	}
	
	private int width, height; // area for balls to move in
	private int diameter; // size of ball
	private int xLoc,yLoc;	// location of ball
	private int deltaX,deltaY; // direction of ball

	private Color bColor;

	private boolean BilliardMode; 
	// determines how the ball acts at boundaries
}