/*
	An applet that uses threads to extend 
	the moving ball applet
*/

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;
public class BallApplet extends Applet implements ActionListener
{

	private static final int Width = 500;
	private static final int Height = 300;

	public void init() {
		c = new Canvas();
		c.setSize(Width,Height);

		b = new Button ("Pause");
		b.addActionListener(this);
		
		Panel p = new Panel ();
		p.add(b);
		
		setLayout (new BorderLayout());
		add ("West",p);
		add ("East",c);
		
		repaint();
	}
	
	public void paint( Graphics g ) {
	
		Graphics gc = c.getGraphics ();
		// painting should occur on the canvas,
		// not the applet as a whole
	
		Color bg = c.getBackground();

		Ball b = new Ball (Width,Height,250,150);
		b.toggleMode();
		
		while (keepDrawing) {
		
			// erase the old ball
			gc.setColor (bg);
			gc.fillOval(b.getX(),b.getY(),b.getDiameter(),b.getDiameter());

			b.move ();

			// draw the new ball
			gc.setColor (b.getColor());
			gc.fillOval(b.getX(),b.getY(),b.getDiameter(),b.getDiameter());
		
			// this is needed to slow down the drawing
			try {
				Thread.sleep (20);
			} catch (Exception e) {}

		}
	}
	
	public void actionPerformed (ActionEvent ae) {
	
		String s = ae.getActionCommand();
		if ( s.equals("Pause") ) {
			b.setLabel("Resume");
			keepDrawing = true;
			}
		else {
			b.setLabel("Pause");
			keepDrawing = false;
			}
		repaint();
	}
	
	private Canvas c;
	private Button b;
	private boolean keepDrawing = true;
}
