/*
	This program interfaces between the typist/player 
	and the GridGame itself. 

	The interface is not very robust. The typist must
	be careful to enter two integers for every guess.

	Additionally, only one game may be played (instead of
	multiple games) and the player/typist cannot choose the
	dimensions to play
	
	Written by Jeff Carroll 11/12,14/03
*/
import java.io.*;
import java.util.*;
public class PlayGridGames {


	public static BufferedReader kb = new BufferedReader(
						new InputStreamReader(System.in));
	
	public static void main(String args[]) {
		System.out.println("Welcome to Grid Game");
	
		// Initially, we played with a fixed game
		// GridGame g = new GridGame();

		GridGame g = new GridGame(8,6,10);	

		boolean wantsToQuit = false;		
		do {
			System.out.println();
			System.out.println(g.display(false));
	
			System.out.print ("Make a guess (row  col) : ");
			try {
				String s = kb.readLine();
				StringTokenizer st = new StringTokenizer(s);
				int row = Integer.parseInt(st.nextToken());
				int col = Integer.parseInt(st.nextToken());

				if (g.makeGuess(row,col) )
					System.out.println("You found a treasure.");
				else
					System.out.println("Sorry, not there.");
				System.out.println("Your score is now " + g.getScore());

			} catch (Exception e) {
				// kludge: if two ints are not typed;
				// we assume player wants to quit
				wantsToQuit = true;
			}		
	
		} while (!wantsToQuit && !g.isOver());
		System.out.println("\nYour final score is " + g.getScore());
		
		if (g.isOver())
			System.out.println("Congratulations. You won.");
		else {
			System.out.println ("Giving up? Better luck next time.");
			System.out.println ("Here's the solution.");
			System.out.println (g.display(true));
		}
	}
}
